/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class InverseContext {
    private final Map<String, Map<String, Map<String, Map<String, String>>>> context = new LinkedHashMap<String, Map<String, Map<String, Map<String, String>>>>();

    private void set(String variable, String container2, String type, String key, String value) {
        this.context.computeIfAbsent(variable, x -> new LinkedHashMap()).computeIfAbsent(container2, x -> new LinkedHashMap()).computeIfAbsent(type, x -> new LinkedHashMap()).put(key, value);
    }

    private boolean doesNotContain(String variable, String container2, String type, String key) {
        return !this.context.containsKey(variable) || !this.context.get(variable).containsKey(container2) || !this.context.get(variable).get(container2).containsKey(type) || !this.context.get(variable).get(container2).get(type).containsKey(key);
    }

    public boolean contains(String variable) {
        return this.context.containsKey(variable);
    }

    public boolean contains(String variable, String container2, String type) {
        return this.context.containsKey(variable) && this.context.get(variable).containsKey(container2) && this.context.get(variable).get(container2).containsKey(type);
    }

    public boolean contains(String variable, String container2, String type, String key) {
        return this.contains(variable) && this.context.get(variable).containsKey(container2) && this.context.get(variable).get(container2).containsKey(type) && this.context.get(variable).get(container2).get(type).containsKey(key);
    }

    public InverseContext setIfAbsent(String variable, String container2, String type, String key, String value) {
        if (this.doesNotContain(variable, container2, type, key)) {
            this.set(variable, container2, type, key, value);
        }
        return this;
    }

    public Optional<String> get(String variable, String container2, String type, String key) {
        if (this.doesNotContain(variable, container2, type, key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.context.get(variable).get(container2).get(type).get(key));
    }
}

