/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterUnion
extends QueryIterRepeatApply {
    protected List<Op> subOps;

    public QueryIterUnion(QueryIterator input, List<Op> subOps, ExecutionContext context2) {
        super(input, context2);
        this.subOps = subOps;
    }

    @Override
    protected QueryIterator nextStage(final Binding binding) {
        final Iterator<Op> subOpIt = this.subOps.iterator();
        return new QueryIter(this.getExecContext()){
            QueryIterator qIter;
            {
                super(execCxt);
                this.qIter = null;
            }

            @Override
            protected void requestCancel() {
                1.performRequestCancel(this.qIter);
            }

            @Override
            protected Binding moveToNextBinding() {
                return (Binding)this.qIter.next();
            }

            @Override
            protected boolean hasNextBinding() {
                while (true) {
                    if (this.qIter != null) {
                        if (this.qIter.hasNext()) {
                            return true;
                        }
                        this.qIter.close();
                        this.qIter = null;
                        continue;
                    }
                    if (!subOpIt.hasNext()) break;
                    Op subOp = (Op)subOpIt.next();
                    this.qIter = QC.execute(subOp, binding, this.getExecContext());
                }
                return false;
            }

            @Override
            protected void closeIterator() {
                1.performClose(this.qIter);
            }

            @Override
            public void output(IndentedWriter out, SerializationContext sCxt) {
                QueryIterator subIter = this.qIter;
                out.println(Lib.className(this) + "/" + Lib.className(subIter));
                if (subIter != null) {
                    out.incIndent();
                    subIter.output(out, sCxt);
                    out.decIndent();
                }
            }
        };
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Lib.className(this));
        out.incIndent();
        for (Op op : this.subOps) {
            op.output(out, sCxt);
        }
        out.decIndent();
        out.ensureStartOfLine();
    }
}

