/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind;

import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Version;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.util.LegacyNamespaces;

public final class Context
extends MarshalContext {
    public static final int MARSHALLING = 1;
    public static final int SUBSTITUTE_LANGUAGE = 2;
    public static final int SUBSTITUTE_COUNTRY = 4;
    public static final int SUBSTITUTE_FILENAME = 8;
    public static final int SUBSTITUTE_MIMETYPE = 16;
    public static final int LEGACY_METADATA = 32;
    public static final int LENIENT_UNMARSHAL = 64;
    private static final int CLEAR_SEMAPHORE = 128;
    private static final ThreadLocal<Context> CURRENT = new ThreadLocal();
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.xml");
    final int bitMasks;
    private final Deque<Locale> locales;
    private final TimeZone timezone;
    private final Map<String, String> schemas;
    private final Version versionGML;
    private final ReferenceResolver resolver;
    private final ValueConverter converter;
    private final Map<String, Object> identifiers;
    private final Map<Object, String> identifiedObjects;
    private final Filter logFilter;
    private PropertyType<?, ?> wrapper;
    private final Context previous;

    public Context(int bitMasks, Locale locale, TimeZone timezone2, Map<String, String> schemas, Version versionGML, Version versionMetadata, ReferenceResolver resolver, ValueConverter converter, Filter logFilter) {
        if (versionMetadata != null && versionMetadata.compareTo(LegacyNamespaces.VERSION_2014) < 0) {
            bitMasks |= 0x20;
        }
        this.locales = new LinkedList<Locale>();
        this.timezone = timezone2;
        this.schemas = schemas;
        this.versionGML = versionGML;
        this.resolver = resolver;
        this.converter = converter;
        this.logFilter = logFilter;
        this.identifiers = new HashMap<String, Object>();
        this.identifiedObjects = new IdentityHashMap<Object, String>();
        if (locale != null) {
            this.locales.add(locale);
        }
        this.previous = CURRENT.get();
        if ((bitMasks & 1) != 0 && !Semaphores.queryAndSet(1)) {
            bitMasks |= 0x80;
        }
        this.bitMasks = bitMasks;
        CURRENT.set(this);
    }

    @Override
    public final Locale getLocale() {
        return this.locales.peekLast();
    }

    @Override
    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    @Override
    public final Version getVersion(String prefix) {
        switch (prefix) {
            case "gml": {
                return this.versionGML;
            }
            case "gmd": {
                if ((this.bitMasks & 1) == 0) break;
                return (this.bitMasks & 0x20) == 0 ? LegacyNamespaces.VERSION_2016 : LegacyNamespaces.VERSION_2007;
            }
        }
        return null;
    }

    public static Context current() {
        return CURRENT.get();
    }

    public static void push(Locale locale) {
        Context current = Context.current();
        if (current != null) {
            if (locale == null) {
                locale = current.getLocale();
            }
            current.locales.addLast(locale);
        }
    }

    public static void pull() {
        Context current = Context.current();
        if (current != null) {
            current.locales.removeLast();
        }
    }

    public static boolean isFlagSet(Context context2, int flag) {
        return context2 != null && (context2.bitMasks & flag) != 0;
    }

    public static boolean isGMLVersion(Context context2, Version version2) {
        Version versionGML;
        if (context2 != null && (versionGML = context2.versionGML) != null) {
            return versionGML.compareTo(version2) >= 0;
        }
        return true;
    }

    public static StringBuilder schema(Context context2, String key, String defaultSchema) {
        String schema;
        Map<String, String> schemas;
        StringBuilder buffer = new StringBuilder(128);
        if (context2 != null && (schemas = context2.schemas) != null && (schema = schemas.get(key)) != null) {
            defaultSchema = schema;
        }
        buffer.append(defaultSchema);
        int length = buffer.length();
        if (length != 0 && buffer.charAt(length - 1) != '/') {
            buffer.append('/');
        }
        return buffer;
    }

    public static PropertyType<?, ?> getWrapper(Context context2) {
        return context2 != null ? context2.wrapper : null;
    }

    public static void setWrapper(Context context2, PropertyType<?, ?> wrapper) {
        if (context2 != null) {
            context2.wrapper = wrapper;
        }
    }

    public static String getObjectID(Context context2, Object object) {
        return context2 != null ? context2.identifiedObjects.get(object) : null;
    }

    public static Object getObjectForID(Context context2, String id) {
        return context2 != null ? context2.identifiers.get(id) : null;
    }

    public static boolean setObjectForID(Context context2, Object object, String id) {
        if (context2 != null) {
            Object existing = context2.identifiers.putIfAbsent(id, object);
            if (existing != null) {
                return existing == object;
            }
            if (context2.identifiedObjects.put(object, id) != null) {
                throw new CorruptedObjectException(id);
            }
        }
        return true;
    }

    public static ReferenceResolver resolver(Context context2) {
        ReferenceResolver resolver;
        if (context2 != null && (resolver = context2.resolver) != null) {
            return resolver;
        }
        return ReferenceResolver.DEFAULT;
    }

    public static ValueConverter converter(Context context2) {
        ValueConverter converter;
        if (context2 != null && (converter = context2.converter) != null) {
            return converter;
        }
        return ValueConverter.DEFAULT;
    }

    public static void warningOccured(Context context2, Level level, Class<?> classe, String method, Throwable exception, Class<? extends IndexedResourceBundle> resources, short key, Object ... arguments) {
        Filter logFilter;
        LogRecord record;
        Locale locale;
        Locale locale2 = locale = context2 != null ? context2.getLocale() : null;
        if (resources != null) {
            IndexedResourceBundle bundle;
            if (resources == Errors.class) {
                bundle = Errors.getResources(locale);
            } else if (resources == Messages.class) {
                bundle = Messages.getResources(locale);
            } else {
                throw new IllegalArgumentException(String.valueOf(resources));
            }
            record = bundle.getLogRecord(level, key, arguments);
        } else {
            record = new LogRecord(level, Exceptions.formatChainedMessages(locale, null, exception));
        }
        record.setSourceClassName(classe.getCanonicalName());
        record.setSourceMethodName(method);
        record.setLoggerName("org.apache.sis.xml");
        if (context2 != null && (logFilter = context2.logFilter) != null) {
            record.setThrown(exception);
            if (!logFilter.isLoggable(record)) {
                return;
            }
        }
        LOGGER.log(record);
    }

    public static void warningOccured(Context context2, Class<?> classe, String method, Class<? extends IndexedResourceBundle> resources, short key, Object ... arguments) {
        Context.warningOccured(context2, Level.WARNING, classe, method, null, resources, key, arguments);
    }

    public static void warningOccured(Context context2, Class<?> classe, String method, Exception cause, boolean isWarning) {
        Context.warningOccured(context2, isWarning ? Level.WARNING : Level.FINE, classe, method, cause, null, (short)0, (Object[])null);
    }

    public final void finish() {
        if ((this.bitMasks & 0x80) != 0) {
            Semaphores.clear(1);
        }
        if (this.previous != null) {
            CURRENT.set(this.previous);
        } else {
            CURRENT.remove();
        }
    }
}

