/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.StringRanges;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderMatch;

public class EncoderSet {
    private final ConcurrentHashMap<String, EncoderMatch> cache = new ConcurrentHashMap();
    private final List<String> encodings;
    private final Encoder[] encodingsEncoders;
    private final Encoder[] entries;

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    private static Encoder instantiate(BeanStore bs, Object o) {
        if (o instanceof Encoder) {
            Encoder o2 = (Encoder)o;
            return o2;
        }
        try {
            return bs.createBean(Encoder.class).type((Class)o).run();
        }
        catch (ExecutableException e) {
            throw ThrowableUtils.toRex((Throwable)e);
        }
    }

    protected EncoderSet(Builder builder) {
        this.entries = (Encoder[])builder.entries.stream().map(x -> EncoderSet.instantiate(builder.beanStore(), x)).toArray(Encoder[]::new);
        List lc = CollectionUtils.list((Object[])new String[0]);
        List l = CollectionUtils.list((Object[])new Encoder[0]);
        for (Encoder e : this.entries) {
            for (String c : e.getCodings()) {
                lc.add(c);
                l.add(e);
            }
        }
        this.encodings = CollectionUtils.u((List)lc);
        this.encodingsEncoders = l.toArray(new Encoder[l.size()]);
    }

    public Encoder getEncoder(String encoding) {
        EncoderMatch em = this.getEncoderMatch(encoding);
        return em == null ? null : em.getEncoder();
    }

    public EncoderMatch getEncoderMatch(String acceptEncoding) {
        EncoderMatch em = this.cache.get(acceptEncoding);
        if (Utils.nn((Object)em)) {
            return em;
        }
        StringRanges ae = StringRanges.of(acceptEncoding);
        int match = ae.match(this.encodings);
        if (match >= 0) {
            em = new EncoderMatch(this.encodings.get(match), this.encodingsEncoders[match]);
            this.cache.putIfAbsent(acceptEncoding, em);
        }
        return this.cache.get(acceptEncoding);
    }

    public List<String> getSupportedEncodings() {
        return this.encodings;
    }

    public static class Builder
    extends BeanBuilder<EncoderSet> {
        List<Object> entries;
        Builder inheritFrom;

        private static String toString(Object o) {
            if (o == null) {
                return "null";
            }
            if (o instanceof Class) {
                return "class:" + Utils.cns((Object)o);
            }
            return "object:" + Utils.cns((Object)o);
        }

        protected Builder(BeanStore beanStore) {
            super(EncoderSet.class, beanStore);
            this.entries = CollectionUtils.list((Object[])new Object[0]);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.entries = CollectionUtils.copyOf(copyFrom.entries);
        }

        public Builder add(Class<?> ... values) {
            List l = CollectionUtils.list((Object[])new Object[0]);
            for (Class<?> v : values) {
                if (!Utils.cns(v).equals("NoInherit")) continue;
                this.clear();
            }
            for (Class<?> v : values) {
                if (Encoder.class.isAssignableFrom(v)) {
                    l.add(v);
                    continue;
                }
                if (Utils.cns(v).equals("NoInherit")) continue;
                throw ThrowableUtils.illegalArg((String)"Invalid type passed to EncoderSet.Builder.add(): {0}", (Object[])new Object[]{Utils.cn(v)});
            }
            this.entries.addAll(0, l);
            return this;
        }

        public Builder add(Encoder ... values) {
            CollectionUtils.prependAll(this.entries, (Object[])values);
            return this;
        }

        public Builder clear() {
            this.entries.clear();
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public List<Object> inner() {
            return this.entries;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public Builder set(Class<?> ... values) {
            List l = CollectionUtils.list((Object[])new Object[0]);
            for (Class<?> v : values) {
                if (Utils.cns(v).equals("Inherit")) {
                    l.addAll(this.entries);
                    continue;
                }
                if (Encoder.class.isAssignableFrom(v)) {
                    l.add(v);
                    continue;
                }
                throw ThrowableUtils.illegalArg((String)"Invalid type passed to EncoderSet.Builder.set(): {0}", (Object[])new Object[]{Utils.cn(v)});
            }
            this.entries = l;
            return this;
        }

        public String toString() {
            return this.entries.stream().map(Builder::toString).collect(Collectors.joining(",", "[", "]"));
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        @Override
        protected EncoderSet buildDefault() {
            return new EncoderSet(this);
        }
    }

    public static abstract class NoInherit
    extends Encoder {
    }

    public static abstract class Inherit
    extends Encoder {
    }
}

