/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swaps;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.utils.DateUtils;
import org.apache.juneau.swap.StringSwap;
import org.apache.juneau.swaps.DefaultingTemporalAccessor;

public class TemporalDateSwap
extends StringSwap<Date> {
    private final DateTimeFormatter formatter;

    public TemporalDateSwap(String pattern) {
        super(Date.class);
        this.formatter = DateUtils.getDateTimeFormatter(pattern);
    }

    @Override
    public String swap(BeanSession session, Date o) throws Exception {
        if (o == null) {
            return null;
        }
        return this.formatter.format(o.toInstant().atZone(session.getTimeZoneId()));
    }

    @Override
    public Date unswap(BeanSession session, String f, ClassMeta<?> hint) throws Exception {
        if (f == null) {
            return null;
        }
        ZoneId offset = session.getTimeZoneId();
        DefaultingTemporalAccessor ta = new DefaultingTemporalAccessor(this.formatter.parse(f), offset);
        return Date.from(ZonedDateTime.from(ta).toInstant());
    }

    public static class Rfc1123DateTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new Rfc1123DateTime();

        public Rfc1123DateTime() {
            super("RFC_1123_DATE_TIME");
        }
    }

    public static class IsoZonedDateTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoZonedDateTime();

        public IsoZonedDateTime() {
            super("ISO_ZONED_DATE_TIME");
        }
    }

    public static class IsoWeekDate
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoWeekDate();

        public IsoWeekDate() {
            super("ISO_WEEK_DATE");
        }
    }

    public static class IsoTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoTime();

        public IsoTime() {
            super("ISO_TIME");
        }
    }

    public static class IsoOrdinalDate
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoOrdinalDate();

        public IsoOrdinalDate() {
            super("ISO_ORDINAL_DATE");
        }
    }

    public static class IsoOffsetTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoOffsetTime();

        public IsoOffsetTime() {
            super("ISO_OFFSET_TIME");
        }
    }

    public static class IsoOffsetDateTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoOffsetDateTime();

        public IsoOffsetDateTime() {
            super("ISO_OFFSET_DATE_TIME");
        }
    }

    public static class IsoOffsetDate
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoOffsetDate();

        public IsoOffsetDate() {
            super("ISO_OFFSET_DATE");
        }
    }

    public static class IsoLocalTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoLocalTime();

        public IsoLocalTime() {
            super("ISO_LOCAL_TIME");
        }
    }

    public static class IsoLocalDateTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoLocalDateTime();

        public IsoLocalDateTime() {
            super("ISO_LOCAL_DATE_TIME");
        }
    }

    public static class IsoLocalDate
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoLocalDate();

        public IsoLocalDate() {
            super("ISO_LOCAL_DATE");
        }
    }

    public static class IsoInstant
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoInstant();

        public IsoInstant() {
            super("ISO_INSTANT");
        }
    }

    public static class IsoDateTime
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoDateTime();

        public IsoDateTime() {
            super("ISO_DATE_TIME");
        }
    }

    public static class IsoDate
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new IsoDate();

        public IsoDate() {
            super("ISO_DATE");
        }
    }

    public static class BasicIsoDate
    extends TemporalDateSwap {
        public static final TemporalDateSwap DEFAULT = new BasicIsoDate();

        public BasicIsoDate() {
            super("BASIC_ISO_DATE");
        }
    }
}

