/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanRecursionException;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanTraverseContext;
import org.apache.juneau.BeanTraverseSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.UriResolver;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;

public class SerializerSession
extends BeanTraverseSession {
    private final HttpPartSchema schema;
    private final Method javaMethod;
    private final Serializer ctx;
    private final SerializerListener listener;
    private final UriResolver uriResolver;
    private VarResolverSession vrs;

    public static Builder create(Serializer ctx) {
        return new Builder((Serializer)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
    }

    protected static final BeanPropertyValue createBeanTypeNameProperty(BeanMap<?> m, String typeName) {
        BeanMeta<?> bm = m.getMeta();
        return new BeanPropertyValue(bm.getTypeProperty(), bm.getTypeProperty().getName(), typeName, null);
    }

    protected static <T extends Throwable> void handleThrown(T causedBy) {
        if (causedBy instanceof Error) {
            throw (Error)causedBy;
        }
        if (causedBy instanceof RuntimeException) {
            throw (RuntimeException)causedBy;
        }
        if (causedBy instanceof StackOverflowError) {
            throw new SerializeException("Stack overflow occurred.  This can occur when trying to serialize models containing loops.  It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.", new Object[0]);
        }
        if (causedBy instanceof SerializeException) {
            throw (SerializeException)causedBy;
        }
        throw new SerializeException(causedBy);
    }

    protected static final List<Object> toList(Class<?> type, Object array) {
        Class<?> componentType = type.getComponentType();
        if (componentType.isPrimitive()) {
            int l = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(l);
            for (int i = 0; i < l; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }
        return CollectionUtils.l((Object[])((Object[])array));
    }

    protected SerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.javaMethod = builder.javaMethod;
        this.schema = builder.schema;
        UriContext uriContext = builder.uriContext;
        this.uriResolver = UriResolver.of(this.ctx.getUriResolution(), this.ctx.getUriRelativity(), uriContext);
        this.vrs = builder.resolver;
        this.listener = BeanCreator.of(SerializerListener.class).type(this.ctx.getListener()).orElse(null);
    }

    public <T> SerializerSession addVarBean(Class<T> c, T value) {
        this.getVarResolver().bean(c, value);
        return this;
    }

    public final boolean canIgnoreValue(ClassMeta<?> cm, String attrName, Object value) throws SerializeException {
        if (value == null && !this.isKeepNullProperties()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (cm == null) {
            cm = this.object();
        }
        if (this.isTrimEmptyCollections()) {
            if ((cm.isArray() || cm.isObject() && Utils.isArray((Object)value)) && ((Object[])value).length == 0) {
                return true;
            }
            if ((cm.isCollection() || cm.isObject() && ReflectionUtils.info((Object)value).isChildOf(Collection.class)) && ((Collection)value).isEmpty()) {
                return true;
            }
        }
        if (this.isTrimEmptyMaps() && (cm.isMap() || cm.isObject() && ReflectionUtils.info((Object)value).isChildOf(Map.class)) && ((Map)value).isEmpty()) {
            return true;
        }
        try {
            if (!this.isKeepNullProperties() && (this.willRecurse(attrName, value, cm) || this.willExceedDepth())) {
                return true;
            }
        }
        catch (BeanRecursionException e) {
            throw new SerializeException(e);
        }
        return false;
    }

    public final <E> void forEachEntry(Collection<E> c, Consumer<E> consumer) {
        if (c == null || c.isEmpty()) {
            return;
        }
        if (this.isSortCollections() && !SortedSet.class.isInstance(c) && SerializerSession.isSortable(c)) {
            c.stream().sorted().forEach(consumer);
        } else {
            c.forEach(consumer);
        }
    }

    public final <K, V> void forEachEntry(Map<K, V> m, Consumer<Map.Entry<K, V>> consumer) {
        if (m == null || m.isEmpty()) {
            return;
        }
        if (this.isSortMaps() && !SortedMap.class.isInstance(m) && SerializerSession.isSortable(m.keySet())) {
            m.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(x -> consumer.accept((Map.Entry)x));
        } else {
            m.entrySet().forEach(consumer);
        }
    }

    public SerializerListener getListener() {
        return this.listener;
    }

    public <T extends SerializerListener> T getListener(Class<T> c) {
        return (T)this.listener;
    }

    public Map<String, String> getResponseHeaders() {
        return this.ctx.getResponseHeaders(this);
    }

    public final HttpPartSchema getSchema() {
        return this.schema;
    }

    public VarResolverSession getVarResolver() {
        if (this.vrs == null) {
            this.vrs = this.createDefaultVarResolverSession();
        }
        return this.vrs;
    }

    public boolean isWriterSerializer() {
        return false;
    }

    public String resolve(String string) {
        return this.getVarResolver().resolve(string);
    }

    public final String resolveUri(Object uri) {
        return this.uriResolver.resolve(uri);
    }

    public Object serialize(Object o) throws SerializeException {
        throw ThrowableUtils.unsupportedOp();
    }

    public final void serialize(Object o, Object out) throws SerializeException, IOException {
        try (SerializerPipe pipe = this.createPipe(out);){
            this.doSerialize(pipe, o);
        }
        catch (IOException | SerializeException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new SerializeException(this, "Stack overflow occurred.  This can occur when trying to serialize models containing loops.  It's recommended you use the BeanTraverseContext.BEANTRAVERSE_detectRecursions setting to help locate the loop.", new Object[0]);
        }
        catch (Exception e) {
            throw new SerializeException(this, e);
        }
        finally {
            this.checkForWarnings();
        }
    }

    public String serializeToString(Object o) throws SerializeException {
        throw ThrowableUtils.unsupportedOp();
    }

    public final <E> Collection<E> sort(Collection<E> c) {
        if (c == null || c.isEmpty() || SortedSet.class.isInstance(c)) {
            return c;
        }
        if (this.isSortCollections() && SerializerSession.isSortable(c)) {
            return c.stream().sorted().collect(Collectors.toList());
        }
        return c;
    }

    public final <E> List<E> sort(List<E> c) {
        if (c == null || c.isEmpty()) {
            return c;
        }
        if (this.isSortCollections() && SerializerSession.isSortable(c)) {
            return c.stream().sorted().collect(Collectors.toList());
        }
        return c;
    }

    public final <K, V> Map<K, V> sort(Map<K, V> m) {
        if (m == null || m.isEmpty() || SortedMap.class.isInstance(m)) {
            return m;
        }
        if (this.isSortMaps() && SerializerSession.isSortable(m.keySet())) {
            return new TreeMap<K, V>(m);
        }
        return m;
    }

    public final String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Class.class) {
            return ReflectionUtils.info((Class)((Class)o)).getNameFull();
        }
        if (o.getClass() == ClassInfo.class) {
            return ((ClassInfo)o).getNameFull();
        }
        if (o.getClass().isEnum()) {
            return this.getClassMetaForObject(o).toString(o);
        }
        String s = o.toString();
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    public final String trim(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    private static boolean isSortable(Collection<?> c) {
        if (c == null) {
            return false;
        }
        for (Object o : c) {
            if (o instanceof Comparable) continue;
            return false;
        }
        return true;
    }

    protected VarResolverSession createDefaultVarResolverSession() {
        return VarResolver.DEFAULT.createSession();
    }

    protected SerializerPipe createPipe(Object output) {
        return new SerializerPipe(output);
    }

    protected void doSerialize(SerializerPipe pipe, Object o) throws IOException, SerializeException {
        this.ctx.doSerialize(this, pipe, o);
    }

    protected final Object generalize(Object o, ClassMeta<?> type) throws SerializeException {
        try {
            ObjectSwap<?, ?> f;
            if (o == null) {
                return null;
            }
            ObjectSwap<?, ?> objectSwap = f = type == null || type.isObject() || type.isString() ? this.getClassMeta(o.getClass()).getSwap(this) : type.getSwap(this);
            if (f == null) {
                return o;
            }
            return f.swap(this, o);
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    protected final String getBeanTypeName(SerializerSession session, ClassMeta<?> eType, ClassMeta<?> aType, BeanPropertyMeta pMeta) {
        if (!(eType != aType && (this.isAddBeanTypes() || session.isRoot() && this.isAddRootType()))) {
            return null;
        }
        String eTypeTn = eType.getBeanDictionaryName();
        String tn = aType.getBeanDictionaryName();
        if (Utils.nn((Object)tn) && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry br = eType.getBeanRegistry();
        if (Utils.nn((Object)br) && Utils.nn((Object)(tn = br.getTypeName(aType))) && !tn.equals(eTypeTn)) {
            return tn;
        }
        BeanRegistry beanRegistry = br = pMeta == null ? null : pMeta.getBeanRegistry();
        if (Utils.nn((Object)br) && Utils.nn((Object)(tn = br.getTypeName(aType))) && !tn.equals(eTypeTn)) {
            return tn;
        }
        br = this.getBeanRegistry();
        if (Utils.nn((Object)br) && Utils.nn((Object)(tn = br.getTypeName(aType))) && !tn.equals(eTypeTn)) {
            return tn;
        }
        return null;
    }

    protected final ClassMeta<?> getExpectedRootType(Object o) {
        if (this.isAddRootType()) {
            return this.object();
        }
        ClassMeta<Object> cm = this.getClassMetaForObject(o);
        if (Utils.nn(cm) && cm.isOptional()) {
            return cm.getElementType();
        }
        return cm;
    }

    protected final Method getJavaMethod() {
        return this.javaMethod;
    }

    protected final UriContext getUriContext() {
        return this.ctx.getUriContext();
    }

    protected final UriRelativity getUriRelativity() {
        return this.ctx.getUriRelativity();
    }

    protected final UriResolution getUriResolution() {
        return this.ctx.getUriResolution();
    }

    protected final UriResolver getUriResolver() {
        return this.uriResolver;
    }

    protected boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isAddRootType() {
        return this.ctx.isAddRootType();
    }

    protected final boolean isKeepNullProperties() {
        return this.ctx.isKeepNullProperties();
    }

    protected final boolean isSortCollections() {
        return this.ctx.isSortCollections();
    }

    protected final boolean isSortMaps() {
        return this.ctx.isSortMaps();
    }

    protected final boolean isTrimEmptyCollections() {
        return this.ctx.isTrimEmptyCollections();
    }

    protected final boolean isTrimEmptyMaps() {
        return this.ctx.isTrimEmptyMaps();
    }

    protected boolean isTrimStrings() {
        return this.ctx.isTrimStrings();
    }

    protected final void onBeanGetterException(BeanPropertyMeta p, Throwable t) throws SerializeException {
        if (Utils.nn((Object)this.listener)) {
            this.listener.onBeanGetterException(this, t, p);
        }
        String prefix = this.isDebug() ? this.getStack(false) + ": " : "";
        this.addWarning("{0}Could not call getValue() on property ''{1}'' of class ''{2}'', exception = {3}", new Object[]{prefix, p.getName(), p.getBeanMeta().getClassMeta(), ThrowableUtils.lm((Throwable)t)});
        if (!this.isIgnoreInvocationExceptionsOnGetters()) {
            throw new SerializeException(this, "{0}Could not call getValue() on property ''{1}'' of class ''{2}'', exception = {3}", new Object[]{prefix, p.getName(), p.getBeanMeta().getClassMeta(), ThrowableUtils.lm((Throwable)t)}).initCause(t);
        }
    }

    @Override
    protected void onError(Throwable t, String msg, Object ... args) {
        if (Utils.nn((Object)this.listener)) {
            this.listener.onError(this, t, Utils.f((String)msg, (Object[])args));
        }
        super.onError(t, msg, args);
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"uriResolver", (Object)this.uriResolver);
    }

    protected final ClassMeta<?> push2(String attrName, Object o, ClassMeta<?> eType) throws SerializeException {
        try {
            return super.push(attrName, o, eType);
        }
        catch (BeanRecursionException e) {
            throw new SerializeException(e);
        }
    }

    protected final String relativizeUri(Object relativeTo, Object uri) {
        return this.uriResolver.relativize(relativeTo, uri);
    }

    protected Object swap(ObjectSwap swap, Object o) throws SerializeException {
        try {
            if (swap == null) {
                return o;
            }
            return swap.swap(this, o);
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    public static class Builder
    extends BeanTraverseSession.Builder {
        private HttpPartSchema schema;
        private Method javaMethod;
        private Serializer ctx;
        private UriContext uriContext;
        private VarResolverSession resolver;

        protected Builder(Serializer ctx) {
            super((BeanTraverseContext)AssertionUtils.assertArgNotNull((String)"ctx", (Object)ctx));
            this.ctx = ctx;
            this.mediaTypeDefault(ctx.getResponseContentType());
            this.uriContext = ctx.getUriContext();
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public SerializerSession build() {
            return new SerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        public Builder javaMethod(Method value) {
            if (Utils.nn((Object)value)) {
                this.javaMethod = value;
            }
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        public Builder resolver(VarResolverSession value) {
            if (Utils.nn((Object)value)) {
                this.resolver = value;
            }
            return this;
        }

        public Builder schema(HttpPartSchema value) {
            if (Utils.nn((Object)value)) {
                this.schema = value;
            }
            return this;
        }

        public Builder schemaDefault(HttpPartSchema value) {
            if (Utils.nn((Object)value) && this.schema == null) {
                this.schema = value;
            }
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        public Builder uriContext(UriContext value) {
            if (Utils.nn((Object)value)) {
                this.uriContext = value;
            }
            return this;
        }
    }
}

