/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.kafka.connect.runtime.distributed.RebalanceNeededException;
import org.apache.kafka.connect.runtime.distributed.RequestTargetException;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestRequestTimeout;
import org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import org.apache.kafka.connect.util.FutureCallback;
import org.apache.kafka.connect.util.Stage;
import org.apache.kafka.connect.util.StagedTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HerderRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(HerderRequestHandler.class);
    private final RestClient restClient;
    private final RestRequestTimeout requestTimeout;

    public HerderRequestHandler(RestClient restClient, RestRequestTimeout requestTimeout) {
        this.restClient = restClient;
        this.requestTimeout = requestTimeout;
    }

    public <T> T completeRequest(FutureCallback<T> cb) throws Throwable {
        try {
            return cb.get(this.requestTimeout.timeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (StagedTimeoutException e) {
            Stage stage = e.stage();
            String message = stage.completed() != null ? "Request timed out. The last operation the worker completed was " + stage.description() + ", which began at " + Instant.ofEpochMilli(stage.started()) + " and completed at " + Instant.ofEpochMilli(stage.completed()) : "Request timed out. The worker is currently " + stage.description() + ", which began at " + Instant.ofEpochMilli(stage.started());
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), message);
        }
        catch (TimeoutException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request timed out");
        }
        catch (InterruptedException e) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request interrupted");
        }
    }

    public <T, U> T completeOrForwardRequest(FutureCallback<T> cb, String path, String method, HttpHeaders headers, Map<String, String> queryParameters, Object body, TypeReference<U> resultType, Translator<T, U> translator, Boolean forward) throws Throwable {
        try {
            return this.completeRequest(cb);
        }
        catch (RequestTargetException e) {
            if (forward == null || forward.booleanValue()) {
                boolean recursiveForward = forward == null;
                String forwardedUrl = e.forwardUrl();
                if (forwardedUrl == null) {
                    throw new ConnectRestException(Response.Status.CONFLICT.getStatusCode(), "Cannot complete request momentarily due to no known leader URL, likely because a rebalance was underway.");
                }
                UriBuilder uriBuilder = UriBuilder.fromUri((String)forwardedUrl).path(path).queryParam("forward", new Object[]{recursiveForward});
                if (queryParameters != null) {
                    queryParameters.forEach((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
                }
                String forwardUrl = uriBuilder.build(new Object[0]).toString();
                log.debug("Forwarding request {} {} {}", new Object[]{forwardUrl, method, body});
                return translator.translate(this.restClient.httpRequest(forwardUrl, method, headers, body, resultType));
            }
            log.error("Request '{} {}' failed because it couldn't find the target Connect worker within two hops (between workers).", (Object)method, (Object)path);
            throw new ConnectRestException(Response.Status.CONFLICT.getStatusCode(), "Cannot complete request because of a conflicting operation (e.g. worker rebalance)");
        }
        catch (RebalanceNeededException e) {
            throw new ConnectRestException(Response.Status.CONFLICT.getStatusCode(), "Cannot complete request momentarily due to stale configuration (typically caused by a concurrent config change)");
        }
    }

    public <T, U> T completeOrForwardRequest(FutureCallback<T> cb, String path, String method, HttpHeaders headers, Object body, TypeReference<U> resultType, Translator<T, U> translator, Boolean forward) throws Throwable {
        return this.completeOrForwardRequest(cb, path, method, headers, null, body, resultType, translator, forward);
    }

    public <T> T completeOrForwardRequest(FutureCallback<T> cb, String path, String method, HttpHeaders headers, Object body, Boolean forward) throws Throwable {
        return this.completeOrForwardRequest(cb, path, method, headers, body, null, new IdentityTranslator(), forward);
    }

    public static class IdentityTranslator<T>
    implements Translator<T, T> {
        @Override
        public T translate(RestClient.HttpResponse<T> response) {
            return response.body();
        }
    }

    public static interface Translator<T, U> {
        public T translate(RestClient.HttpResponse<U> var1);
    }
}

