/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.share;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class ShareGroupMember
extends ModernGroupMember {
    private ShareGroupMember(String memberId, int memberEpoch, int previousMemberEpoch, String rackId, String clientId, String clientHost, Set<String> subscribedTopicNames, MemberState state, Map<Uuid, Set<Integer>> assignedPartitions) {
        super(memberId, memberEpoch, previousMemberEpoch, null, rackId, clientId, clientHost, subscribedTopicNames, state, assignedPartitions);
    }

    public ShareGroupDescribeResponseData.Member asShareGroupDescribeMember(TopicsImage topicsImage) {
        return new ShareGroupDescribeResponseData.Member().setMemberEpoch(this.memberEpoch).setMemberId(this.memberId).setAssignment(new ShareGroupDescribeResponseData.Assignment().setTopicPartitions(ShareGroupMember.topicPartitionsFromMap(this.assignedPartitions, topicsImage))).setClientHost(this.clientHost).setClientId(this.clientId).setRackId(this.rackId).setSubscribedTopicNames((List)(this.subscribedTopicNames == null ? null : new ArrayList(this.subscribedTopicNames)));
    }

    private static List<ShareGroupDescribeResponseData.TopicPartitions> topicPartitionsFromMap(Map<Uuid, Set<Integer>> partitions, TopicsImage topicsImage) {
        ArrayList<ShareGroupDescribeResponseData.TopicPartitions> topicPartitions = new ArrayList<ShareGroupDescribeResponseData.TopicPartitions>();
        partitions.forEach((topicId, partitionSet) -> {
            TopicImage topicImage = topicsImage.getTopic(topicId);
            if (topicImage != null) {
                topicPartitions.add(new ShareGroupDescribeResponseData.TopicPartitions().setTopicId(topicId).setTopicName(topicImage.name()).setPartitions(new ArrayList(partitionSet)));
            }
        });
        return topicPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareGroupMember that = (ShareGroupMember)o;
        return this.memberEpoch == that.memberEpoch && this.previousMemberEpoch == that.previousMemberEpoch && this.state == that.state && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.rackId, that.rackId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientHost, that.clientHost) && Objects.equals(this.subscribedTopicNames, that.subscribedTopicNames) && Objects.equals(this.assignedPartitions, that.assignedPartitions);
    }

    public int hashCode() {
        int result = this.memberId != null ? this.memberId.hashCode() : 0;
        result = 31 * result + this.memberEpoch;
        result = 31 * result + this.previousMemberEpoch;
        result = 31 * result + Objects.hashCode((Object)this.state);
        result = 31 * result + Objects.hashCode(this.rackId);
        result = 31 * result + Objects.hashCode(this.clientId);
        result = 31 * result + Objects.hashCode(this.clientHost);
        result = 31 * result + Objects.hashCode(this.subscribedTopicNames);
        result = 31 * result + Objects.hashCode(this.assignedPartitions);
        return result;
    }

    public String toString() {
        return "ShareGroupMember(memberId='" + this.memberId + '\'' + ", memberEpoch=" + this.memberEpoch + '\'' + ", previousMemberEpoch=" + this.previousMemberEpoch + '\'' + ", state='" + (Object)((Object)this.state) + '\'' + ", rackId='" + this.rackId + '\'' + ", clientId='" + this.clientId + '\'' + ", clientHost='" + this.clientHost + '\'' + ", subscribedTopicNames=" + this.subscribedTopicNames + '\'' + ", assignedPartitions=" + this.assignedPartitions + ')';
    }

    public static class Builder {
        private final String memberId;
        private int memberEpoch = 0;
        private int previousMemberEpoch = -1;
        private MemberState state = MemberState.STABLE;
        private String rackId = null;
        private String clientId = "";
        private String clientHost = "";
        private Set<String> subscribedTopicNames = Collections.emptySet();
        private Map<Uuid, Set<Integer>> assignedPartitions = Collections.emptyMap();

        public Builder(String memberId) {
            this.memberId = Objects.requireNonNull(memberId);
        }

        public Builder(ShareGroupMember member) {
            this(Objects.requireNonNull(member), member.memberId);
        }

        public Builder(ShareGroupMember member, String newMemberId) {
            Objects.requireNonNull(member);
            this.memberId = Objects.requireNonNull(newMemberId);
            this.memberEpoch = member.memberEpoch;
            this.previousMemberEpoch = member.previousMemberEpoch;
            this.rackId = member.rackId;
            this.clientId = member.clientId;
            this.clientHost = member.clientHost;
            this.subscribedTopicNames = member.subscribedTopicNames;
            this.assignedPartitions = member.assignedPartitions;
        }

        public Builder updateMemberEpoch(int memberEpoch) {
            int currentMemberEpoch = this.memberEpoch;
            this.memberEpoch = memberEpoch;
            this.previousMemberEpoch = currentMemberEpoch;
            return this;
        }

        public Builder setMemberEpoch(int memberEpoch) {
            this.memberEpoch = memberEpoch;
            return this;
        }

        public Builder setPreviousMemberEpoch(int previousMemberEpoch) {
            this.previousMemberEpoch = previousMemberEpoch;
            return this;
        }

        public Builder setRackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public Builder maybeUpdateRackId(Optional<String> rackId) {
            this.rackId = rackId.orElse(this.rackId);
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientHost(String clientHost) {
            this.clientHost = clientHost;
            return this;
        }

        public Builder setSubscribedTopicNames(List<String> subscribedTopicList) {
            if (this.subscribedTopicNames != null) {
                this.subscribedTopicNames = new HashSet<String>(subscribedTopicList);
            }
            return this;
        }

        public Builder maybeUpdateSubscribedTopicNames(Optional<List<String>> subscribedTopicList) {
            subscribedTopicList.ifPresent(list -> {
                this.subscribedTopicNames = new HashSet<String>((Collection<String>)list);
            });
            return this;
        }

        public Builder setState(MemberState state) {
            this.state = state;
            return this;
        }

        public Builder setAssignedPartitions(Map<Uuid, Set<Integer>> assignedPartitions) {
            this.assignedPartitions = assignedPartitions;
            return this;
        }

        public Builder updateWith(ShareGroupMemberMetadataValue record) {
            this.setRackId(record.rackId());
            this.setClientId(record.clientId());
            this.setClientHost(record.clientHost());
            this.setSubscribedTopicNames(record.subscribedTopicNames());
            return this;
        }

        public Builder updateWith(ConsumerGroupCurrentMemberAssignmentValue record) {
            this.setMemberEpoch(record.memberEpoch());
            this.setPreviousMemberEpoch(record.previousMemberEpoch());
            this.setState(MemberState.fromValue(record.state()));
            this.setAssignedPartitions(Utils.assignmentFromTopicPartitions(record.assignedPartitions()));
            return this;
        }

        public ShareGroupMember build() {
            return new ShareGroupMember(this.memberId, this.memberEpoch, this.previousMemberEpoch, this.rackId, this.clientId, this.clientHost, this.subscribedTopicNames, this.state, this.assignedPartitions);
        }
    }
}

