/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionResponseWrapper;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseJoinProcessorSupplier<K, V, VO, VR>
implements ProcessorSupplier<K, SubscriptionResponseWrapper<VO>, K, VR> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseJoinProcessorSupplier.class);
    private final KTableValueGetterSupplier<K, V> valueGetterSupplier;
    private final Serializer<V> constructionTimeValueSerializer;
    private final Supplier<String> valueHashSerdePseudoTopicSupplier;
    private final ValueJoiner<V, VO, VR> joiner;
    private final boolean leftJoin;

    public ResponseJoinProcessorSupplier(KTableValueGetterSupplier<K, V> valueGetterSupplier, Serializer<V> valueSerializer, Supplier<String> valueHashSerdePseudoTopicSupplier, ValueJoiner<V, VO, VR> joiner, boolean leftJoin) {
        this.valueGetterSupplier = valueGetterSupplier;
        this.constructionTimeValueSerializer = valueSerializer;
        this.valueHashSerdePseudoTopicSupplier = valueHashSerdePseudoTopicSupplier;
        this.joiner = joiner;
        this.leftJoin = leftJoin;
    }

    @Override
    public Processor<K, SubscriptionResponseWrapper<VO>, K, VR> get() {
        return new ContextualProcessor<K, SubscriptionResponseWrapper<VO>, K, VR>(){
            private String valueHashSerdePseudoTopic;
            private Serializer<V> runtimeValueSerializer;
            private KTableValueGetter<K, V> valueGetter;
            private Sensor droppedRecordsSensor;
            {
                this.runtimeValueSerializer = ResponseJoinProcessorSupplier.this.constructionTimeValueSerializer;
            }

            @Override
            public void init(ProcessorContext<K, VR> context) {
                super.init(context);
                this.valueHashSerdePseudoTopic = ResponseJoinProcessorSupplier.this.valueHashSerdePseudoTopicSupplier.get();
                this.valueGetter = ResponseJoinProcessorSupplier.this.valueGetterSupplier.get();
                this.valueGetter.init(context);
                if (this.runtimeValueSerializer == null) {
                    this.runtimeValueSerializer = context.valueSerde().serializer();
                }
                InternalProcessorContext internalProcessorContext = (InternalProcessorContext)context;
                this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), internalProcessorContext.taskId().toString(), internalProcessorContext.metrics());
            }

            @Override
            public void process(Record<K, SubscriptionResponseWrapper<VO>> record) {
                if (record.value().version() != 0) {
                    throw new UnsupportedVersionException("SubscriptionResponseWrapper is of an incompatible version.");
                }
                ValueAndTimestamp currentValueWithTimestamp = this.valueGetter.get(record.key());
                long[] currentHash = currentValueWithTimestamp == null ? null : Murmur3.hash128(this.runtimeValueSerializer.serialize(this.valueHashSerdePseudoTopic, currentValueWithTimestamp.value()));
                long[] messageHash = record.value().originalValueHash();
                if (Arrays.equals(messageHash, currentHash)) {
                    Object result = record.value().foreignValue() == null && (!ResponseJoinProcessorSupplier.this.leftJoin || currentValueWithTimestamp == null) ? null : (Object)ResponseJoinProcessorSupplier.this.joiner.apply(currentValueWithTimestamp == null ? null : (Object)currentValueWithTimestamp.value(), record.value().foreignValue());
                    this.context().forward(record.withValue(result));
                } else {
                    LOG.trace("Dropping FK-join response due to hash mismatch. Expected {}. Actual {}", (Object)messageHash, (Object)currentHash);
                    this.droppedRecordsSensor.record();
                }
            }
        };
    }
}

