/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.ForeignKeyExtractor;
import org.apache.kafka.streams.kstream.internals.foreignkeyjoin.SubscriptionWrapper;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.internals.Murmur3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionSendProcessorSupplier<K, KO, V>
implements ProcessorSupplier<K, Change<V>, KO, SubscriptionWrapper<K>> {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionSendProcessorSupplier.class);
    private final ForeignKeyExtractor<K, V, KO> foreignKeyExtractor;
    private final Supplier<String> foreignKeySerdeTopicSupplier;
    private final Supplier<String> valueSerdeTopicSupplier;
    private final boolean leftJoin;
    private Serializer<KO> foreignKeySerializer;
    private Serializer<V> valueSerializer;
    private boolean useVersionedSemantics;

    public SubscriptionSendProcessorSupplier(ForeignKeyExtractor<K, V, KO> foreignKeyExtractor, Supplier<String> foreignKeySerdeTopicSupplier, Supplier<String> valueSerdeTopicSupplier, Serde<KO> foreignKeySerde, Serializer<V> valueSerializer, boolean leftJoin) {
        this.foreignKeyExtractor = foreignKeyExtractor;
        this.foreignKeySerdeTopicSupplier = foreignKeySerdeTopicSupplier;
        this.valueSerdeTopicSupplier = valueSerdeTopicSupplier;
        this.valueSerializer = valueSerializer;
        this.leftJoin = leftJoin;
        this.foreignKeySerializer = foreignKeySerde == null ? null : foreignKeySerde.serializer();
    }

    @Override
    public Processor<K, Change<V>, KO, SubscriptionWrapper<K>> get() {
        return new UnbindChangeProcessor();
    }

    public void setUseVersionedSemantics(boolean useVersionedSemantics) {
        this.useVersionedSemantics = useVersionedSemantics;
    }

    public boolean isUseVersionedSemantics() {
        return this.useVersionedSemantics;
    }

    private class UnbindChangeProcessor
    extends ContextualProcessor<K, Change<V>, KO, SubscriptionWrapper<K>> {
        private Sensor droppedRecordsSensor;
        private String foreignKeySerdeTopic;
        private String valueSerdeTopic;
        private long[] recordHash;

        private UnbindChangeProcessor() {
        }

        @Override
        public void init(ProcessorContext<KO, SubscriptionWrapper<K>> context) {
            super.init(context);
            this.foreignKeySerdeTopic = SubscriptionSendProcessorSupplier.this.foreignKeySerdeTopicSupplier.get();
            this.valueSerdeTopic = SubscriptionSendProcessorSupplier.this.valueSerdeTopicSupplier.get();
            if (SubscriptionSendProcessorSupplier.this.foreignKeySerializer == null) {
                SubscriptionSendProcessorSupplier.this.foreignKeySerializer = context.keySerde().serializer();
            }
            if (SubscriptionSendProcessorSupplier.this.valueSerializer == null) {
                SubscriptionSendProcessorSupplier.this.valueSerializer = context.valueSerde().serializer();
            }
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), (StreamsMetricsImpl)context.metrics());
        }

        @Override
        public void process(Record<K, Change<V>> record) {
            this.recordHash = null;
            if (SubscriptionSendProcessorSupplier.this.useVersionedSemantics && !record.value().isLatest) {
                LOG.info("Skipping out-of-order record from versioned table while performing table-table join.");
                this.droppedRecordsSensor.record();
                return;
            }
            if (SubscriptionSendProcessorSupplier.this.leftJoin) {
                this.leftJoinInstructions(record);
            } else {
                this.defaultJoinInstructions(record);
            }
        }

        private void leftJoinInstructions(Record<K, Change<V>> record) {
            if (record.value().oldValue != null) {
                Object newForeignKey;
                Object oldForeignKey = SubscriptionSendProcessorSupplier.this.foreignKeyExtractor.extract(record.key(), record.value().oldValue);
                Object KO = newForeignKey = record.value().newValue == null ? null : (Object)SubscriptionSendProcessorSupplier.this.foreignKeyExtractor.extract(record.key(), record.value().newValue);
                if (oldForeignKey != null && !Arrays.equals(this.serialize(newForeignKey), this.serialize(oldForeignKey))) {
                    this.forward(record, oldForeignKey, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE);
                }
                this.forward(record, newForeignKey, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE);
            } else if (record.value().newValue != null) {
                Object newForeignKey = SubscriptionSendProcessorSupplier.this.foreignKeyExtractor.extract(record.key(), record.value().newValue);
                this.forward(record, newForeignKey, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE);
            }
        }

        private void defaultJoinInstructions(Record<K, Change<V>> record) {
            if (record.value().oldValue != null) {
                Object newForeignKey;
                Object oldForeignKey = SubscriptionSendProcessorSupplier.this.foreignKeyExtractor.extract(record.key(), record.value().oldValue);
                Object KO = newForeignKey = record.value().newValue == null ? null : (Object)SubscriptionSendProcessorSupplier.this.foreignKeyExtractor.extract(record.key(), record.value().newValue);
                if (oldForeignKey == null && newForeignKey == null) {
                    this.logSkippedRecordDueToNullForeignKey();
                } else if (oldForeignKey == null) {
                    this.forward(record, newForeignKey, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE);
                } else if (newForeignKey == null) {
                    this.forward(record, oldForeignKey, SubscriptionWrapper.Instruction.DELETE_KEY_AND_PROPAGATE);
                } else if (!Arrays.equals(this.serialize(newForeignKey), this.serialize(oldForeignKey))) {
                    this.forward(record, oldForeignKey, SubscriptionWrapper.Instruction.DELETE_KEY_NO_PROPAGATE);
                    this.forward(record, newForeignKey, SubscriptionWrapper.Instruction.PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE);
                } else {
                    this.forward(record, newForeignKey, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE);
                }
            } else if (record.value().newValue != null) {
                Object newForeignKey = SubscriptionSendProcessorSupplier.this.foreignKeyExtractor.extract(record.key(), record.value().newValue);
                if (newForeignKey == null) {
                    this.logSkippedRecordDueToNullForeignKey();
                } else {
                    this.forward(record, newForeignKey, SubscriptionWrapper.Instruction.PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE);
                }
            }
        }

        private byte[] serialize(KO key) {
            return SubscriptionSendProcessorSupplier.this.foreignKeySerializer.serialize(this.foreignKeySerdeTopic, key);
        }

        private void forward(Record<K, Change<V>> record, KO foreignKey, SubscriptionWrapper.Instruction deleteKeyNoPropagate) {
            SubscriptionWrapper wrapper = new SubscriptionWrapper(this.hash(record), deleteKeyNoPropagate, record.key(), this.context().recordMetadata().get().partition());
            this.context().forward(record.withKey(foreignKey).withValue(wrapper));
        }

        private long[] hash(Record<K, Change<V>> record) {
            if (this.recordHash == null) {
                this.recordHash = record.value().newValue == null ? null : Murmur3.hash128(SubscriptionSendProcessorSupplier.this.valueSerializer.serialize(this.valueSerdeTopic, record.value().newValue));
            }
            return this.recordHash;
        }

        private void logSkippedRecordDueToNullForeignKey() {
            if (this.context().recordMetadata().isPresent()) {
                RecordMetadata recordMetadata = this.context().recordMetadata().get();
                LOG.warn("Skipping record due to null foreign key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
            } else {
                LOG.warn("Skipping record due to null foreign key. Topic, partition, and offset not known.");
            }
            this.droppedRecordsSensor.record();
        }
    }
}

