/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.Task;

public interface StateUpdater {
    public void start();

    public void shutdown(Duration var1);

    public void add(Task var1);

    public CompletableFuture<RemovedTaskResult> remove(TaskId var1);

    public void signalResume();

    public Set<StreamTask> drainRestoredActiveTasks(Duration var1);

    public List<ExceptionAndTask> drainExceptionsAndFailedTasks();

    public boolean hasExceptionsAndFailedTasks();

    public Set<Task> tasks();

    public Set<Task> updatingTasks();

    public boolean restoresActiveTasks();

    public Set<StandbyTask> standbyTasks();

    public KafkaFutureImpl<Uuid> restoreConsumerInstanceId(Duration var1);

    public static class RemovedTaskResult {
        private final Task task;
        private final Optional<RuntimeException> exception;

        public RemovedTaskResult(Task task) {
            this(task, null);
        }

        public RemovedTaskResult(Task task, RuntimeException exception) {
            this.task = Objects.requireNonNull(task);
            this.exception = Optional.ofNullable(exception);
        }

        public Task task() {
            return this.task;
        }

        public Optional<RuntimeException> exception() {
            return this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RemovedTaskResult)) {
                return false;
            }
            RemovedTaskResult that = (RemovedTaskResult)o;
            return Objects.equals(this.task.id(), that.task.id()) && Objects.equals(this.exception, that.exception);
        }

        public int hashCode() {
            return Objects.hash(this.task, this.exception);
        }

        public String toString() {
            return "RemovedTaskResult{task=" + String.valueOf(this.task.id()) + ", exception=" + String.valueOf(this.exception) + "}";
        }
    }

    public static class ExceptionAndTask {
        private final Task task;
        private final RuntimeException exception;

        public ExceptionAndTask(RuntimeException exception, Task task) {
            this.exception = Objects.requireNonNull(exception);
            this.task = Objects.requireNonNull(task);
        }

        public Task task() {
            return this.task;
        }

        public RuntimeException exception() {
            return this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExceptionAndTask)) {
                return false;
            }
            ExceptionAndTask that = (ExceptionAndTask)o;
            return this.task.id().equals(that.task.id()) && this.exception.equals(that.exception);
        }

        public int hashCode() {
            return Objects.hash(this.task, this.exception);
        }

        public String toString() {
            return "ExceptionAndTask{task=" + String.valueOf(this.task.id()) + ", exception=" + String.valueOf(this.exception) + "}";
        }
    }
}

