/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Locale;
import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Stable
public class RaftVoterEndpoint {
    private final String name;
    private final String host;
    private final int port;

    static String requireNonNullAllCapsNonEmpty(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Null argument not allowed.");
        }
        if (!input.trim().equals(input)) {
            throw new IllegalArgumentException("Leading or trailing whitespace is not allowed.");
        }
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Empty string is not allowed.");
        }
        if (!input.toUpperCase(Locale.ROOT).equals(input)) {
            throw new IllegalArgumentException("String must be UPPERCASE.");
        }
        return input;
    }

    public RaftVoterEndpoint(String name, String host, int port) {
        this.name = RaftVoterEndpoint.requireNonNullAllCapsNonEmpty(name);
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public String name() {
        return this.name;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        RaftVoterEndpoint other = (RaftVoterEndpoint)o;
        return this.name.equals(other.name) && this.host.equals(other.host) && this.port == other.port;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.host, this.port);
    }

    public String toString() {
        Object hostString = this.host.contains(":") ? "[" + this.host + "]" : this.host;
        return this.name + "://" + (String)hostString + ":" + this.port;
    }
}

