/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class Uuid
implements Comparable<Uuid> {
    public static final Uuid ONE_UUID;
    public static final Uuid METADATA_TOPIC_ID;
    public static final Uuid ZERO_UUID;
    public static final Set<Uuid> RESERVED;
    private final long mostSignificantBits;
    private final long leastSignificantBits;

    public Uuid(long mostSigBits, long leastSigBits) {
        this.mostSignificantBits = mostSigBits;
        this.leastSignificantBits = leastSigBits;
    }

    private static Uuid unsafeRandomUuid() {
        UUID jUuid = UUID.randomUUID();
        return new Uuid(jUuid.getMostSignificantBits(), jUuid.getLeastSignificantBits());
    }

    public static Uuid randomUuid() {
        Uuid uuid = Uuid.unsafeRandomUuid();
        while (RESERVED.contains(uuid) || uuid.toString().startsWith("-")) {
            uuid = Uuid.unsafeRandomUuid();
        }
        return uuid;
    }

    public long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != this.getClass()) {
            return false;
        }
        Uuid id = (Uuid)obj;
        return this.mostSignificantBits == id.mostSignificantBits && this.leastSignificantBits == id.leastSignificantBits;
    }

    public int hashCode() {
        long xor = this.mostSignificantBits ^ this.leastSignificantBits;
        return (int)(xor >> 32) ^ (int)xor;
    }

    public String toString() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid());
    }

    public static Uuid fromString(String str) {
        if (str.length() > 24) {
            throw new IllegalArgumentException("Input string with prefix `" + str.substring(0, 24) + "` is too long to be decoded as a base64 UUID");
        }
        ByteBuffer uuidBytes = ByteBuffer.wrap(Base64.getUrlDecoder().decode(str));
        if (uuidBytes.remaining() != 16) {
            throw new IllegalArgumentException("Input string `" + str + "` decoded as " + uuidBytes.remaining() + " bytes, which is not equal to the expected 16 bytes of a base64-encoded UUID");
        }
        return new Uuid(uuidBytes.getLong(), uuidBytes.getLong());
    }

    private byte[] getBytesFromUuid() {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(this.mostSignificantBits);
        uuidBytes.putLong(this.leastSignificantBits);
        return uuidBytes.array();
    }

    @Override
    public int compareTo(Uuid other) {
        if (this.mostSignificantBits > other.mostSignificantBits) {
            return 1;
        }
        if (this.mostSignificantBits < other.mostSignificantBits) {
            return -1;
        }
        if (this.leastSignificantBits > other.leastSignificantBits) {
            return 1;
        }
        if (this.leastSignificantBits < other.leastSignificantBits) {
            return -1;
        }
        return 0;
    }

    public static Uuid[] toArray(List<Uuid> list) {
        if (list == null) {
            return null;
        }
        Uuid[] array = new Uuid[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static List<Uuid> toList(Uuid[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Uuid> list = new ArrayList<Uuid>(array.length);
        list.addAll(Arrays.asList(array));
        return list;
    }

    static {
        METADATA_TOPIC_ID = ONE_UUID = new Uuid(0L, 1L);
        ZERO_UUID = new Uuid(0L, 0L);
        RESERVED = Collections.unmodifiableSet(new HashSet<Uuid>(Arrays.asList(METADATA_TOPIC_ID, ZERO_UUID, ONE_UUID)));
    }
}

