/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRuntime;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRuntimeMetrics;
import org.apache.kafka.coordinator.common.runtime.KafkaMetricHistogram;

public class CoordinatorRuntimeMetricsImpl
implements CoordinatorRuntimeMetrics {
    private final String metricsGroup;
    public static final String NUM_PARTITIONS_METRIC_NAME = "num-partitions";
    public static final String EVENT_QUEUE_TIME_METRIC_NAME = "event-queue-time-ms";
    public static final String EVENT_PROCESSING_TIME_METRIC_NAME = "event-processing-time-ms";
    public static final String EVENT_PURGATORY_TIME_METRIC_NAME = "event-purgatory-time-ms";
    public static final String BATCH_FLUSH_TIME_METRIC_NAME = "batch-flush-time-ms";
    private final MetricName numPartitionsLoading;
    private final AtomicLong numPartitionsLoadingCounter = new AtomicLong(0L);
    private final MetricName numPartitionsActive;
    private final AtomicLong numPartitionsActiveCounter = new AtomicLong(0L);
    private final MetricName numPartitionsFailed;
    private final AtomicLong numPartitionsFailedCounter = new AtomicLong(0L);
    private final MetricName eventQueueSize;
    private final Metrics metrics;
    private final Sensor partitionLoadSensor;
    private final Sensor threadIdleSensor;
    private final Sensor eventQueueTimeSensor;
    private final Sensor eventProcessingTimeSensor;
    private final Sensor eventPurgatoryTimeSensor;
    private final Sensor flushTimeSensor;

    public CoordinatorRuntimeMetricsImpl(Metrics metrics, String metricsGroup) {
        this.metrics = Objects.requireNonNull(metrics);
        this.metricsGroup = Objects.requireNonNull(metricsGroup);
        this.numPartitionsLoading = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Loading state.", "state", "loading");
        this.numPartitionsActive = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Active state.", "state", "active");
        this.numPartitionsFailed = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Failed state.", "state", "failed");
        this.eventQueueSize = this.kafkaMetricName("event-queue-size", "The event accumulator queue size.", new String[0]);
        metrics.addMetric(this.numPartitionsLoading, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsLoadingCounter.get()));
        metrics.addMetric(this.numPartitionsActive, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsActiveCounter.get()));
        metrics.addMetric(this.numPartitionsFailed, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsFailedCounter.get()));
        this.partitionLoadSensor = metrics.sensor("GroupPartitionLoadTime");
        this.partitionLoadSensor.add(metrics.metricName("partition-load-time-max", this.metricsGroup, "The max time it took to load the partitions in the last 30 sec."), (MeasurableStat)new Max());
        this.partitionLoadSensor.add(metrics.metricName("partition-load-time-avg", this.metricsGroup, "The average time it took to load the partitions in the last 30 sec."), (MeasurableStat)new Avg());
        this.threadIdleSensor = metrics.sensor("ThreadIdleRatio");
        this.threadIdleSensor.add(metrics.metricName("thread-idle-ratio-avg", this.metricsGroup, "The fraction of time the threads spent waiting for an event. This is an average across all coordinator event processor threads."), (MeasurableStat)new Rate(TimeUnit.MILLISECONDS));
        KafkaMetricHistogram eventQueueTimeHistogram = KafkaMetricHistogram.newLatencyHistogram(suffix -> this.kafkaMetricName("event-queue-time-ms-" + suffix, "The " + suffix + " event queue time in milliseconds", new String[0]));
        this.eventQueueTimeSensor = metrics.sensor("EventQueueTime");
        this.eventQueueTimeSensor.add((CompoundStat)eventQueueTimeHistogram);
        KafkaMetricHistogram eventProcessingTimeHistogram = KafkaMetricHistogram.newLatencyHistogram(suffix -> this.kafkaMetricName("event-processing-time-ms-" + suffix, "The " + suffix + " event processing time in milliseconds", new String[0]));
        this.eventProcessingTimeSensor = metrics.sensor("EventProcessingTime");
        this.eventProcessingTimeSensor.add((CompoundStat)eventProcessingTimeHistogram);
        KafkaMetricHistogram eventPurgatoryTimeHistogram = KafkaMetricHistogram.newLatencyHistogram(suffix -> this.kafkaMetricName("event-purgatory-time-ms-" + suffix, "The " + suffix + " event purgatory time in milliseconds", new String[0]));
        this.eventPurgatoryTimeSensor = metrics.sensor("EventPurgatoryTime");
        this.eventPurgatoryTimeSensor.add((CompoundStat)eventPurgatoryTimeHistogram);
        KafkaMetricHistogram flushTimeHistogram = KafkaMetricHistogram.newLatencyHistogram(suffix -> this.kafkaMetricName("batch-flush-time-ms-" + suffix, "The " + suffix + " flush time in milliseconds", new String[0]));
        this.flushTimeSensor = metrics.sensor("FlushTime");
        this.flushTimeSensor.add((CompoundStat)flushTimeHistogram);
    }

    private MetricName kafkaMetricName(String name, String description, String ... keyValue) {
        return this.metrics.metricName(name, this.metricsGroup, description, keyValue);
    }

    @Override
    public void close() {
        Arrays.asList(this.numPartitionsLoading, this.numPartitionsActive, this.numPartitionsFailed, this.eventQueueSize).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
        this.metrics.removeSensor(this.partitionLoadSensor.name());
        this.metrics.removeSensor(this.threadIdleSensor.name());
        this.metrics.removeSensor(this.eventQueueTimeSensor.name());
        this.metrics.removeSensor(this.eventProcessingTimeSensor.name());
        this.metrics.removeSensor(this.eventPurgatoryTimeSensor.name());
        this.metrics.removeSensor(this.flushTimeSensor.name());
    }

    @Override
    public void recordPartitionStateChange(CoordinatorRuntime.CoordinatorState oldState, CoordinatorRuntime.CoordinatorState newState) {
        switch (oldState) {
            case INITIAL: 
            case CLOSED: {
                break;
            }
            case LOADING: {
                this.numPartitionsLoadingCounter.decrementAndGet();
                break;
            }
            case ACTIVE: {
                this.numPartitionsActiveCounter.decrementAndGet();
                break;
            }
            case FAILED: {
                this.numPartitionsFailedCounter.decrementAndGet();
            }
        }
        switch (newState) {
            case INITIAL: 
            case CLOSED: {
                break;
            }
            case LOADING: {
                this.numPartitionsLoadingCounter.incrementAndGet();
                break;
            }
            case ACTIVE: {
                this.numPartitionsActiveCounter.incrementAndGet();
                break;
            }
            case FAILED: {
                this.numPartitionsFailedCounter.incrementAndGet();
            }
        }
    }

    @Override
    public void recordPartitionLoadSensor(long startTimeMs, long endTimeMs) {
        this.partitionLoadSensor.record((double)(endTimeMs - startTimeMs), endTimeMs, false);
    }

    @Override
    public void recordEventQueueTime(long durationMs) {
        this.eventQueueTimeSensor.record((double)durationMs);
    }

    @Override
    public void recordEventProcessingTime(long durationMs) {
        this.eventProcessingTimeSensor.record((double)durationMs);
    }

    @Override
    public void recordEventPurgatoryTime(long purgatoryTimeMs) {
        this.eventPurgatoryTimeSensor.record((double)purgatoryTimeMs);
    }

    @Override
    public void recordFlushTime(long durationMs) {
        this.flushTimeSensor.record((double)durationMs);
    }

    @Override
    public void recordThreadIdleTime(double idleTimeMs) {
        this.threadIdleSensor.record(idleTimeMs);
    }

    @Override
    public void registerEventQueueSizeGauge(Supplier<Integer> sizeSupplier) {
        this.metrics.addMetric(this.eventQueueSize, (MetricValueProvider)((Gauge)(config, now) -> (long)((Integer)sizeSupplier.get())));
    }
}

