/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiRequestHandler;
import kafka.server.ApiVersionManager;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchSnapshotResponseData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BeginQuorumEpochResponse;
import org.apache.kafka.common.requests.EndQuorumEpochResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FetchSnapshotResponse;
import org.apache.kafka.common.requests.VoteResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.RequestLocal;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015!\b\u0001\"\u0003v\u0011\u00159\b\u0001\"\u0003y\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\u0002\u0001\t\u0013\tI\u0001\u0003\u0004_\u0001\u0011%\u0011Q\u0002\u0002\u0017)\u0016\u001cHOU1giJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u0011\u0001#E\u0001\u0006i>|Gn\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00167\u0005\u0002\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0012\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001%\b\u0002\u0012\u0003BL'+Z9vKN$\b*\u00198eY\u0016\u0014\bC\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0012\u0003\u0015)H/\u001b7t\u0013\t13EA\u0004M_\u001e<\u0017N\\4\u0002\u0017I\fg\r^'b]\u0006<WM\u001d\u0019\u0003SE\u00022AK\u00170\u001b\u0005Y#B\u0001\u0017\u0012\u0003\u0011\u0011\u0018M\u001a;\n\u00059Z#a\u0003*bMRl\u0015M\\1hKJ\u0004\"\u0001M\u0019\r\u0001\u0011I!'AA\u0001\u0002\u0003\u0015\ta\r\u0002\u0004?\u0012\n\u0014C\u0001\u001b8!\t1R'\u0003\u00027/\t9aj\u001c;iS:<\u0007C\u0001\f9\u0013\tItCA\u0002B]f\faB]3rk\u0016\u001cHo\u00115b]:,G\u000e\u0005\u0002=\u007f5\tQH\u0003\u0002?#\u00059a.\u001a;x_J\\\u0017B\u0001!>\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fA\u0001^5nKB\u00111\tT\u0007\u0002\t*\u0011A%\u0012\u0006\u0003\r\u001e\u000baaY8n[>t'B\u0001\nI\u0015\tI%*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0006\u0019qN]4\n\u00055#%\u0001\u0002+j[\u0016\f\u0011#\u00199j-\u0016\u00148/[8o\u001b\u0006t\u0017mZ3s!\ta\u0002+\u0003\u0002R;\t\t\u0012\t]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0015!fk\u0017/^!\t)\u0006!D\u0001\u0010\u0011\u00159S\u00011\u0001Xa\tA&\fE\u0002+[e\u0003\"\u0001\r.\u0005\u0013I2\u0016\u0011!A\u0001\u0006\u0003\u0019\u0004\"\u0002\u001e\u0006\u0001\u0004Y\u0004\"B!\u0006\u0001\u0004\u0011\u0005\"\u0002(\u0006\u0001\u0004y\u0015A\u00025b]\u0012dW\rF\u0002aG2\u0004\"AF1\n\u0005\t<\"\u0001B+oSRDQ\u0001\u001a\u0004A\u0002\u0015\fqA]3rk\u0016\u001cH\u000f\u0005\u0002gS:\u0011AhZ\u0005\u0003Qv\naBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002kW\n9!+Z9vKN$(B\u00015>\u0011\u0015ig\u00011\u0001o\u00031\u0011X-];fgRdunY1m!\ty'/D\u0001q\u0015\t1\u0015O\u0003\u0002\u001f\u000f&\u00111\u000f\u001d\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u0012Q\u0006tG\r\\3Ba&4VM]:j_:\u001cHC\u00011w\u0011\u0015!w\u00011\u0001f\u0003)A\u0017M\u001c3mKZ{G/\u001a\u000b\u0003AfDQ\u0001\u001a\u0005A\u0002\u0015\fa\u0003[1oI2,')Z4j]F+xN];n\u000bB|7\r\u001b\u000b\u0003ArDQ\u0001Z\u0005A\u0002\u0015\fA\u0003[1oI2,WI\u001c3Rk>\u0014X/\\#q_\u000eDGC\u00011\u0000\u0011\u0015!'\u00021\u0001f\u0003-A\u0017M\u001c3mK\u001a+Go\u00195\u0015\u0007\u0001\f)\u0001C\u0003e\u0017\u0001\u0007Q-A\niC:$G.\u001a$fi\u000eD7K\\1qg\"|G\u000fF\u0002a\u0003\u0017AQ\u0001\u001a\u0007A\u0002\u0015$R\u0001YA\b\u0003#AQ\u0001Z\u0007A\u0002\u0015Dq!a\u0005\u000e\u0001\u0004\t)\"A\u0007ck&dGMU3ta>t7/\u001a\t\b-\u0005]\u00111DA\u0014\u0013\r\tIb\u0006\u0002\n\rVt7\r^5p]F\u0002B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C)\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005\u0015\u0012q\u0004\u0002\u000b\u0003BLW*Z:tC\u001e,\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055R)\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\t$a\u000b\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007")
public class TestRaftRequestHandler
implements ApiRequestHandler,
Logging {
    private final RaftManager<?> raftManager;
    private final RequestChannel requestChannel;
    private final Time time;
    private final ApiVersionManager apiVersionManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void tryCompleteActions() {
        ApiRequestHandler.tryCompleteActions$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public void handle(RequestChannel.Request request, RequestLocal requestLocal) {
        block13: {
            try {
                try {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> "Handling request:" + request.requestDesc(true) + " with context " + request.context());
                    ApiKeys apiKeys = request.header().apiKey();
                    if (ApiKeys.API_VERSIONS.equals(apiKeys)) {
                        this.handleApiVersions(request);
                        break block13;
                    }
                    if (ApiKeys.VOTE.equals(apiKeys)) {
                        this.handleVote(request);
                        break block13;
                    }
                    if (ApiKeys.BEGIN_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleBeginQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.END_QUORUM_EPOCH.equals(apiKeys)) {
                        this.handleEndQuorumEpoch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH.equals(apiKeys)) {
                        this.handleFetch(request);
                        break block13;
                    }
                    if (ApiKeys.FETCH_SNAPSHOT.equals(apiKeys)) {
                        this.handleFetchSnapshot(request);
                        break block13;
                    }
                    throw new IllegalArgumentException("Unsupported api key: " + request.header().apiKey());
                }
                catch (FatalExitError fatalExitError) {
                    throw fatalExitError;
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Unexpected error handling request " + request.requestDesc(true) + " with context " + request.context(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    AbstractResponse errorResponse = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class)).getErrorResponse(e);
                    this.requestChannel.sendResponse(request, errorResponse, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
                }
            }
            finally {
                if (request.apiLocalCompleteTimeNanos() < 0L) {
                    request.apiLocalCompleteTimeNanos_$eq(this.time.nanoseconds());
                }
            }
        }
    }

    private void handleApiVersions(RequestChannel.Request request) {
        this.requestChannel.sendResponse(request, (AbstractResponse)this.apiVersionManager.apiVersionResponse(0, request.header().apiVersion() < 4), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    private void handleVote(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new VoteResponse((VoteResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleBeginQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new BeginQuorumEpochResponse((BeginQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleEndQuorumEpoch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new EndQuorumEpochResponse((EndQuorumEpochResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetch(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new FetchResponse((FetchResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handleFetchSnapshot(RequestChannel.Request request) {
        Function1 & Serializable handle_buildResponse = (Function1 & Serializable)response -> new FetchSnapshotResponse((FetchSnapshotResponseData)response);
        Object handle_requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), handle_requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    private void handle(RequestChannel.Request request, Function1<ApiMessage, AbstractResponse> buildResponse) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        this.raftManager.handleRequest(request.context(), request.header(), requestBody.data(), this.time.milliseconds()).whenComplete((response, exception) -> {
            AbstractResponse res = exception != null ? handle_requestBody.getErrorResponse(exception) : (AbstractResponse)handle_buildResponse.apply(response);
            $this.requestChannel.sendResponse(request, res, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
        });
    }

    public TestRaftRequestHandler(RaftManager<?> raftManager, RequestChannel requestChannel, Time time, ApiVersionManager apiVersionManager) {
        this.raftManager = raftManager;
        this.requestChannel = requestChannel;
        this.time = time;
        this.apiVersionManager = apiVersionManager;
    }
}

