/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.shaded.org.apache.kerby.config.Config;
import org.apache.hadoop.shaded.org.apache.kerby.config.Configured;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.BatchTrans;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.IdentityService;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcClientRequest;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;

public class CacheableIdentityService
extends Configured
implements IdentityService {
    private static final int DEFAULT_CACHE_SIZE = 1000;
    private Map<String, KrbIdentity> idCache;
    private int cacheSize = 1000;
    private IdentityService underlying;

    public CacheableIdentityService(Config config, IdentityService underlying) {
        super(config);
        this.underlying = underlying;
        this.init();
    }

    @Override
    public boolean supportBatchTrans() {
        return false;
    }

    @Override
    public BatchTrans startBatchTrans() throws KrbException {
        throw new KrbException("Transaction isn't supported");
    }

    private void init() {
        LinkedHashMap<String, KrbIdentity> tmpMap = new LinkedHashMap<String, KrbIdentity>(this.cacheSize){
            private static final long serialVersionUID = -6911200685333503214L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, KrbIdentity> eldest) {
                return this.size() > CacheableIdentityService.this.cacheSize;
            }
        };
        this.idCache = new ConcurrentHashMap<String, KrbIdentity>(tmpMap);
    }

    @Override
    public Iterable<String> getIdentities() throws KrbException {
        return this.underlying.getIdentities();
    }

    @Override
    public KrbIdentity getIdentity(String principalName) throws KrbException {
        if (this.idCache.containsKey(principalName)) {
            return this.idCache.get(principalName);
        }
        KrbIdentity identity = this.underlying.getIdentity(principalName);
        if (identity != null) {
            this.idCache.put(principalName, identity);
        }
        return identity;
    }

    @Override
    public KrbIdentity addIdentity(KrbIdentity identity) throws KrbException {
        KrbIdentity added = this.underlying.addIdentity(identity);
        if (added != null) {
            this.idCache.put(added.getPrincipalName(), added);
        }
        return added;
    }

    @Override
    public KrbIdentity updateIdentity(KrbIdentity identity) throws KrbException {
        KrbIdentity updated = this.underlying.updateIdentity(identity);
        if (updated != null) {
            this.idCache.put(updated.getPrincipalName(), updated);
        }
        return updated;
    }

    @Override
    public void deleteIdentity(String principalName) throws KrbException {
        if (this.idCache.containsKey(principalName)) {
            this.idCache.remove(principalName);
        }
        this.underlying.deleteIdentity(principalName);
    }

    @Override
    public AuthorizationData getIdentityAuthorizationData(KdcClientRequest kdcClientRequest, EncTicketPart encTicketPart) throws KrbException {
        return this.underlying.getIdentityAuthorizationData(kdcClientRequest, encTicketPart);
    }
}

