/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.methods.OperationAPI;
import org.nuxeo.client.objects.ConnectableEntity;
import org.nuxeo.client.objects.blob.Blob;
import org.nuxeo.client.objects.blob.Blobs;
import org.nuxeo.client.objects.operation.OperationBody;
import retrofit2.Call;
import retrofit2.Callback;

public class Operation
extends ConnectableEntity<OperationAPI, Operation> {
    public static final String INPUT_PART = "input";
    public static final String INPUT_PARTS = "input#";
    @JsonIgnore
    protected OperationBody body;
    protected String operationId;

    protected Operation() {
        super("operation", OperationAPI.class);
    }

    public Operation(NuxeoClient nuxeoClient, String operationId) {
        super("operation", OperationAPI.class, nuxeoClient);
        this.body = new OperationBody();
        this.operationId = operationId;
    }

    public Operation input(Object input) {
        this.body.setInput(input);
        return this;
    }

    public Operation param(String key, Object parameter) {
        this.body.getParameters().put(key, parameter);
        return this;
    }

    public Operation context(String key, Object contextValue) {
        this.body.getContext().put(key, contextValue);
        return this;
    }

    public Operation parameters(Map<String, Object> parameters) {
        this.body.setParameters(parameters);
        return this;
    }

    public Operation context(Map<String, Object> context) {
        this.body.setContext(context);
        return this;
    }

    public OperationBody getBody() {
        return this.body;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public <T> T execute() {
        return (T)this.fetchResponse(this.getCallToExecute());
    }

    public void execute(Callback<?> callback) {
        this.fetchResponse(this.getCallToExecute(), callback);
    }

    protected Call<Object> getCallToExecute() {
        Object input = this.body.getInput();
        if (input instanceof Blob) {
            Blob blob = (Blob)input;
            RequestBody fbody = Operation.create(blob);
            MultipartBody.Part formData = MultipartBody.Part.createFormData((String)INPUT_PART, (String)blob.getFilename(), (RequestBody)fbody);
            return ((OperationAPI)this.api).execute(this.operationId, this.body, Collections.singletonList(formData));
        }
        if (input instanceof Blobs) {
            List<Blob> blobs = ((Blobs)input).getBlobs();
            ArrayList<MultipartBody.Part> fileParts = new ArrayList<MultipartBody.Part>();
            for (int i = 0; i < blobs.size(); ++i) {
                Blob blob = blobs.get(i);
                RequestBody fbody = Operation.create(blob);
                fileParts.add(MultipartBody.Part.createFormData((String)(INPUT_PARTS + String.valueOf(i)), (String)blob.getFilename(), (RequestBody)fbody));
            }
            return ((OperationAPI)this.api).execute(this.operationId, this.body, fileParts);
        }
        return ((OperationAPI)this.api).execute(this.operationId, this.body);
    }

    public static RequestBody create(final Blob blob) {
        if (blob == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)blob.getMimeType());
            }

            public long contentLength() throws IOException {
                return blob.getLength();
            }

            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)blob.getStream());
                    sink.writeAll(source);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(source);
                    throw throwable;
                }
                Util.closeQuietly((Closeable)source);
            }
        };
    }

    public Operation voidOperation(boolean value) {
        return (Operation)this.header("X-NXVoidOperation", Boolean.toString(value), new String[0]);
    }
}

