/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.TestNGException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph<T> {
    private static boolean m_verbose;
    private Map<T, Node> m_nodes = new HashMap<T, Node>();
    private List<T> m_strictlySortedNodes = null;
    private Map<T, Node> m_independentNodes = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$testng$internal$Graph;

    public void addNode(T tm) {
        Graph.ppp(new StringBuffer().append("ADDING NODE ").append(tm).append(" ").append(tm.hashCode()).toString());
        this.m_nodes.put(tm, new Node<T>(tm));
    }

    private boolean hasBeenSorted() {
        return null != this.m_strictlySortedNodes;
    }

    public boolean isIndependent(T object) {
        return this.m_independentNodes.containsKey(object);
    }

    private Node findNode(T object) {
        return this.m_nodes.get(object);
    }

    public void addPredecessor(T tm, T predecessor) {
        Graph.ppp(new StringBuffer().append("ADDING PREDECESSOR(").append(tm).append(") = ").append(predecessor).toString());
        Node node = this.findNode(tm);
        if (null == node) {
            throw new TestNGException(new StringBuffer().append("Non-existing node: ").append(tm).toString());
        }
        node.addPredecessor(predecessor);
        if (null == this.m_independentNodes) {
            this.m_independentNodes = new HashMap<T, Node>();
            for (T k : this.m_nodes.keySet()) {
                this.m_independentNodes.put(k, this.m_nodes.get(k));
            }
        }
        this.m_independentNodes.remove(predecessor);
        this.m_independentNodes.remove(tm);
        Graph.ppp(new StringBuffer().append("  REMOVED ").append(predecessor).append(" FROM INDEPENDENT OBJECTS").toString());
    }

    private Collection<Node> getNodes() {
        return this.m_nodes.values();
    }

    public Set<T> getIndependentNodes() {
        return this.m_independentNodes.keySet();
    }

    public List<T> getStrictlySortedNodes() {
        return this.m_strictlySortedNodes;
    }

    public void topologicalSort() {
        Graph.ppp("================ SORTING");
        this.m_strictlySortedNodes = new ArrayList<T>();
        if (null == this.m_independentNodes) {
            this.m_independentNodes = new HashMap<T, Node>();
        }
        ArrayList<Node> nodes2 = new ArrayList<Node>();
        for (Node n : this.getNodes()) {
            if (!this.isIndependent(n.getObject())) {
                Graph.ppp(new StringBuffer().append("ADDING FOR SORT: ").append(n.getObject()).toString());
                nodes2.add(n.clone());
                continue;
            }
            Graph.ppp(new StringBuffer().append("SKIPPING INDEPENDENT NODE ").append(n).toString());
        }
        boolean i = false;
        while (!nodes2.isEmpty()) {
            Node node = this.findNodeWithNoPredecessors(nodes2);
            if (null == node) {
                throw new TestNGException("Cyclic graph of methods");
            }
            this.m_strictlySortedNodes.add(node.getObject());
            Graph.removeFromNodes(nodes2, node);
        }
        Graph.ppp("=============== DONE SORTING");
        if (m_verbose) {
            this.dumpSortedNodes();
        }
    }

    private void dumpSortedNodes() {
        System.out.println("====== SORTED NODES");
        for (T n : this.m_strictlySortedNodes) {
            System.out.println(new StringBuffer().append("              ").append(n).toString());
        }
        System.out.println("====== END SORTED NODES");
    }

    private void dumpGraph() {
        System.out.println("====== GRAPH");
        for (Node n : this.m_nodes.values()) {
            System.out.println(new StringBuffer().append("  ").append(n).toString());
        }
    }

    private static void removeFromNodes(List<Node> nodes, Node node) {
        nodes.remove(node);
        for (Node n : nodes) {
            n.removePredecessor(node.getObject());
        }
    }

    private static void ppp(String s) {
        if (m_verbose) {
            System.out.println(new StringBuffer().append("[Graph] ").append(s).toString());
        }
    }

    private Node findNodeWithNoPredecessors(List<Node> nodes) {
        for (Node n : nodes) {
            if (n.hasPredecessors()) continue;
            return n;
        }
        return null;
    }

    public List<T> findPredecessors(T o) {
        ArrayList<Object> result = new ArrayList<Object>();
        Node node = this.findNode(o);
        if (null == node) {
            throw new AssertionError((Object)new StringBuffer().append("No such node: ").append(o).toString());
        }
        ArrayList<Node> nodesToWalk = new ArrayList<Node>();
        for (Node node2 : this.getNodes()) {
            Object obj = node2.getObject();
            if (!node.hasPredecessor(obj)) continue;
            Graph.ppp(new StringBuffer().append("FOUND PREDECESSOR ").append(node2).toString());
            if (result.contains(obj)) continue;
            result.add(0, obj);
            nodesToWalk.add(node2);
        }
        for (Node<Object> node3 : nodesToWalk) {
            List<Object> r = this.findPredecessors(node3.getObject());
            for (Object obj : r) {
                if (result.contains(obj)) continue;
                result.add(0, obj);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Graph ");
        for (T node : this.m_nodes.keySet()) {
            result.append(this.findNode(node)).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    public static void main(String[] argv) {
        Graph<String> g = new Graph<String>();
        g.addNode("3");
        g.addNode("1");
        g.addNode("2.2");
        g.addNode("independent");
        g.addNode("2.1");
        g.addNode("2");
        g.addPredecessor("3", "2");
        g.addPredecessor("3", "2.1");
        g.addPredecessor("3", "2.2");
        g.addPredecessor("2", "1");
        g.addPredecessor("2.1", "1");
        g.addPredecessor("2.2", "1");
        g.topologicalSort();
        List l = g.getStrictlySortedNodes();
        for (String s : l) {
            System.out.println(new StringBuffer().append("  ").append(s).toString());
        }
        int i = 0;
        if (!$assertionsDisabled && !"1".equals(l.get(i))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || "2".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || "2".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || "2".equals(l.get(++i)) || "2.1".equals(l.get(i)) || "2.2".equals(l.get(i)))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !"3".equals(l.get(++i))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && 1 != g.getIndependentNodes().size()) {
            throw new AssertionError();
        }
        Graph.ppp(new StringBuffer().append("GRAPH:").append(g).toString());
        List<String> predecessors = g.findPredecessors("2");
        if (!$assertionsDisabled && predecessors.size() != 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !predecessors.get(0).equals("1")) {
            throw new AssertionError();
        }
        predecessors = g.findPredecessors("3");
        if (!$assertionsDisabled && predecessors.size() != 4) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !predecessors.get(0).equals("1")) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || predecessors.get(1).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || predecessors.get(2).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || predecessors.get(3).equals("2.1") || predecessors.get(2).equals("2.2") || predecessors.get(2).equals("2"))) {
            throw new AssertionError();
        }
        Graph.ppp("TESTS PASSED");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$org$testng$internal$Graph == null ? (class$org$testng$internal$Graph = Graph.class$("org.testng.internal.Graph")) : class$org$testng$internal$Graph).desiredAssertionStatus();
        m_verbose = false;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<T> {
        private T m_object = null;
        private Map<T, T> m_predecessors = new HashMap<T, T>();

        public Node(T tm) {
            this.m_object = tm;
        }

        public Node clone() {
            Node<T> result = new Node<T>(this.m_object);
            for (T pred : this.m_predecessors.values()) {
                result.addPredecessor(pred);
            }
            return result;
        }

        public T getObject() {
            return this.m_object;
        }

        public Map<T, T> getPredecessors() {
            return this.m_predecessors;
        }

        public boolean removePredecessor(T o) {
            boolean result = false;
            T pred = this.m_predecessors.get(o);
            if (null != pred) {
                boolean bl = result = null != this.m_predecessors.remove(o);
                if (result) {
                    Graph.ppp(new StringBuffer().append("  REMOVED PRED ").append(o).append(" FROM NODE ").append(this.m_object).toString());
                } else {
                    Graph.ppp(new StringBuffer().append("  FAILED TO REMOVE PRED ").append(o).append(" FROM NODE ").append(this.m_object).toString());
                }
            }
            return result;
        }

        private void dump() {
            Graph.ppp(this.toString());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(new StringBuffer().append("[Node:").append(this.m_object).toString());
            sb.append("  pred:");
            for (T o : this.m_predecessors.values()) {
                sb.append(new StringBuffer().append(" ").append(o.toString()).toString());
            }
            sb.append("]");
            String result = sb.toString();
            return result;
        }

        public void addPredecessor(T tm) {
            Graph.ppp(new StringBuffer().append("  ADDING PREDECESSOR ").append(this.m_object).append(" ").append(tm).toString());
            this.m_predecessors.put(tm, tm);
        }

        public boolean hasPredecessors() {
            return this.m_predecessors.size() > 0;
        }

        public boolean hasPredecessor(T m) {
            return this.m_predecessors.containsKey(m);
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.clone();
        }
    }
}

