/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.plugin.utils;

import cisco.infra.dma.maven.mojo.AbstractDmaMojo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDmaMojoTestCase
extends AbstractMojoTestCase {
    public static final File SIMPLE_POM = new File(AbstractDmaMojoTestCase.getBasedir(), "test/resources/unit/pom.xml");

    public void setUp() throws Exception {
        super.setUp();
        String curDir = System.getProperty("user.dir");
        System.setProperty("user.dir", System.getProperty("user.dir") + "/target/test/tmp");
        curDir = System.getProperty("user.dir");
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public AbstractDmaMojo getMojo(File pomFile, Class clazz) {
        AbstractDmaMojo mojoUnderTest = null;
        try {
            Object m = clazz.newInstance();
            mojoUnderTest = (AbstractDmaMojo)((Object)m);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractDmaMojoTestCase.fail((String)("Could not instantiate " + clazz.getName().toString()));
        }
        if (pomFile == null) {
            return mojoUnderTest;
        }
        MavenProject project = this.createMavenProject(pomFile);
        AbstractDmaMojoTestCase.assertNotNull((Object)project);
        try {
            this.setVariableValueToObject((Object)mojoUnderTest, "project", project);
            this.setVariableValueToObject((Object)mojoUnderTest, "underTest", Boolean.TRUE);
        }
        catch (IllegalAccessException e) {
            AbstractDmaMojoTestCase.fail((String)"Could not initialize the Mojo");
        }
        return mojoUnderTest;
    }

    public MavenProject createMavenProject(File pomFile) {
        FileReader reader = null;
        try {
            reader = new FileReader(pomFile);
        }
        catch (FileNotFoundException e) {
            AbstractDmaMojoTestCase.fail((String)("Could not read test pom :" + pomFile.getAbsolutePath().toString()));
        }
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = modelReader.read((Reader)reader);
        }
        catch (Exception e) {
            AbstractDmaMojoTestCase.fail((String)("Could not parse pom : " + pomFile.getAbsolutePath().toString()));
        }
        MavenProject project = new MavenProject(model);
        return project;
    }

    protected AbstractDmaMojo getMojo(Class clazz) {
        return this.getMojo(null, clazz);
    }
}

