/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect.bf;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.internal.impl.collect.bf.DependencyProcessingContext;
import org.eclipse.aether.internal.impl.collect.bf.DependencyResolutionSkipper;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.artifact.decorator.ArtifactDecoratorFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.concurrency.SmartExecutor;
import org.eclipse.aether.util.concurrency.SmartExecutorUtils;
import org.eclipse.aether.version.Version;

@Singleton
@Named(value="bf")
public class BfDependencyCollector
extends DependencyCollectorDelegate {
    public static final String NAME = "bf";
    private static final String CONFIG_PROPS_PREFIX = "aether.dependencyCollector.bf.";
    public static final String CONFIG_PROP_SKIPPER = "aether.dependencyCollector.bf.skipper";
    public static final String NONE_SKIPPER = "false";
    public static final String VERSIONLESS_SKIPPER = "versionless";
    public static final String VERSIONED_SKIPPER = "versioned";
    public static final String DEFAULT_SKIPPER = "versionless";
    public static final String CONFIG_PROP_THREADS = "aether.dependencyCollector.bf.threads";
    public static final int DEFAULT_THREADS = 5;

    @Inject
    public BfDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver, Map<String, ArtifactDecoratorFactory> artifactDecoratorFactories) {
        super(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver, artifactDecoratorFactories);
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) throws DependencyCollectionException {
        Supplier<DependencyResolutionSkipper> skipperSupplier;
        String skipperMode = ConfigUtils.getString((RepositorySystemSession)session, (String)"versionless", (String[])new String[]{CONFIG_PROP_SKIPPER});
        if (NONE_SKIPPER.equals(skipperMode)) {
            this.logger.debug("Collector skip mode disabled");
            skipperSupplier = DependencyResolutionSkipper::neverSkipper;
        } else if ("versionless".equals(skipperMode)) {
            this.logger.debug("Collector skip mode enabled: {} (key function GACE)", (Object)skipperMode);
            skipperSupplier = DependencyResolutionSkipper::defaultGACESkipper;
        } else if (VERSIONED_SKIPPER.equals(skipperMode)) {
            this.logger.debug("Collector skip mode enabled: {} (key function GACEV)", (Object)skipperMode);
            skipperSupplier = DependencyResolutionSkipper::defaultGACEVSkipper;
        } else {
            throw new IllegalArgumentException("Unknown skipper mode: " + skipperMode + "; known are " + Arrays.asList("versionless", VERSIONED_SKIPPER, NONE_SKIPPER));
        }
        try (DependencyResolutionSkipper skipper = skipperSupplier.get();
             ParallelDescriptorResolver parallelDescriptorResolver = new ParallelDescriptorResolver(SmartExecutorUtils.smartExecutor((RepositorySystemSession)session, null, (int)ConfigUtils.getInteger((RepositorySystemSession)session, (int)5, (String[])new String[]{CONFIG_PROP_THREADS}), (String)(this.getClass().getSimpleName() + "-")));){
            Args args = new Args(session, pool, context, versionContext, request, skipper, parallelDescriptorResolver);
            DependencySelector rootDepSelector = session.getDependencySelector() != null ? session.getDependencySelector().deriveChildSelector((DependencyCollectionContext)context) : null;
            DependencyManager rootDepManager = session.getDependencyManager() != null ? session.getDependencyManager().deriveChildManager((DependencyCollectionContext)context) : null;
            DependencyTraverser rootDepTraverser = session.getDependencyTraverser() != null ? session.getDependencyTraverser().deriveChildTraverser((DependencyCollectionContext)context) : null;
            VersionFilter rootVerFilter = session.getVersionFilter() != null ? session.getVersionFilter().deriveChildFilter((DependencyCollectionContext)context) : null;
            List<DependencyNode> parents = Collections.singletonList(node);
            for (Dependency dependency : dependencies) {
                RequestTrace childTrace = this.collectStepTrace(trace, args.request.getRequestContext(), parents, dependency);
                DependencyProcessingContext processingContext = new DependencyProcessingContext(rootDepSelector, rootDepManager, rootDepTraverser, rootVerFilter, childTrace, repositories, managedDependencies, parents, dependency, PremanagedDependency.create(rootDepManager, dependency, false, args.premanagedState));
                if (this.filter(processingContext)) continue;
                processingContext.withDependency(processingContext.premanagedDependency.getManagedDependency());
                this.resolveArtifactDescriptorAsync(args, processingContext, results);
                args.dependencyProcessingQueue.add(processingContext);
            }
            while (!args.dependencyProcessingQueue.isEmpty()) {
                this.processDependency(args, results, args.dependencyProcessingQueue.remove(), Collections.emptyList(), false);
            }
            if (args.interruptedException.get() != null) {
                throw new DependencyCollectionException(results.getResult(), "Collection interrupted", (Throwable)args.interruptedException.get());
            }
        }
    }

    private void processDependency(Args args, DependencyCollectorDelegate.Results results, DependencyProcessingContext context, List<Artifact> relocations, boolean disableVersionManagement) {
        VersionRangeResult rangeResult;
        DescriptorResolutionResult resolutionResult;
        if (Thread.interrupted()) {
            args.interruptedException.set(new InterruptedException());
        }
        if (args.interruptedException.get() != null) {
            return;
        }
        Dependency dependency = context.dependency;
        PremanagedDependency preManaged = context.premanagedDependency;
        boolean noDescriptor = BfDependencyCollector.isLackingDescriptor(args.session, dependency.getArtifact());
        boolean traverse = !noDescriptor && (context.depTraverser == null || context.depTraverser.traverseDependency(dependency));
        Future<DescriptorResolutionResult> resolutionResultFuture = args.resolver.find(dependency.getArtifact());
        try {
            resolutionResult = resolutionResultFuture.get();
            rangeResult = resolutionResult.rangeResult;
        }
        catch (Exception e) {
            results.addException(dependency, e, context.parents);
            return;
        }
        Set<Version> versions = resolutionResult.descriptors.keySet();
        for (Version version : versions) {
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = resolutionResult.descriptors.get(version);
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                int cycleEntry = DefaultDependencyCycle.find(context.parents, (d = d.setArtifact(descriptorResult.getArtifact())).getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(context.parents, cycleEntry, d);
                    DependencyNode cycleNode = context.parents.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        context.getParent().getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    PremanagedDependency premanagedDependency = PremanagedDependency.create(context.depManager, d, disableVersionManagementSubsequently, args.premanagedState);
                    DependencyProcessingContext relocatedContext = new DependencyProcessingContext(context.depSelector, context.depManager, context.depTraverser, context.verFilter, context.trace, context.repositories, descriptorResult.getManagedDependencies(), context.parents, d, premanagedDependency);
                    if (!this.filter(relocatedContext)) {
                        relocatedContext.withDependency(premanagedDependency.getManagedDependency());
                        this.resolveArtifactDescriptorAsync(args, relocatedContext, results);
                        this.processDependency(args, results, relocatedContext, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    }
                    return;
                }
                d = args.pool.intern(d.setArtifact(args.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
                child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args.request.getRequestContext());
                context.getParent().getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                DependencyProcessingContext parentContext = context.withDependency(d);
                if (recurse) {
                    this.doRecurse(args, parentContext, descriptorResult, child, results, disableVersionManagement);
                    continue;
                }
                if (args.skipper.skipResolution((DependencyNode)child, parentContext.parents)) continue;
                ArrayList<DependencyNode> parents = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents.addAll(parentContext.parents);
                parents.add((DependencyNode)child);
                args.skipper.cache((DependencyNode)child, parents);
                continue;
            }
            List<RemoteRepository> repos = BfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), context.repositories);
            DefaultDependencyNode child = BfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args.request.getRequestContext());
            context.getParent().getChildren().add(child);
        }
    }

    private void doRecurse(Args args, DependencyProcessingContext parentContext, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child, DependencyCollectorDelegate.Results results, boolean disableVersionManagement) {
        DefaultDependencyCollectionContext context = args.collectionContext.get();
        args.collectionContext.compareAndSet(context, context.set(parentContext.dependency, descriptorResult.getManagedDependencies()));
        context = args.collectionContext.get();
        DependencySelector childSelector = parentContext.depSelector != null ? parentContext.depSelector.deriveChildSelector((DependencyCollectionContext)context) : null;
        DependencyManager childManager = parentContext.depManager != null ? parentContext.depManager.deriveChildManager((DependencyCollectionContext)context) : null;
        DependencyTraverser childTraverser = parentContext.depTraverser != null ? parentContext.depTraverser.deriveChildTraverser((DependencyCollectionContext)context) : null;
        VersionFilter childFilter = parentContext.verFilter != null ? parentContext.verFilter.deriveChildFilter((DependencyCollectionContext)context) : null;
        List<RemoteRepository> childRepos = args.ignoreRepos ? parentContext.repositories : this.remoteRepositoryManager.aggregateRepositories(args.session, parentContext.repositories, descriptorResult.getRepositories(), true);
        Object key = args.pool.toKey(parentContext.dependency.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children = args.pool.getChildren(key);
        if (children == null) {
            boolean skipResolution = args.skipper.skipResolution((DependencyNode)child, parentContext.parents);
            if (!skipResolution) {
                ArrayList<DependencyNode> parents = new ArrayList<DependencyNode>(parentContext.parents.size() + 1);
                parents.addAll(parentContext.parents);
                parents.add((DependencyNode)child);
                for (Dependency dependency : descriptorResult.getDependencies()) {
                    RequestTrace childTrace = this.collectStepTrace(parentContext.trace, args.request.getRequestContext(), parents, dependency);
                    PremanagedDependency premanagedDependency = PremanagedDependency.create(childManager, dependency, disableVersionManagement, args.premanagedState);
                    DependencyProcessingContext processingContext = new DependencyProcessingContext(childSelector, childManager, childTraverser, childFilter, childTrace, childRepos, descriptorResult.getManagedDependencies(), parents, dependency, premanagedDependency);
                    if (this.filter(processingContext)) continue;
                    processingContext.withDependency(processingContext.premanagedDependency.getManagedDependency());
                    this.resolveArtifactDescriptorAsync(args, processingContext, results);
                    args.dependencyProcessingQueue.add(processingContext);
                }
                args.pool.putChildren(key, child.getChildren());
                args.skipper.cache((DependencyNode)child, parents);
            }
        } else {
            child.setChildren(children);
        }
    }

    private boolean filter(DependencyProcessingContext context) {
        return context.depSelector != null && !context.depSelector.selectDependency(context.dependency);
    }

    private void resolveArtifactDescriptorAsync(Args args, DependencyProcessingContext context, DependencyCollectorDelegate.Results results) {
        Dependency dependency = context.dependency;
        args.resolver.resolveDescriptors(dependency.getArtifact(), () -> {
            VersionRangeRequest rangeRequest = BfDependencyCollector.createVersionRangeRequest(args.request.getRequestContext(), context.trace, context.repositories, dependency);
            VersionRangeResult rangeResult = this.cachedResolveRangeResult(rangeRequest, args.pool, args.session);
            List<? extends Version> versions = BfDependencyCollector.filterVersions(dependency, rangeResult, context.verFilter, args.versionContext);
            Collections.reverse(versions);
            ConcurrentHashMap descriptors = new ConcurrentHashMap(versions.size());
            Stream stream = versions.size() > 1 ? versions.parallelStream() : versions.stream();
            stream.forEach(version -> Optional.ofNullable(this.resolveDescriptorForVersion(args, context, results, dependency, (Version)version)).ifPresent(r -> descriptors.put(version, r)));
            DescriptorResolutionResult resolutionResult = new DescriptorResolutionResult(dependency.getArtifact(), rangeResult);
            versions.forEach(version -> resolutionResult.descriptors.put((Version)version, (ArtifactDescriptorResult)descriptors.get(version)));
            resolutionResult.flatten().forEach(dr -> args.resolver.cacheVersionRangeDescriptor(dr.artifact, (DescriptorResolutionResult)dr));
            return resolutionResult;
        });
    }

    private ArtifactDescriptorResult resolveDescriptorForVersion(Args args, DependencyProcessingContext context, DependencyCollectorDelegate.Results results, Dependency dependency, Version version) {
        Artifact original = dependency.getArtifact();
        Artifact newArtifact = original.setVersion(version.toString());
        Dependency newDependency = new Dependency(newArtifact, dependency.getScope(), Boolean.valueOf(dependency.isOptional()), dependency.getExclusions());
        DependencyProcessingContext newContext = context.copy();
        ArtifactDescriptorRequest descriptorRequest = BfDependencyCollector.createArtifactDescriptorRequest(args.request.getRequestContext(), context.trace, newContext.repositories, newDependency);
        return BfDependencyCollector.isLackingDescriptor(args.session, newArtifact) ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args.pool, descriptorRequest, args.session, newContext.withDependency((Dependency)newDependency).dependency, results, context.parents);
    }

    static class ParallelDescriptorResolver
    implements Closeable {
        private final SmartExecutor smartExecutor;
        private final Map<String, Future<DescriptorResolutionResult>> results = new ConcurrentHashMap<String, Future<DescriptorResolutionResult>>(256);

        ParallelDescriptorResolver(SmartExecutor smartExecutor) {
            this.smartExecutor = smartExecutor;
        }

        void resolveDescriptors(Artifact artifact, Callable<DescriptorResolutionResult> callable) {
            this.results.computeIfAbsent(ArtifactIdUtils.toId((Artifact)artifact), key -> this.smartExecutor.submit(callable));
        }

        void cacheVersionRangeDescriptor(Artifact artifact, DescriptorResolutionResult resolutionResult) {
            this.results.computeIfAbsent(ArtifactIdUtils.toId((Artifact)artifact), key -> CompletableFuture.completedFuture(resolutionResult));
        }

        Future<DescriptorResolutionResult> find(Artifact artifact) {
            return this.results.get(ArtifactIdUtils.toId((Artifact)artifact));
        }

        @Override
        public void close() {
            this.smartExecutor.close();
        }
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final Queue<DependencyProcessingContext> dependencyProcessingQueue = new ArrayDeque<DependencyProcessingContext>(128);
        final AtomicReference<DefaultDependencyCollectionContext> collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;
        final DependencyResolutionSkipper skipper;
        final ParallelDescriptorResolver resolver;
        final AtomicReference<InterruptedException> interruptedException;

        Args(RepositorySystemSession session, DataPool pool, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyResolutionSkipper skipper, ParallelDescriptorResolver resolver) {
            this.session = session;
            this.request = request;
            this.ignoreRepos = session.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.dependencyManager.verbose"});
            this.pool = pool;
            this.collectionContext = new AtomicReference<DefaultDependencyCollectionContext>(collectionContext);
            this.versionContext = versionContext;
            this.skipper = skipper;
            this.resolver = resolver;
            this.interruptedException = new AtomicReference<Object>(null);
        }
    }

    static class DescriptorResolutionResult {
        Artifact artifact;
        VersionRangeResult rangeResult;
        Map<Version, ArtifactDescriptorResult> descriptors;

        DescriptorResolutionResult(Artifact artifact, VersionRangeResult rangeResult) {
            this.artifact = artifact;
            this.rangeResult = rangeResult;
            this.descriptors = new LinkedHashMap<Version, ArtifactDescriptorResult>(rangeResult.getVersions().size());
        }

        DescriptorResolutionResult(VersionRangeResult rangeResult, Version version, ArtifactDescriptorResult descriptor) {
            this(descriptor.getRequest().getArtifact(), rangeResult);
            this.descriptors.put(version, descriptor);
        }

        List<DescriptorResolutionResult> flatten() {
            if (this.descriptors.size() > 1) {
                return this.descriptors.entrySet().stream().map(e -> new DescriptorResolutionResult(this.rangeResult, (Version)e.getKey(), (ArtifactDescriptorResult)e.getValue())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }
}

