/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.consoleui.elements.ConfirmChoice;
import org.jline.consoleui.elements.ExpandableChoice;
import org.jline.consoleui.elements.InputValue;
import org.jline.consoleui.elements.items.CheckboxItemIF;
import org.jline.consoleui.elements.items.ChoiceItemIF;
import org.jline.consoleui.elements.items.ConsoleUIItemIF;
import org.jline.consoleui.elements.items.ListItemIF;
import org.jline.consoleui.elements.items.impl.CheckboxItem;
import org.jline.consoleui.elements.items.impl.ChoiceItem;
import org.jline.consoleui.elements.items.impl.Separator;
import org.jline.consoleui.prompt.CheckboxResult;
import org.jline.consoleui.prompt.ConfirmResult;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.consoleui.prompt.ExpandableChoiceResult;
import org.jline.consoleui.prompt.InputResult;
import org.jline.consoleui.prompt.ListResult;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.CompletionMatcherImpl;
import org.jline.reader.impl.ReaderUtils;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;

public abstract class AbstractPrompt<T extends ConsoleUIItemIF> {
    protected final Terminal terminal;
    protected final BindingReader bindingReader;
    private final List<AttributedString> header;
    private final AttributedString message;
    protected final List<T> items;
    protected int firstItemRow;
    private final Size size = new Size();
    protected final ConsolePrompt.UiConfig config;
    private Display display;
    private ListRange range = null;
    public static final long DEFAULT_TIMEOUT_WITH_ESC = 150L;

    public AbstractPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, ConsolePrompt.UiConfig cfg) {
        this(terminal, display, header, message, new ArrayList(), 0, cfg);
    }

    public AbstractPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, List<T> items, int pageSize, ConsolePrompt.UiConfig cfg) {
        this.terminal = terminal;
        this.display = display;
        this.bindingReader = new BindingReader(terminal.reader());
        this.size.copy(terminal.getSize());
        int listSpace = Math.min(this.size.getRows(), Math.max(pageSize, 3));
        this.header = header.size() > this.size.getRows() - listSpace ? header.subList(header.size() - this.size.getRows() + listSpace, header.size()) : header;
        this.message = message;
        this.items = items;
        this.firstItemRow = this.header.size() + 1;
        this.config = cfg;
    }

    protected void resetHeader() {
        this.firstItemRow = this.header.size() + 1;
    }

    protected void resetDisplay() {
        this.size.copy(this.terminal.getSize());
    }

    protected void refreshDisplay(int row) {
        this.refreshDisplay(row, 0, null, false);
    }

    protected void refreshDisplay(int row, Set<String> selected) {
        this.display.resize(this.size.getRows(), this.size.getColumns());
        this.display.update(this.displayLines(row, selected), this.size.cursorPos(Math.min(this.size.getRows() - 1, this.firstItemRow + this.items.size()), 0));
    }

    protected void refreshDisplay(int row, int column, String buffer, boolean newline) {
        int crow;
        this.display.resize(this.size.getRows(), this.size.getColumns());
        AttributedStringBuilder asb = new AttributedStringBuilder();
        int n = crow = column == 0 ? Math.min(this.size.getRows() - 1, this.firstItemRow + this.items.size()) : row;
        if (buffer != null) {
            if (newline && !buffer.isEmpty()) {
                asb.style(this.config.style(".pr")).append((CharSequence)">> ");
            }
            asb.style(AttributedStyle.DEFAULT).append((CharSequence)buffer);
        }
        this.display.update(this.displayLines(row, asb.toAttributedString(), newline), this.size.cursorPos(crow, column));
    }

    protected void refreshDisplay(int buffRow, int buffCol, String buffer, int candRow, int candCol, List<Candidate> candidates) {
        this.display.resize(this.size.getRows(), this.size.getColumns());
        AttributedStringBuilder asb = new AttributedStringBuilder();
        if (buffer != null) {
            asb.style(AttributedStyle.DEFAULT).append((CharSequence)buffer);
        }
        this.display.update(this.displayLines(candRow, candCol, asb.toAttributedString(), candidates), this.size.cursorPos(buffRow, buffCol));
    }

    private int candidateStartPosition(int candidatesColumn, String buffer, List<Candidate> cands) {
        List<String> values = cands.stream().map(c -> AttributedString.stripAnsi((String)c.displ())).filter(c -> !c.matches("\\w+") && c.length() > 1).collect(Collectors.toList());
        HashSet notDelimiters = new HashSet();
        values.forEach(v -> v.substring(0, v.length() - 1).chars().filter(c -> !Character.isDigit(c) && !Character.isAlphabetic(c)).forEach(c -> notDelimiters.add(Character.toString((char)c))));
        int out = candidatesColumn;
        for (int i = buffer.length(); i > 0; --i) {
            if (!buffer.substring(0, i).matches(".*\\W") || notDelimiters.contains(buffer.substring(i - 1, i))) continue;
            out += i;
            break;
        }
        return out;
    }

    private List<AttributedString> displayLines(int cursorRow, int candidatesColumn, AttributedString buffer, List<Candidate> candidates) {
        int listStart;
        this.computeListRange(cursorRow, candidates.size());
        ArrayList<AttributedString> out = new ArrayList<AttributedString>(this.header);
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append(this.message);
        asb.append(buffer);
        out.add(asb.toAttributedString());
        if (cursorRow - this.firstItemRow >= 0 && !candidates.isEmpty() && cursorRow - this.firstItemRow < candidates.size()) {
            String dc = candidates.get(cursorRow - this.firstItemRow).displ();
            listStart = candidatesColumn + buffer.columnLength() - this.display.wcwidth(dc) + (AttributedString.stripAnsi((String)dc).endsWith("*") ? 1 : 0);
        } else {
            listStart = this.candidateStartPosition(candidatesColumn, buffer.toString(), candidates);
        }
        int width = Math.max(candidates.stream().map(Candidate::displ).mapToInt(arg_0 -> ((Display)this.display).wcwidth(arg_0)).max().orElse(20), 20);
        for (int i = this.range.first; i < this.range.last - 1 && !candidates.isEmpty() && i <= candidates.size() - 1; ++i) {
            int cl;
            Candidate c = candidates.get(i);
            asb = new AttributedStringBuilder();
            AttributedStringBuilder tmp = new AttributedStringBuilder();
            tmp.ansiAppend(c.displ());
            asb.style(tmp.styleAt(0));
            if (i + this.firstItemRow == cursorRow) {
                asb.style(new AttributedStyle().inverse());
            }
            asb.append((CharSequence)AttributedString.stripAnsi((String)c.displ()));
            for (int k = cl = asb.columnLength(); k < width; ++k) {
                asb.append((CharSequence)" ");
            }
            AttributedStringBuilder asb2 = new AttributedStringBuilder();
            asb2.tabs(listStart);
            asb2.append((CharSequence)"\t");
            asb2.style(this.config.style(".cb"));
            asb2.append((AttributedCharSequence)asb).append((CharSequence)" ");
            out.add(asb2.toAttributedString());
        }
        return out;
    }

    private List<AttributedString> displayLines(int cursorRow, Set<String> selected) {
        this.computeListRange(cursorRow, this.items.size());
        ArrayList<AttributedString> out = new ArrayList<AttributedString>(this.header);
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append(this.message);
        out.add(asb.toAttributedString());
        for (int i = this.range.first; i < this.range.last - 1 && !this.items.isEmpty() && i <= this.items.size() - 1; ++i) {
            ConsoleUIItemIF s = (ConsoleUIItemIF)this.items.get(i);
            asb = new AttributedStringBuilder();
            if (s.isSelectable()) {
                asb = i + this.firstItemRow == cursorRow ? asb.append(this.config.indicator()).style(AttributedStyle.DEFAULT).append((CharSequence)" ") : this.fillIndicatorSpace(asb).append((CharSequence)" ");
                asb = selected.contains(s.getName()) ? asb.append(this.config.checkedBox()) : asb.append(this.config.uncheckedBox());
            } else if (s instanceof CheckboxItem) {
                this.fillIndicatorSpace(asb);
                asb.append((CharSequence)" ");
                if (s.isDisabled()) {
                    asb.append(this.config.unavailable());
                } else {
                    this.fillCheckboxSpace(asb);
                }
            }
            asb.append((CharSequence)s.getText()).toAttributedString();
            if (s.isDisabled()) {
                asb.append((CharSequence)" (").append((CharSequence)s.getDisabledText()).append((CharSequence)")");
            }
            int textLength = asb.length();
            for (int j = 0; j < this.size.getColumns() - textLength; ++j) {
                asb.append(' ');
            }
            out.add(asb.toAttributedString());
        }
        return out;
    }

    private AttributedStringBuilder fillIndicatorSpace(AttributedStringBuilder asb) {
        for (int i = 0; i < this.config.indicator().length(); ++i) {
            asb.append((CharSequence)" ");
        }
        return asb;
    }

    private void fillCheckboxSpace(AttributedStringBuilder asb) {
        for (int i = 0; i < this.config.checkedBox().length(); ++i) {
            asb.append((CharSequence)" ");
        }
    }

    private void computeListRange(int cursorRow, int itemsSize) {
        if (this.range != null && this.range.first <= cursorRow - this.firstItemRow && this.range.last - 1 > cursorRow - this.firstItemRow) {
            return;
        }
        this.range = new ListRange(0, itemsSize + 1);
        if (this.size.getRows() < this.header.size() + itemsSize + 1) {
            int itemId = cursorRow - this.firstItemRow;
            int forList = this.size.getRows() - this.header.size();
            this.range = itemId < forList - 1 ? new ListRange(0, forList) : new ListRange(itemId - forList + 2, itemId + 2);
        }
    }

    private List<AttributedString> displayLines(int cursorRow, AttributedString buffer, boolean newline) {
        this.computeListRange(cursorRow, this.items.size());
        ArrayList<AttributedString> out = new ArrayList<AttributedString>(this.header);
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append(this.message);
        if (buffer != null && !newline) {
            asb.append(buffer);
        }
        out.add(asb.toAttributedString());
        if (buffer != null && newline) {
            asb = new AttributedStringBuilder();
            asb.append(buffer);
            out.add(asb.toAttributedString());
        }
        for (int i = this.range.first; i < this.range.last - 1; ++i) {
            String key;
            ConsoleUIItemIF s = (ConsoleUIItemIF)this.items.get(i);
            asb = new AttributedStringBuilder();
            String string = key = s instanceof ChoiceItem ? ((ChoiceItem)s).getKey() + " - " : "";
            if (i + this.firstItemRow == cursorRow) {
                out.add(asb.append(this.config.indicator()).style(this.config.style(".se")).append((CharSequence)" ").append((CharSequence)key).append((CharSequence)s.getText()).toAttributedString());
                continue;
            }
            if (!(s instanceof Separator)) {
                this.fillIndicatorSpace(asb);
                out.add(asb.append((CharSequence)" ").append((CharSequence)key).append((CharSequence)s.getText()).toAttributedString());
                continue;
            }
            out.add(asb.append((CharSequence)s.getText()).toAttributedString());
        }
        return out;
    }

    private static <T extends ConsoleUIItemIF> int nextRow(int row, int firstItemRow, List<T> items) {
        int itemsSize = items.size();
        int next = row + 1;
        while (next - firstItemRow < itemsSize && !((ConsoleUIItemIF)items.get(next - firstItemRow)).isSelectable()) {
            ++next;
        }
        if (next - firstItemRow >= itemsSize) {
            next = firstItemRow;
            while (next - firstItemRow < itemsSize && !((ConsoleUIItemIF)items.get(next - firstItemRow)).isSelectable()) {
                ++next;
            }
        }
        return next;
    }

    private static <T extends ConsoleUIItemIF> int prevRow(int row, int firstItemRow, List<T> items) {
        int itemsSize = items.size();
        int prev = row - 1;
        while (prev - firstItemRow >= 0 && !((ConsoleUIItemIF)items.get(prev - firstItemRow)).isSelectable()) {
            --prev;
        }
        if (prev - firstItemRow < 0) {
            prev = firstItemRow + itemsSize - 1;
            while (prev - firstItemRow >= 0 && !((ConsoleUIItemIF)items.get(prev - firstItemRow)).isSelectable()) {
                --prev;
            }
        }
        return prev;
    }

    private static class ListRange {
        final int first;
        final int last;

        public ListRange(int first, int last) {
            this.first = first;
            this.last = last;
        }
    }

    protected static class CheckboxPrompt
    extends AbstractPrompt<CheckboxItemIF> {
        private final List<CheckboxItemIF> items;

        private CheckboxPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, List<CheckboxItemIF> checkboxItemList, int pageSize, ConsolePrompt.UiConfig cfg) {
            super(terminal, display, header, message, checkboxItemList, pageSize, cfg);
            this.items = checkboxItemList;
        }

        public static CheckboxPrompt getPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, List<CheckboxItemIF> checkboxItemList, int pageSize, ConsolePrompt.UiConfig cfg) {
            return new CheckboxPrompt(terminal, display, header, message, checkboxItemList, pageSize, cfg);
        }

        private void bindKeys(KeyMap<Operation> map) {
            map.bind((Object)Operation.FORWARD_ONE_LINE, new CharSequence[]{"e", KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down)});
            map.bind((Object)Operation.BACKWARD_ONE_LINE, new CharSequence[]{"y", KeyMap.ctrl((char)'Y'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up)});
            map.bind((Object)Operation.TOGGLE, (CharSequence)" ");
            map.bind((Object)Operation.EXIT, (CharSequence)"\r");
            map.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.esc());
            map.setAmbiguousTimeout(150L);
        }

        public CheckboxResult execute() {
            this.resetDisplay();
            int selectRow = AbstractPrompt.nextRow(this.firstItemRow - 1, this.firstItemRow, this.items);
            Set<String> selected = this.items.stream().filter(CheckboxItemIF::isChecked).flatMap(it -> Stream.of(it.getName())).collect(Collectors.toSet());
            KeyMap keyMap = new KeyMap();
            this.bindKeys((KeyMap<Operation>)keyMap);
            while (true) {
                this.refreshDisplay(selectRow, selected);
                Operation op = (Operation)((Object)this.bindingReader.readBinding(keyMap));
                switch (op.ordinal()) {
                    case 0: {
                        selectRow = AbstractPrompt.nextRow(selectRow, this.firstItemRow, this.items);
                        break;
                    }
                    case 1: {
                        selectRow = AbstractPrompt.prevRow(selectRow, this.firstItemRow, this.items);
                        break;
                    }
                    case 2: {
                        if (selected.contains(this.items.get(selectRow - this.firstItemRow).getName())) {
                            selected.remove(this.items.get(selectRow - this.firstItemRow).getName());
                            break;
                        }
                        selected.add(this.items.get(selectRow - this.firstItemRow).getName());
                        break;
                    }
                    case 3: {
                        return new CheckboxResult(selected);
                    }
                    case 4: {
                        return null;
                    }
                }
            }
        }

        private static enum Operation {
            FORWARD_ONE_LINE,
            BACKWARD_ONE_LINE,
            TOGGLE,
            EXIT,
            CANCEL;

        }
    }

    protected static class ListChoicePrompt<T extends ListItemIF>
    extends AbstractPrompt<T> {
        private final List<T> items;

        private ListChoicePrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, List<T> listItems, int pageSize, ConsolePrompt.UiConfig cfg) {
            super(terminal, display, header, message, listItems, pageSize, cfg);
            this.items = listItems;
        }

        public static <T extends ListItemIF> ListChoicePrompt<T> getPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, List<T> listItems, int pageSize, ConsolePrompt.UiConfig cfg) {
            return new ListChoicePrompt<T>(terminal, display, header, message, listItems, pageSize, cfg);
        }

        private void bindKeys(KeyMap<Operation> map) {
            for (char i = ' '; i < '\u0080'; i = (char)(i + '\u0001')) {
                map.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
            }
            map.bind((Object)Operation.FORWARD_ONE_LINE, new CharSequence[]{"e", KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down)});
            map.bind((Object)Operation.BACKWARD_ONE_LINE, new CharSequence[]{"y", KeyMap.ctrl((char)'Y'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up)});
            map.bind((Object)Operation.EXIT, (CharSequence)"\r");
            map.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.esc());
            map.setAmbiguousTimeout(150L);
        }

        public ListResult execute() {
            this.resetDisplay();
            int selectRow = AbstractPrompt.nextRow(this.firstItemRow - 1, this.firstItemRow, this.items);
            KeyMap keyMap = new KeyMap();
            this.bindKeys((KeyMap<Operation>)keyMap);
            block7: while (true) {
                this.refreshDisplay(selectRow);
                Operation op = (Operation)((Object)this.bindingReader.readBinding(keyMap));
                block0 : switch (op.ordinal()) {
                    case 0: {
                        selectRow = AbstractPrompt.nextRow(selectRow, this.firstItemRow, this.items);
                        break;
                    }
                    case 1: {
                        selectRow = AbstractPrompt.prevRow(selectRow, this.firstItemRow, this.items);
                        break;
                    }
                    case 2: {
                        String ch = this.bindingReader.getLastBinding();
                        int id = 0;
                        Iterator<T> iterator = this.items.iterator();
                        while (true) {
                            ChoiceItem ci;
                            if (!iterator.hasNext()) continue block7;
                            ListItemIF cu = (ListItemIF)iterator.next();
                            if (cu instanceof ChoiceItem && (ci = (ChoiceItem)cu).isSelectable() && ci.getKey().toString().equals(ch)) {
                                selectRow = this.firstItemRow + id;
                                break block0;
                            }
                            ++id;
                        }
                    }
                    case 3: {
                        ListItemIF listItem = (ListItemIF)this.items.get(selectRow - this.firstItemRow);
                        return new ListResult(listItem.getName());
                    }
                    case 4: {
                        return null;
                    }
                }
            }
        }

        private static enum Operation {
            FORWARD_ONE_LINE,
            BACKWARD_ONE_LINE,
            INSERT,
            EXIT,
            CANCEL;

        }
    }

    private static class CompletingWord
    implements CompletingParsedLine {
        private final String word;

        public CompletingWord(String word) {
            this.word = word;
        }

        public CharSequence escape(CharSequence candidate, boolean complete) {
            return null;
        }

        public int rawWordCursor() {
            return this.word.length();
        }

        public int rawWordLength() {
            return this.word.length();
        }

        public String word() {
            return this.word;
        }

        public int wordCursor() {
            return this.word.length();
        }

        public int wordIndex() {
            return 0;
        }

        public List<String> words() {
            return new ArrayList<String>(Collections.singletonList(this.word));
        }

        public String line() {
            return this.word;
        }

        public int cursor() {
            return this.word.length();
        }
    }

    protected static class InputValuePrompt
    extends AbstractPrompt<ListItemIF> {
        private final int startColumn;
        private final String defaultValue;
        private final Character mask;
        private final LineReader reader;
        private final Completer completer;

        private InputValuePrompt(LineReader reader, Terminal terminal, Display display, List<AttributedString> header, AttributedString message, InputValue inputValue, ConsolePrompt.UiConfig cfg) {
            super(terminal, display, header, message, cfg);
            this.reader = reader;
            this.defaultValue = inputValue.getDefaultValue();
            this.startColumn = message.columnLength();
            this.mask = inputValue.getMask();
            this.completer = inputValue.getCompleter();
        }

        public static InputValuePrompt getPrompt(LineReader reader, Terminal terminal, Display display, List<AttributedString> header, AttributedString message, InputValue inputValue, ConsolePrompt.UiConfig cfg) {
            return new InputValuePrompt(reader, terminal, display, header, message, inputValue, cfg);
        }

        private void bindKeys(KeyMap<Operation> map) {
            map.setUnicode((Object)Operation.INSERT);
            for (char i = ' '; i < '\u0080'; i = (char)(i + '\u0001')) {
                map.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
            }
            map.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
            map.bind((Object)Operation.DELETE, new CharSequence[]{KeyMap.ctrl((char)'D'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_dc)});
            map.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.ctrl((char)'H'));
            map.bind((Object)Operation.EXIT, (CharSequence)"\r");
            map.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
            map.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
            map.bind((Object)Operation.UP, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up));
            map.bind((Object)Operation.DOWN, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down));
            map.bind((Object)Operation.BEGINNING_OF_LINE, new CharSequence[]{KeyMap.ctrl((char)'A'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_home)});
            map.bind((Object)Operation.END_OF_LINE, new CharSequence[]{KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_end)});
            map.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.ctrl((char)'F'));
            map.bind((Object)Operation.LEFT, (CharSequence)KeyMap.ctrl((char)'B'));
            map.bind((Object)Operation.SELECT_CANDIDATE, (CharSequence)"\t");
            map.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.esc());
            map.setAmbiguousTimeout(150L);
        }

        private void bindSelectKeys(KeyMap<SelectOp> map) {
            map.bind((Object)SelectOp.FORWARD_ONE_LINE, new CharSequence[]{"\t", "e", KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down)});
            map.bind((Object)SelectOp.BACKWARD_ONE_LINE, new CharSequence[]{"y", KeyMap.ctrl((char)'Y'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up)});
            map.bind((Object)SelectOp.EXIT, (CharSequence)"\r");
            map.bind((Object)SelectOp.CANCEL, (CharSequence)KeyMap.esc());
            map.setAmbiguousTimeout(150L);
        }

        public InputResult execute() {
            this.resetDisplay();
            int row = this.firstItemRow - 1;
            int column = this.startColumn;
            List<Object> matches = new ArrayList();
            KeyMap keyMap = new KeyMap();
            this.bindKeys((KeyMap<Operation>)keyMap);
            StringBuilder displayBuffer = new StringBuilder();
            StringBuilder buffer = new StringBuilder();
            CompletionMatcherImpl completionMatcher = new CompletionMatcherImpl();
            boolean tabCompletion = this.completer != null && this.reader != null;
            block12: while (true) {
                boolean displayCandidates = true;
                if (tabCompletion) {
                    ArrayList possible = new ArrayList();
                    CompletingWord completingWord = new CompletingWord(buffer.toString());
                    this.completer.complete(this.reader, (ParsedLine)completingWord, possible);
                    completionMatcher.compile(this.config.readerOptions(), false, (CompletingParsedLine)completingWord, false, 0, null);
                    matches = completionMatcher.matches(possible).stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                    if (matches.size() > ReaderUtils.getInt((LineReader)this.reader, (String)"menu-list-max", (int)10)) {
                        displayCandidates = false;
                    }
                }
                this.refreshDisplay(this.firstItemRow - 1, column, displayBuffer.toString(), row, this.startColumn, (List<Candidate>)(displayCandidates ? matches : new ArrayList()));
                Operation op = (Operation)((Object)this.bindingReader.readBinding(keyMap));
                switch (op.ordinal()) {
                    case 4: {
                        if (column <= this.startColumn) break;
                        --column;
                        break;
                    }
                    case 3: {
                        if (column >= this.startColumn + displayBuffer.length()) break;
                        ++column;
                        break;
                    }
                    case 0: {
                        displayBuffer.insert(column - this.startColumn, this.mask == null ? this.bindingReader.getLastBinding() : this.mask);
                        buffer.insert(column - this.startColumn, this.bindingReader.getLastBinding());
                        ++column;
                        break;
                    }
                    case 1: {
                        if (column <= this.startColumn) break;
                        displayBuffer.deleteCharAt(column - this.startColumn - 1);
                        buffer.deleteCharAt(column - this.startColumn - 1);
                        --column;
                        break;
                    }
                    case 2: {
                        if (column >= this.startColumn + displayBuffer.length() || column < this.startColumn) continue block12;
                        displayBuffer.deleteCharAt(column - this.startColumn);
                        buffer.deleteCharAt(column - this.startColumn);
                        break;
                    }
                    case 7: {
                        column = this.startColumn;
                        break;
                    }
                    case 8: {
                        column = this.startColumn + displayBuffer.length();
                        break;
                    }
                    case 9: {
                        if (!tabCompletion || matches.size() >= ReaderUtils.getInt((LineReader)this.reader, (String)"list-max", (int)50)) continue block12;
                        String selected = this.selectCandidate(this.firstItemRow - 1, buffer.toString(), row + 1, this.startColumn, matches);
                        this.resetHeader();
                        if (selected == null) continue block12;
                        displayBuffer.delete(0, displayBuffer.length());
                        if (this.mask == null) {
                            displayBuffer.append(selected);
                        } else {
                            for (int i = 0; i < selected.length(); ++i) {
                                displayBuffer.append(this.mask);
                            }
                        }
                        buffer.delete(0, displayBuffer.length());
                        buffer.append(selected);
                        column = this.startColumn + displayBuffer.length();
                        break;
                    }
                    case 10: {
                        if (displayBuffer.toString().isEmpty()) {
                            if (this.mask == null) {
                                displayBuffer.append(this.defaultValue);
                            } else {
                                for (int i = 0; i < this.defaultValue.length(); ++i) {
                                    displayBuffer.append(this.mask);
                                }
                            }
                            buffer.append(this.defaultValue);
                        }
                        return new InputResult(buffer.toString(), displayBuffer.toString());
                    }
                    case 11: {
                        return null;
                    }
                }
            }
        }

        String selectCandidate(int buffRow, String buffer, int row, int column, List<Candidate> candidates) {
            if (candidates.isEmpty()) {
                return buffer;
            }
            if (candidates.size() == 1) {
                return candidates.get(0).value();
            }
            KeyMap keyMap = new KeyMap();
            this.bindSelectKeys((KeyMap<SelectOp>)keyMap);
            while (true) {
                String selected = candidates.get(row - buffRow - 1).value();
                this.refreshDisplay(buffRow, column + selected.length(), selected, row, column, candidates);
                SelectOp op = (SelectOp)((Object)this.bindingReader.readBinding(keyMap));
                switch (op.ordinal()) {
                    case 0: {
                        if (row < buffRow + candidates.size()) {
                            ++row;
                            break;
                        }
                        row = buffRow + 1;
                        break;
                    }
                    case 1: {
                        if (row > buffRow + 1) {
                            --row;
                            break;
                        }
                        row = buffRow + candidates.size();
                        break;
                    }
                    case 2: {
                        return selected;
                    }
                    case 3: {
                        return null;
                    }
                }
            }
        }

        private static enum Operation {
            INSERT,
            BACKSPACE,
            DELETE,
            RIGHT,
            LEFT,
            UP,
            DOWN,
            BEGINNING_OF_LINE,
            END_OF_LINE,
            SELECT_CANDIDATE,
            EXIT,
            CANCEL;

        }

        private static enum SelectOp {
            FORWARD_ONE_LINE,
            BACKWARD_ONE_LINE,
            EXIT,
            CANCEL;

        }
    }

    protected static class ConfirmPrompt
    extends AbstractPrompt<ListItemIF> {
        private final int startColumn;
        private final ConfirmChoice.ConfirmationValue defaultValue;
        private final ConsolePrompt.UiConfig config;

        private ConfirmPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, ConfirmChoice confirmChoice, ConsolePrompt.UiConfig cfg) {
            super(terminal, display, header, message, cfg);
            this.startColumn = message.columnLength();
            this.defaultValue = confirmChoice.getDefaultConfirmation();
            this.config = cfg;
        }

        public static ConfirmPrompt getPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, ConfirmChoice confirmChoice, ConsolePrompt.UiConfig cfg) {
            return new ConfirmPrompt(terminal, display, header, message, confirmChoice, cfg);
        }

        private void bindKeys(KeyMap<Operation> map) {
            String yes = this.config.resourceBundle().getString("confirmation_yes_key");
            String no = this.config.resourceBundle().getString("confirmation_no_key");
            map.bind((Object)Operation.YES, new CharSequence[]{yes, yes.toUpperCase()});
            map.bind((Object)Operation.NO, new CharSequence[]{no, no.toUpperCase()});
            map.bind((Object)Operation.EXIT, (CharSequence)"\r");
            map.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.esc());
            map.setAmbiguousTimeout(150L);
        }

        public ConfirmResult execute() {
            this.resetDisplay();
            int row = this.firstItemRow - 1;
            int column = this.startColumn;
            KeyMap keyMap = new KeyMap();
            this.bindKeys((KeyMap<Operation>)keyMap);
            StringBuilder buffer = new StringBuilder();
            ConfirmChoice.ConfirmationValue confirm = this.defaultValue;
            block6: while (true) {
                this.refreshDisplay(row, column, buffer.toString(), false);
                Operation op = (Operation)((Object)this.bindingReader.readBinding(keyMap));
                buffer = new StringBuilder();
                switch (op.ordinal()) {
                    case 1: {
                        buffer.append(this.config.resourceBundle().getString("confirmation_yes_answer"));
                        confirm = ConfirmChoice.ConfirmationValue.YES;
                        column = this.startColumn + 3;
                        break;
                    }
                    case 0: {
                        buffer.append(this.config.resourceBundle().getString("confirmation_no_answer"));
                        confirm = ConfirmChoice.ConfirmationValue.NO;
                        column = this.startColumn + 2;
                        break;
                    }
                    case 2: {
                        if (confirm == null) continue block6;
                        return new ConfirmResult(confirm);
                    }
                    case 3: {
                        return null;
                    }
                }
            }
        }

        private static enum Operation {
            NO,
            YES,
            EXIT,
            CANCEL;

        }
    }

    protected static class ExpandableChoiceException
    extends RuntimeException {
        protected ExpandableChoiceException() {
        }
    }

    protected static class ExpandableChoicePrompt
    extends AbstractPrompt<ListItemIF> {
        private final int startColumn;
        private final List<ChoiceItemIF> items;
        private final ConsolePrompt.UiConfig config;

        private ExpandableChoicePrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, ExpandableChoice expandableChoice, ConsolePrompt.UiConfig cfg) {
            super(terminal, display, header, message, cfg);
            this.startColumn = message.columnLength();
            this.items = expandableChoice.getChoiceItems();
            this.config = cfg;
        }

        public static ExpandableChoicePrompt getPrompt(Terminal terminal, Display display, List<AttributedString> header, AttributedString message, ExpandableChoice expandableChoice, ConsolePrompt.UiConfig cfg) {
            return new ExpandableChoicePrompt(terminal, display, header, message, expandableChoice, cfg);
        }

        private void bindKeys(KeyMap<Operation> map) {
            for (char i = ' '; i < '\u0080'; i = (char)(i + '\u0001')) {
                map.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
            }
            map.bind((Object)Operation.EXIT, (CharSequence)"\r");
            map.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.esc());
            map.setAmbiguousTimeout(150L);
        }

        public ExpandableChoiceResult execute() {
            this.resetDisplay();
            int row = this.firstItemRow - 1;
            KeyMap keyMap = new KeyMap();
            this.bindKeys((KeyMap<Operation>)keyMap);
            StringBuilder buffer = new StringBuilder();
            String selectedId = null;
            boolean expandChoiceList = false;
            for (ChoiceItemIF cu : this.items) {
                if (!cu.isSelectable() || !cu.isDefaultChoice()) continue;
                selectedId = cu.getName();
                break;
            }
            block6: while (true) {
                this.refreshDisplay(row, this.startColumn, buffer.toString(), true);
                Operation op = (Operation)((Object)this.bindingReader.readBinding(keyMap));
                buffer = new StringBuilder();
                switch (op.ordinal()) {
                    case 0: {
                        String ch = this.bindingReader.getLastBinding();
                        if (ch.equals("h")) {
                            expandChoiceList = true;
                            buffer.append(this.config.resourceBundle().getString("help.list.all.options"));
                            break;
                        }
                        selectedId = null;
                        expandChoiceList = false;
                        boolean found = false;
                        for (ChoiceItemIF cu : this.items) {
                            if (!cu.isSelectable() || !cu.getKey().toString().equals(ch)) continue;
                            selectedId = cu.getName();
                            buffer.append(selectedId);
                            found = true;
                            break;
                        }
                        if (found) continue block6;
                        buffer.append(this.config.resourceBundle().getString("please.enter.a.valid.command"));
                        break;
                    }
                    case 1: {
                        if (selectedId == null || expandChoiceList) {
                            if (!expandChoiceList) break;
                            throw new ExpandableChoiceException();
                        }
                        return new ExpandableChoiceResult(selectedId);
                    }
                    case 2: {
                        return null;
                    }
                }
            }
        }

        private static enum Operation {
            INSERT,
            EXIT,
            CANCEL;

        }
    }
}

