/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.io.File;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationFile;
import org.apache.maven.api.model.ActivationOS;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.Resource;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ModelValidator;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.model.v4.MavenTransformer;
import org.eclipse.aether.scope.DependencyScope;
import org.eclipse.aether.scope.ScopeManager;

@Named
@Singleton
public class DefaultModelValidator
implements ModelValidator {
    public static final String BUILD_ALLOW_EXPRESSION_IN_EFFECTIVE_PROJECT_VERSION = "maven.build.allowExpressionInEffectiveProjectVersion";
    private static final Pattern EXPRESSION_NAME_PATTERN = Pattern.compile("\\$\\{(.+?)}");
    private static final Pattern EXPRESSION_PROJECT_NAME_PATTERN = Pattern.compile("\\$\\{(project.+?)}");
    private static final String ILLEGAL_FS_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*";
    private static final String ILLEGAL_REPO_ID_CHARS = "\\/:\"<>|?*";
    private static final String EMPTY = "";
    private final Set<String> validCoordinatesIds = ConcurrentHashMap.newKeySet();
    private final Set<String> validProfileIds = ConcurrentHashMap.newKeySet();

    @Inject
    public DefaultModelValidator() {
    }

    @Override
    public void validateFileModel(Session s, Model m, int validationLevel, ModelProblemCollector problems) {
        block25: {
            Build build;
            boolean isModelVersion41OrMore;
            Parent parent;
            block24: {
                parent = m.getParent();
                if (parent != null) {
                    this.validateStringNotEmpty("parent.groupId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getGroupId(), (InputLocationTracker)parent);
                    this.validateStringNotEmpty("parent.artifactId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getArtifactId(), (InputLocationTracker)parent);
                    if (DefaultModelValidator.equals(parent.getGroupId(), m.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), m.getArtifactId())) {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "parent.artifactId", null, "must be changed, the parent element cannot have the same groupId:artifactId as the project.", (InputLocationTracker)parent);
                    }
                    if (DefaultModelValidator.equals("LATEST", parent.getVersion()) || DefaultModelValidator.equals("RELEASE", parent.getVersion())) {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "parent.version", null, "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)parent);
                    }
                    if (parent.getRelativePath() != null && !parent.getRelativePath().isEmpty() && (parent.getGroupId() != null && !parent.getGroupId().isEmpty() || parent.getArtifactId() != null && !parent.getArtifactId().isEmpty()) && validationLevel >= 40 && ModelBuilder.KNOWN_MODEL_VERSIONS.contains(m.getModelVersion()) && !Objects.equals(m.getModelVersion(), "4.0.0")) {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "parent.relativePath", null, "only specify relativePath or groupId/artifactId in modelVersion 4.1.0", (InputLocationTracker)parent);
                    }
                }
                if (validationLevel != 0) break block24;
                HashSet<String> minProfileIds = new HashSet<String>();
                for (Profile profile : m.getProfiles()) {
                    if (minProfileIds.add(profile.getId())) continue;
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "profiles.profile.id", null, "Duplicate activation for profile " + profile.getId(), (InputLocationTracker)profile);
                }
                break block25;
            }
            if (validationLevel < 20) break block25;
            this.validateStringNotEmpty("modelVersion", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, m.getModelVersion(), (InputLocationTracker)m);
            this.validateModelVersion(problems, m.getModelVersion(), (InputLocationTracker)m, ModelBuilder.KNOWN_MODEL_VERSIONS);
            HashSet<String> modules = new HashSet<String>();
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)m.getModules().get(i);
                if (modules.add(module)) continue;
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, "modules.module[" + i + "]", null, "specifies duplicate child module " + module, (InputLocationTracker)m.getLocation((Object)"modules"));
            }
            String modelVersion = m.getModelVersion();
            if (Objects.equals(modelVersion, "4.0.0")) {
                if (!m.getSubprojects().isEmpty()) {
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, "subprojects", null, "unexpected subprojects element", (InputLocationTracker)m.getLocation((Object)"subprojects"));
                }
            } else {
                HashSet<String> subprojects = new HashSet<String>();
                int n2 = m.getSubprojects().size();
                for (int i = 0; i < n2; ++i) {
                    String subproject = (String)m.getSubprojects().get(i);
                    if (subprojects.add(subproject)) continue;
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V41, "subprojects.subproject[" + i + "]", null, "specifies duplicate subproject " + subproject, (InputLocationTracker)m.getLocation((Object)"subprojects"));
                }
                if (!modules.isEmpty()) {
                    if (subprojects.isEmpty()) {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V41, "modules", null, "deprecated modules element, use subprojects instead", (InputLocationTracker)m.getLocation((Object)"modules"));
                    } else {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V41, "modules", null, "cannot use both modules and subprojects element", (InputLocationTracker)m.getLocation((Object)"modules"));
                    }
                }
            }
            BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
            boolean bl = isModelVersion41OrMore = !Objects.equals("4.0.0", m.getModelVersion());
            if (isModelVersion41OrMore) {
                this.validateStringNoExpression("groupId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, m.getGroupId(), (InputLocationTracker)m);
                this.validateStringNotEmpty("artifactId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
                this.validateStringNoExpression("artifactId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
                this.validateVersionNoExpression("version", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, m.getVersion(), (InputLocationTracker)m);
                if (parent != null) {
                    this.validateStringNoExpression("groupId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, parent.getGroupId(), (InputLocationTracker)m);
                    this.validateStringNoExpression("artifactId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, parent.getArtifactId(), (InputLocationTracker)m);
                    this.validateVersionNoExpression("version", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V41, parent.getVersion(), (InputLocationTracker)m);
                }
            } else {
                this.validateStringNoExpression("groupId", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, m.getGroupId(), (InputLocationTracker)m);
                if (parent == null) {
                    this.validateStringNotEmpty("groupId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, m.getGroupId(), (InputLocationTracker)m);
                }
                this.validateStringNoExpression("artifactId", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
                this.validateStringNotEmpty("artifactId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, m.getArtifactId(), (InputLocationTracker)m);
                this.validateVersionNoExpression("version", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, m.getVersion(), (InputLocationTracker)m);
                if (parent == null) {
                    this.validateStringNotEmpty("version", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, m.getVersion(), (InputLocationTracker)m);
                }
            }
            this.validateStringNoExpression("packaging", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, m.getPackaging(), (InputLocationTracker)m);
            this.validate20RawDependencies(problems, m.getDependencies(), "dependencies.dependency.", EMPTY, isModelVersion41OrMore, validationLevel);
            this.validate20RawDependenciesSelfReferencing(problems, m, m.getDependencies(), "dependencies.dependency");
            if (m.getDependencyManagement() != null) {
                this.validate20RawDependencies(problems, m.getDependencyManagement().getDependencies(), "dependencyManagement.dependencies.dependency.", EMPTY, isModelVersion41OrMore, validationLevel);
            }
            if ((build = m.getBuild()) != null) {
                this.validate20RawPlugins(problems, build.getPlugins(), "build.plugins.plugin.", EMPTY, validationLevel);
                PluginManagement mgmt = build.getPluginManagement();
                if (mgmt != null) {
                    this.validate20RawPlugins(problems, mgmt.getPlugins(), "build.pluginManagement.plugins.plugin.", EMPTY, validationLevel);
                }
            }
            HashSet<String> profileIds = new HashSet<String>();
            for (Profile profile : m.getProfiles()) {
                BuildBase buildBase;
                String prefix = "profiles.profile[" + profile.getId() + "].";
                this.validateProfileId(prefix, "id", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, profile.getId(), null, (InputLocationTracker)m);
                if (!profileIds.add(profile.getId())) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, "profiles.profile.id", null, "must be unique but found duplicate profile with id " + profile.getId(), (InputLocationTracker)profile);
                }
                this.validate30RawProfileActivation(problems, profile.getActivation(), prefix);
                this.validate20RawDependencies(problems, profile.getDependencies(), prefix, "dependencies.dependency.", isModelVersion41OrMore, validationLevel);
                if (profile.getDependencyManagement() != null) {
                    this.validate20RawDependencies(problems, profile.getDependencyManagement().getDependencies(), prefix, "dependencyManagement.dependencies.dependency.", isModelVersion41OrMore, validationLevel);
                }
                if ((buildBase = profile.getBuild()) == null) continue;
                this.validate20RawPlugins(problems, buildBase.getPlugins(), prefix, "plugins.plugin.", validationLevel);
                PluginManagement mgmt = buildBase.getPluginManagement();
                if (mgmt == null) continue;
                this.validate20RawPlugins(problems, mgmt.getPlugins(), prefix, "pluginManagement.plugins.plugin.", validationLevel);
            }
        }
    }

    @Override
    public void validateRawModel(Session s, Model m, int validationLevel, ModelProblemCollector problems) {
        Parent parent;
        String minVersion = new MavenModelVersion().getModelVersion(m);
        if (m.getModelVersion() != null && DefaultModelValidator.compareModelVersions(minVersion, m.getModelVersion()) > 0) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V40, "model", null, "the model contains elements that require a model version of " + minVersion, (InputLocationTracker)m);
        }
        if ((parent = m.getParent()) != null) {
            this.validateStringNotEmpty("parent.groupId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getGroupId(), (InputLocationTracker)parent);
            this.validateStringNotEmpty("parent.artifactId", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getArtifactId(), (InputLocationTracker)parent);
            this.validateStringNotEmpty("parent.version", problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, parent.getVersion(), (InputLocationTracker)parent);
            if (DefaultModelValidator.equals(parent.getGroupId(), m.getGroupId()) && DefaultModelValidator.equals(parent.getArtifactId(), m.getArtifactId())) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.BASE, "parent.artifactId", null, "must be changed, the parent element cannot have the same groupId:artifactId as the project.", (InputLocationTracker)parent);
            }
            if (DefaultModelValidator.equals("LATEST", parent.getVersion()) || DefaultModelValidator.equals("RELEASE", parent.getVersion())) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, "parent.version", null, "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)parent);
            }
        }
        if (validationLevel > 0) {
            this.validateRawRepositories(problems, m.getRepositories(), "repositories.repository.", EMPTY, validationLevel);
            this.validateRawRepositories(problems, m.getPluginRepositories(), "pluginRepositories.pluginRepository.", EMPTY, validationLevel);
            for (Profile profile : m.getProfiles()) {
                String prefix = "profiles.profile[" + profile.getId() + "].";
                this.validateRawRepositories(problems, profile.getRepositories(), prefix, "repositories.repository.", validationLevel);
                this.validateRawRepositories(problems, profile.getPluginRepositories(), prefix, "pluginRepositories.pluginRepository.", validationLevel);
            }
            DistributionManagement distMgmt = m.getDistributionManagement();
            if (distMgmt != null) {
                this.validateRawRepository(problems, (Repository)distMgmt.getRepository(), "distributionManagement.repository.", EMPTY, true);
                this.validateRawRepository(problems, (Repository)distMgmt.getSnapshotRepository(), "distributionManagement.snapshotRepository.", EMPTY, true);
            }
        }
    }

    private void validate30RawProfileActivation(ModelProblemCollector problems, Activation activation, String prefix) {
        if (activation == null) {
            return;
        }
        LinkedList<ActivationFrame> stk = new LinkedList<ActivationFrame>();
        Supplier<String> pathSupplier = () -> {
            boolean parallel = false;
            return StreamSupport.stream(((Iterable)stk::descendingIterator).spliterator(), false).map(ActivationFrame::location).collect(Collectors.joining("."));
        };
        Supplier<InputLocation> locationSupplier = () -> {
            if (stk.size() < 2) {
                return null;
            }
            Iterator f = stk.iterator();
            String location = ((ActivationFrame)f.next()).location;
            ActivationFrame parent = (ActivationFrame)f.next();
            return parent.parent.map(p -> p.getLocation((Object)location)).orElse(null);
        };
        UnaryOperator transformer = s -> {
            if (this.hasProjectExpression((String)s)) {
                String path = (String)pathSupplier.get();
                Matcher matcher = EXPRESSION_PROJECT_NAME_PATTERN.matcher((CharSequence)s);
                while (matcher.find()) {
                    String propertyName = matcher.group(0);
                    if (path.startsWith("activation.file.") && "${project.basedir}".equals(propertyName)) continue;
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V30, prefix + path, null, "Failed to interpolate profile activation property " + s + ": " + propertyName + " expressions are not supported during profile activation.", (InputLocationTracker)locationSupplier.get());
                }
            }
            return s;
        };
        new ActivationWalker(stk, transformer).transformActivation(activation);
    }

    private void validate20RawPlugins(ModelProblemCollector problems, List<Plugin> plugins, String prefix, String prefix2, int validationLevel) {
        BuilderProblem.Severity errOn31 = DefaultModelValidator.getSeverity(validationLevel, 31);
        HashMap<String, Plugin> index = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            String key;
            Plugin existing;
            if (plugin.getGroupId() == null || plugin.getGroupId() != null && plugin.getGroupId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "groupId of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if (plugin.getArtifactId() == null || plugin.getArtifactId() != null && plugin.getArtifactId().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "artifactId of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if (plugin.getVersion() != null && plugin.getVersion().trim().isEmpty()) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "version of a plugin must be defined. ", (InputLocationTracker)plugin);
            }
            if ((existing = (Plugin)index.get(key = plugin.getKey())) != null) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId)", null, "must be unique but found duplicate declaration of plugin " + key, (InputLocationTracker)plugin);
            } else {
                index.put(key, plugin);
            }
            HashSet<String> executionIds = new HashSet<String>();
            if (validationLevel >= 40 && plugin.getConfiguration() != null) {
                this.validateXmlNodeRecursively(problems, prefix + prefix2 + "[" + plugin.getKey() + "].configuration", (InputLocationTracker)plugin, plugin.getConfiguration());
            }
            for (PluginExecution exec : plugin.getExecutions()) {
                if (!executionIds.add(exec.getId())) {
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, prefix + prefix2 + "[" + plugin.getKey() + "].executions.execution.id", null, "must be unique but found duplicate execution with id " + exec.getId(), (InputLocationTracker)exec);
                }
                if (validationLevel < 40 || exec.getConfiguration() == null) continue;
                this.validateXmlNodeRecursively(problems, prefix + prefix2 + "[" + plugin.getKey() + "].executions.execution." + exec.getId(), (InputLocationTracker)exec, exec.getConfiguration());
            }
        }
    }

    private void validateXmlNodeRecursively(ModelProblemCollector problems, String fieldPathPrefix, InputLocationTracker tracker, XmlNode xmlNode) {
        this.validateXmlNode(problems, fieldPathPrefix, tracker, xmlNode);
        for (XmlNode child : xmlNode.children()) {
            this.validateXmlNodeRecursively(problems, fieldPathPrefix + "." + xmlNode.name(), tracker, child);
        }
    }

    private void validateXmlNode(ModelProblemCollector problems, String fieldPathPrefix, InputLocationTracker tracker, XmlNode xmlNode) {
        String selfCombinationModeAttribute;
        String childrenCombinationModeAttribute = xmlNode.attributes().getOrDefault("combine.children", "merge");
        if (!"append".equals(childrenCombinationModeAttribute) && !"merge".equals(childrenCombinationModeAttribute)) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, fieldPathPrefix + "." + xmlNode.name(), SourceHint.xmlNodeInputLocation(xmlNode), "Unsupported value '" + childrenCombinationModeAttribute + "' for combine.children attribute. Valid values are: append, and merge (default is: merge)", tracker);
        }
        if (!("override".equals(selfCombinationModeAttribute = xmlNode.attributes().getOrDefault("combine.self", "merge")) || "merge".equals(selfCombinationModeAttribute) || "remove".equals(selfCombinationModeAttribute))) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, fieldPathPrefix + "." + xmlNode.name(), SourceHint.xmlNodeInputLocation(xmlNode), "Unsupported value '" + selfCombinationModeAttribute + "' for combine.self attribute. Valid values are: override, merge, and remove (default is: merge)", tracker);
        }
    }

    @Override
    public void validateEffectiveModel(Session s, Model m, int validationLevel, ModelProblemCollector problems) {
        this.validateStringNotEmpty("modelVersion", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getModelVersion(), (InputLocationTracker)m);
        this.validateCoordinatesId("groupId", problems, m.getGroupId(), (InputLocationTracker)m);
        this.validateCoordinatesId("artifactId", problems, m.getArtifactId(), (InputLocationTracker)m);
        this.validateStringNotEmpty("packaging", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getPackaging(), (InputLocationTracker)m);
        if (!m.getModules().isEmpty() || !m.getSubprojects().isEmpty()) {
            if (!"pom".equals(m.getPackaging())) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "packaging", null, "with value '" + m.getPackaging() + "' is invalid. Aggregator projects require 'pom' as packaging.", (InputLocationTracker)m);
            }
            int n = m.getModules().size();
            for (int i = 0; i < n; ++i) {
                String module = (String)m.getModules().get(i);
                boolean isBlankModule = true;
                if (module != null) {
                    for (int j = 0; j < module.length(); ++j) {
                        if (Character.isWhitespace(module.charAt(j))) continue;
                        isBlankModule = false;
                    }
                }
                if (!isBlankModule) continue;
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "modules.module[" + i + "]", null, "has been specified without a path to the project directory.", (InputLocationTracker)m.getLocation((Object)"modules"));
            }
            int size = m.getSubprojects().size();
            for (int index = 0; index < size; ++index) {
                String subproject = (String)m.getSubprojects().get(index);
                boolean isBlankSubproject = true;
                if (subproject != null) {
                    for (int charIndex = 0; charIndex < subproject.length(); ++charIndex) {
                        if (Character.isWhitespace(subproject.charAt(charIndex))) continue;
                        isBlankSubproject = false;
                    }
                }
                if (!isBlankSubproject) continue;
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "subprojects.subproject[" + index + "]", null, "has been specified without a path to the project directory.", (InputLocationTracker)m.getLocation((Object)"subprojects"));
            }
        }
        this.validateStringNotEmpty("version", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, m.getVersion(), (InputLocationTracker)m);
        BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
        this.validateEffectiveDependencies(s, problems, m, m.getDependencies(), false, validationLevel);
        DependencyManagement mgmt = m.getDependencyManagement();
        if (mgmt != null) {
            this.validateEffectiveDependencies(s, problems, m, mgmt.getDependencies(), true, validationLevel);
        }
        if (validationLevel >= 20) {
            Reporting reporting;
            Build build;
            BuilderProblem.Severity errOn31 = DefaultModelValidator.getSeverity(validationLevel, 31);
            this.validateBannedCharacters(EMPTY, "version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, (InputLocationTracker)m, "\\/:\"<>|?*");
            this.validate20ProperSnapshotVersion("version", problems, errOn31, ModelProblem.Version.V20, m.getVersion(), null, (InputLocationTracker)m);
            if (this.hasExpression(m.getVersion())) {
                BuilderProblem.Severity versionExpressionSeverity = BuilderProblem.Severity.ERROR;
                if (m.getProperties() != null && Boolean.parseBoolean((String)m.getProperties().get(BUILD_ALLOW_EXPRESSION_IN_EFFECTIVE_PROJECT_VERSION))) {
                    versionExpressionSeverity = BuilderProblem.Severity.WARNING;
                }
                DefaultModelValidator.addViolation(problems, versionExpressionSeverity, ModelProblem.Version.V20, "version", null, "must be a constant version but is '" + m.getVersion() + "'.", (InputLocationTracker)m);
            }
            if ((build = m.getBuild()) != null) {
                for (Object p : build.getPlugins()) {
                    this.validateStringNotEmpty("build.plugins.plugin.artifactId", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), (InputLocationTracker)p);
                    this.validateStringNotEmpty("build.plugins.plugin.groupId", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), (InputLocationTracker)p);
                    this.validate20PluginVersion("build.plugins.plugin.version", problems, p.getVersion(), SourceHint.pluginKey((Plugin)p), (InputLocationTracker)p, validationLevel);
                    this.validateBoolean("build.plugins.plugin.inherited", EMPTY, problems, errOn30, ModelProblem.Version.V20, p.getInherited(), SourceHint.pluginKey((Plugin)p), (InputLocationTracker)p);
                    this.validateBoolean("build.plugins.plugin.extensions", EMPTY, problems, errOn30, ModelProblem.Version.V20, p.getExtensions(), SourceHint.pluginKey((Plugin)p), (InputLocationTracker)p);
                    this.validate20EffectivePluginDependencies(problems, (Plugin)p, validationLevel);
                }
                this.validate20RawResources(problems, build.getResources(), "build.resources.resource.", validationLevel);
                this.validate20RawResources(problems, build.getTestResources(), "build.testResources.testResource.", validationLevel);
            }
            if ((reporting = m.getReporting()) != null) {
                for (ReportPlugin p : reporting.getPlugins()) {
                    this.validateStringNotEmpty("reporting.plugins.plugin.artifactId", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, p.getArtifactId(), (InputLocationTracker)p);
                    this.validateStringNotEmpty("reporting.plugins.plugin.groupId", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, p.getGroupId(), (InputLocationTracker)p);
                }
            }
            for (Repository repository : m.getRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "repositories.repository.", validationLevel);
            }
            for (Repository repository : m.getPluginRepositories()) {
                this.validate20EffectiveRepository(problems, repository, "pluginRepositories.pluginRepository.", validationLevel);
            }
            DistributionManagement distMgmt = m.getDistributionManagement();
            if (distMgmt != null) {
                if (distMgmt.getStatus() != null) {
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, "distributionManagement.status", null, "must not be specified.", (InputLocationTracker)distMgmt);
                }
                this.validate20EffectiveRepository(problems, (Repository)distMgmt.getRepository(), "distributionManagement.repository.", validationLevel);
                this.validate20EffectiveRepository(problems, (Repository)distMgmt.getSnapshotRepository(), "distributionManagement.snapshotRepository.", validationLevel);
            }
        }
    }

    private void validate20RawDependencies(ModelProblemCollector problems, List<Dependency> dependencies, String prefix, String prefix2, boolean is41OrBeyond, int validationLevel) {
        BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
        BuilderProblem.Severity errOn31 = DefaultModelValidator.getSeverity(validationLevel, 31);
        HashMap<String, Dependency> index = new HashMap<String, Dependency>();
        for (Dependency dependency : dependencies) {
            Dependency existing;
            String key = dependency.getManagementKey();
            if ("import".equals(dependency.getScope())) {
                if (!"pom".equals(dependency.getType())) {
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "type", SourceHint.dependencyManagementKey(dependency), "must be 'pom' to import the managed dependencies.", (InputLocationTracker)dependency);
                } else if (!is41OrBeyond && dependency.getClassifier() != null && !dependency.getClassifier().isEmpty()) {
                    DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "classifier", SourceHint.dependencyManagementKey(dependency), "must be empty, imported POM cannot have a classifier.", (InputLocationTracker)dependency);
                }
            } else if ("system".equals(dependency.getScope())) {
                String sysPath;
                if (validationLevel >= 31) {
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V31, prefix + prefix2 + "scope", SourceHint.dependencyManagementKey(dependency), "declares usage of deprecated 'system' scope ", (InputLocationTracker)dependency);
                }
                if ((sysPath = dependency.getSystemPath()) != null && !sysPath.isEmpty()) {
                    if (!this.hasExpression(sysPath)) {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", SourceHint.dependencyManagementKey(dependency), "should use a variable instead of a hard-coded path " + sysPath, (InputLocationTracker)dependency);
                    } else if (sysPath.contains("${basedir}") || sysPath.contains("${project.basedir}")) {
                        DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + prefix2 + "systemPath", SourceHint.dependencyManagementKey(dependency), "should not point at files within the project directory, " + sysPath + " will be unresolvable by dependent projects", (InputLocationTracker)dependency);
                    }
                }
            }
            if (DefaultModelValidator.equals("LATEST", dependency.getVersion()) || DefaultModelValidator.equals("RELEASE", dependency.getVersion())) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + prefix2 + "version", SourceHint.dependencyManagementKey(dependency), "is either LATEST or RELEASE (both of them are being deprecated)", (InputLocationTracker)dependency);
            }
            if ((existing = (Dependency)index.get(key)) != null) {
                String msg = DefaultModelValidator.equals(existing.getVersion(), dependency.getVersion()) ? "duplicate declaration of version " + Objects.toString(dependency.getVersion(), "(?)") : "version " + Objects.toString(existing.getVersion(), "(?)") + " vs " + Objects.toString(dependency.getVersion(), "(?)");
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + prefix2 + "(groupId:artifactId:type:classifier)", null, "must be unique: " + key + " -> " + msg, (InputLocationTracker)dependency);
                continue;
            }
            index.put(key, dependency);
        }
    }

    private void validate20RawDependenciesSelfReferencing(ModelProblemCollector problems, Model m, List<Dependency> dependencies, String prefix) {
        for (Dependency dependency : dependencies) {
            String mKey;
            String key = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + (String)(dependency.getClassifier() != null ? ":" + dependency.getClassifier() : EMPTY);
            if (!key.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) continue;
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key + "]", SourceHint.gav(key), "is referencing itself.", (InputLocationTracker)dependency);
        }
    }

    private void validateEffectiveDependencies(Session s, ModelProblemCollector problems, Model m, List<Dependency> dependencies, boolean management, int validationLevel) {
        BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
        String prefix = management ? "dependencyManagement.dependencies.dependency." : "dependencies.dependency.";
        for (Dependency d : dependencies) {
            ScopeManager scopeManager;
            this.validateEffectiveDependency(problems, d, management, prefix, validationLevel);
            if (validationLevel < 20) continue;
            this.validateBoolean(prefix, "optional", problems, errOn30, ModelProblem.Version.V20, d.getOptional(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
            if (!management) {
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.V20, d.getVersion(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
                scopeManager = InternalSession.from(s).getSession().getScopeManager();
                this.validateEnum(prefix, "scope", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d, (String[])scopeManager.getDependencyScopeUniverse().stream().map(DependencyScope::getId).distinct().toArray(String[]::new));
                this.validateEffectiveModelAgainstDependency(prefix, problems, m, d);
                continue;
            }
            scopeManager = InternalSession.from(s).getSession().getScopeManager();
            Set scopes = scopeManager.getDependencyScopeUniverse().stream().map(DependencyScope::getId).collect(Collectors.toCollection(HashSet::new));
            scopes.add("import");
            this.validateEnum(prefix, "scope", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, d.getScope(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d, scopes.toArray(new String[0]));
        }
    }

    private void validateEffectiveModelAgainstDependency(String prefix, ModelProblemCollector problems, Model m, Dependency d) {
        String mKey;
        String key = d.getGroupId() + ":" + d.getArtifactId() + ":" + d.getVersion() + (String)(d.getClassifier() != null ? ":" + d.getClassifier() : EMPTY);
        if (key.equals(mKey = m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion())) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V31, prefix + "[" + key + "]", SourceHint.gav(key), "is referencing itself.", (InputLocationTracker)d);
        }
    }

    private void validate20EffectivePluginDependencies(ModelProblemCollector problems, Plugin plugin, int validationLevel) {
        List dependencies = plugin.getDependencies();
        if (!dependencies.isEmpty()) {
            String prefix = "build.plugins.plugin[" + plugin.getKey() + "].dependencies.dependency.";
            BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
            for (Dependency d : dependencies) {
                this.validateEffectiveDependency(problems, d, false, prefix, validationLevel);
                this.validateVersion(prefix, "version", problems, errOn30, ModelProblem.Version.BASE, d.getVersion(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
                this.validateEnum(prefix, "scope", problems, errOn30, ModelProblem.Version.BASE, d.getScope(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d, "compile", "runtime", "system");
            }
        }
    }

    private void validateEffectiveDependency(ModelProblemCollector problems, Dependency d, boolean management, String prefix, int validationLevel) {
        this.validateCoordinatesId(prefix, "artifactId", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getArtifactId(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
        this.validateCoordinatesId(prefix, "groupId", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getGroupId(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
        if (!management) {
            this.validateStringNotEmpty(prefix, "type", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getType(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
            this.validateDependencyVersion(problems, d, prefix);
        }
        if ("system".equals(d.getScope())) {
            String systemPath = d.getSystemPath();
            if (systemPath == null || systemPath.isEmpty()) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", SourceHint.dependencyManagementKey(d), "is missing.", (InputLocationTracker)d);
            } else {
                File sysFile = new File(systemPath);
                if (!sysFile.isAbsolute()) {
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", SourceHint.dependencyManagementKey(d), "must specify an absolute path but is " + systemPath, (InputLocationTracker)d);
                } else if (!sysFile.isFile()) {
                    String msg = "refers to a non-existing file " + sysFile.getAbsolutePath() + ".";
                    DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.BASE, prefix + "systemPath", SourceHint.dependencyManagementKey(d), msg, (InputLocationTracker)d);
                }
            }
        } else if (d.getSystemPath() != null && !d.getSystemPath().isEmpty()) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, prefix + "systemPath", SourceHint.dependencyManagementKey(d), "must be omitted. This field may only be specified for a dependency with system scope.", (InputLocationTracker)d);
        }
        if (validationLevel >= 20) {
            for (Exclusion exclusion : d.getExclusions()) {
                if (validationLevel < 30) {
                    this.validateCoordinatesId(prefix, "exclusions.exclusion.groupId", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getGroupId(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)exclusion);
                    this.validateCoordinatesId(prefix, "exclusions.exclusion.artifactId", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, exclusion.getArtifactId(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)exclusion);
                    continue;
                }
                this.validateCoordinatesIdWithWildcards(prefix, "exclusions.exclusion.groupId", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getGroupId(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)exclusion);
                this.validateCoordinatesIdWithWildcards(prefix, "exclusions.exclusion.artifactId", problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V30, exclusion.getArtifactId(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)exclusion);
            }
        }
    }

    protected void validateDependencyVersion(ModelProblemCollector problems, Dependency d, String prefix) {
        this.validateStringNotEmpty(prefix, "version", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, d.getVersion(), SourceHint.dependencyManagementKey(d), (InputLocationTracker)d);
    }

    private void validateRawRepositories(ModelProblemCollector problems, List<Repository> repositories, String prefix, String prefix2, int validationLevel) {
        HashMap<String, Repository> index = new HashMap<String, Repository>();
        for (Repository repository : repositories) {
            this.validateRawRepository(problems, repository, prefix, prefix2, false);
            String key = repository.getId();
            Repository existing = (Repository)index.get(key);
            if (existing != null) {
                BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
                DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, prefix + prefix2 + "id", null, "must be unique: " + repository.getId() + " -> " + existing.getUrl() + " vs " + repository.getUrl(), (InputLocationTracker)repository);
                continue;
            }
            index.put(key, repository);
        }
    }

    private void validateRawRepository(ModelProblemCollector problems, Repository repository, String prefix, String prefix2, boolean allowEmptyUrl) {
        Matcher matcher;
        if (repository == null) {
            return;
        }
        if (this.validateStringNotEmpty(prefix, prefix2, "id", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getId(), null, (InputLocationTracker)repository) && (matcher = EXPRESSION_NAME_PATTERN.matcher(repository.getId())).find()) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, prefix + prefix2 + "[" + repository.getId() + "].id", null, "contains an uninterpolated expression.", (InputLocationTracker)repository);
        }
        if (!allowEmptyUrl && this.validateStringNotEmpty(prefix, prefix2, "[" + repository.getId() + "].url", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, repository.getUrl(), null, (InputLocationTracker)repository) && (matcher = EXPRESSION_NAME_PATTERN.matcher(repository.getUrl())).find()) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V40, prefix + prefix2 + "[" + repository.getId() + "].url", null, "contains an uninterpolated expression.", (InputLocationTracker)repository);
        }
    }

    private void validate20EffectiveRepository(ModelProblemCollector problems, Repository repository, String prefix, int validationLevel) {
        if (repository != null) {
            BuilderProblem.Severity errOn31 = DefaultModelValidator.getSeverity(validationLevel, 31);
            this.validateBannedCharacters(prefix, "id", problems, errOn31, ModelProblem.Version.V20, repository.getId(), null, (InputLocationTracker)repository, "\\/:\"<>|?*");
            if ("local".equals(repository.getId())) {
                DefaultModelValidator.addViolation(problems, errOn31, ModelProblem.Version.V20, prefix + "id", null, "must not be 'local', this identifier is reserved for the local repository, using it for other repositories will corrupt your repository metadata.", (InputLocationTracker)repository);
            }
            if ("legacy".equals(repository.getLayout())) {
                DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, prefix + "layout", SourceHint.repoId(repository), "uses the unsupported value 'legacy', artifact resolution might fail.", (InputLocationTracker)repository);
            }
        }
    }

    private void validate20RawResources(ModelProblemCollector problems, List<Resource> resources, String prefix, int validationLevel) {
        BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
        for (Resource resource : resources) {
            this.validateStringNotEmpty(prefix, "directory", problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, resource.getDirectory(), null, (InputLocationTracker)resource);
            this.validateBoolean(prefix, "filtering", problems, errOn30, ModelProblem.Version.V20, resource.getFiltering(), SourceHint.resourceDirectory(resource), (InputLocationTracker)resource);
        }
    }

    private boolean validateCoordinatesId(String fieldName, ModelProblemCollector problems, String id, InputLocationTracker tracker) {
        return this.validateCoordinatesId(EMPTY, fieldName, problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, id, null, tracker);
    }

    private boolean validateCoordinatesId(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String id, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (id != null && this.validCoordinatesIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidCoordinatesId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid coordinate id pattern.", tracker);
            return false;
        }
        this.validCoordinatesIds.add(id);
        return true;
    }

    private boolean isValidCoordinatesId(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidCoordinatesIdCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCoordinatesIdCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.';
    }

    private boolean validateProfileId(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String id, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (this.validProfileIds.contains(id)) {
            return true;
        }
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidProfileId(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid profile id pattern.", tracker);
            return false;
        }
        this.validProfileIds.add(id);
        return true;
    }

    private boolean isValidProfileId(String id) {
        return switch (id.charAt(0)) {
            case '!', '+', '-', '?' -> false;
            default -> true;
        };
    }

    private boolean validateCoordinatesIdWithWildcards(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String id, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (!this.validateStringNotEmpty(prefix, fieldName, problems, severity, version, id, sourceHint, tracker)) {
            return false;
        }
        if (!this.isValidCoordinatesIdWithWildCards(id)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "with value '" + id + "' does not match a valid coordinate id pattern.", tracker);
            return false;
        }
        return true;
    }

    private boolean isValidCoordinatesIdWithWildCards(String id) {
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (this.isValidCoordinatesIdWithWildCardCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidCoordinatesIdWithWildCardCharacter(char c) {
        return this.isValidCoordinatesIdCharacter(c) || c == '?' || c == '*';
    }

    private boolean validateStringNoExpression(String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
        return false;
    }

    private boolean validateVersionNoExpression(String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        if (!this.hasExpression(string)) {
            return true;
        }
        Matcher m = EXPRESSION_NAME_PATTERN.matcher(string.trim());
        if (m.find()) {
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, null, "contains an expression but should be a constant.", tracker);
        }
        return true;
    }

    private boolean hasExpression(String value) {
        return value != null && value.contains("${");
    }

    private boolean hasProjectExpression(String value) {
        return value != null && value.contains("${project.");
    }

    private boolean validateStringNotEmpty(String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, InputLocationTracker tracker) {
        return this.validateStringNotEmpty(EMPTY, fieldName, problems, severity, version, string, null, tracker);
    }

    private boolean validateStringNotEmpty(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, prefix2, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateStringNotEmpty(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (!this.validateNotNull(prefix, fieldName, problems, severity, version, string, sourceHint, tracker)) {
            return false;
        }
        if (!string.isEmpty()) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, Object object, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateNotNull(String prefix, String prefix2, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, Object object, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (object != null) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + prefix2 + fieldName, sourceHint, "is missing.", tracker);
        return false;
    }

    private boolean validateBoolean(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be 'true' or 'false' but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateEnum(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker, String ... validValues) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        List<String> values = Arrays.asList(validValues);
        if (values.contains(string)) {
            return true;
        }
        DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be one of " + String.valueOf(values) + " but is '" + string + "'.", tracker);
        return false;
    }

    private boolean validateModelVersion(ModelProblemCollector problems, String string, InputLocationTracker tracker, List<String> validVersions) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (validVersions.contains(string)) {
            return true;
        }
        boolean newerThanAll = true;
        boolean olderThanAll = true;
        for (String validValue : validVersions) {
            int comparison = DefaultModelValidator.compareModelVersions(validValue, string);
            newerThanAll = newerThanAll && comparison < 0;
            olderThanAll = olderThanAll && comparison > 0;
        }
        if (newerThanAll) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is newer than the versions supported by this version of Maven: " + String.valueOf(validVersions) + ". Building this project requires a newer version of Maven.", tracker);
        } else if (olderThanAll) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.FATAL, ModelProblem.Version.V20, "modelVersion", null, "of '" + string + "' is older than the versions supported by this version of Maven: " + String.valueOf(validVersions) + ". Building this project requires an older version of Maven.", tracker);
        } else {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.ERROR, ModelProblem.Version.V20, "modelVersion", null, "must be one of " + String.valueOf(validVersions) + " but is '" + string + "'.", tracker);
        }
        return false;
    }

    private static int compareModelVersions(String first, String second) {
        String[] firstSegments = first.split("\\.");
        String[] secondSegments = second.split("\\.");
        for (int i = 0; i < Math.max(firstSegments.length, secondSegments.length); ++i) {
            int result = DefaultModelValidator.asLong(i, firstSegments).compareTo(DefaultModelValidator.asLong(i, secondSegments));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static Long asLong(int index, String[] segments) {
        try {
            return Long.valueOf(index < segments.length ? segments[index] : "0");
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private boolean validateBannedCharacters(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker, String banned) {
        if (string != null) {
            for (int i = string.length() - 1; i >= 0; --i) {
                if (banned.indexOf(string.charAt(i)) < 0) continue;
                DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must not contain any of these characters " + banned + " but found " + string.charAt(i), tracker);
                return false;
            }
        }
        return true;
    }

    private boolean validateVersion(String prefix, String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (this.hasExpression(string)) {
            DefaultModelValidator.addViolation(problems, severity, version, prefix + fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return this.validateBannedCharacters(prefix, fieldName, problems, severity, version, string, sourceHint, tracker, "\\/:\"<>|?*");
    }

    private boolean validate20ProperSnapshotVersion(String fieldName, ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker) {
        if (string == null || string.isEmpty()) {
            return true;
        }
        if (string.endsWith("SNAPSHOT") && !string.endsWith("-SNAPSHOT")) {
            DefaultModelValidator.addViolation(problems, severity, version, fieldName, sourceHint, "uses an unsupported snapshot version format, should be '*-SNAPSHOT' instead.", tracker);
            return false;
        }
        return true;
    }

    private boolean validate20PluginVersion(String fieldName, ModelProblemCollector problems, String string, @Nullable SourceHint sourceHint, InputLocationTracker tracker, int validationLevel) {
        if (string == null) {
            DefaultModelValidator.addViolation(problems, BuilderProblem.Severity.WARNING, ModelProblem.Version.V20, fieldName, sourceHint, " is missing.", tracker);
            return false;
        }
        BuilderProblem.Severity errOn30 = DefaultModelValidator.getSeverity(validationLevel, 30);
        if (!this.validateVersion(EMPTY, fieldName, problems, errOn30, ModelProblem.Version.V20, string, sourceHint, tracker)) {
            return false;
        }
        if (string.isEmpty() || "RELEASE".equals(string) || "LATEST".equals(string)) {
            DefaultModelValidator.addViolation(problems, errOn30, ModelProblem.Version.V20, fieldName, sourceHint, "must be a valid version but is '" + string + "'.", tracker);
            return false;
        }
        return true;
    }

    private static void addViolation(ModelProblemCollector problems, BuilderProblem.Severity severity, ModelProblem.Version version, String fieldName, @Nullable SourceHint sourceHint, String message, InputLocationTracker tracker) {
        String hint;
        StringBuilder buffer = new StringBuilder(256);
        buffer.append('\'').append(fieldName).append('\'');
        if (sourceHint != null && (hint = (String)sourceHint.get()) != null) {
            buffer.append(" for ").append(hint);
        }
        buffer.append(' ').append(message);
        problems.add(severity, version, buffer.toString(), DefaultModelValidator.getLocation(fieldName, tracker));
    }

    private static InputLocation getLocation(String fieldName, InputLocationTracker tracker) {
        InputLocation location = null;
        if (tracker != null) {
            if (fieldName != null) {
                Object key = fieldName;
                int idx = fieldName.lastIndexOf(46);
                if (idx >= 0) {
                    fieldName = fieldName.substring(idx + 1);
                    key = fieldName;
                }
                if (fieldName.endsWith("]")) {
                    key = fieldName.substring(fieldName.lastIndexOf(91) + 1, fieldName.length() - 1);
                    try {
                        key = Integer.valueOf(key.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                location = tracker.getLocation(key);
            }
            if (location == null) {
                location = tracker.getLocation((Object)EMPTY);
            }
        }
        return location;
    }

    private static boolean equals(String s1, String s2) {
        String c1 = s1 == null ? EMPTY : s1.trim();
        String c2 = s2 == null ? EMPTY : s2.trim();
        return c1.equals(c2);
    }

    private static BuilderProblem.Severity getSeverity(int validationLevel, int errorThreshold) {
        if (validationLevel < errorThreshold) {
            return BuilderProblem.Severity.WARNING;
        }
        return BuilderProblem.Severity.ERROR;
    }

    private static interface SourceHint
    extends Supplier<String> {
        public static SourceHint xmlNodeInputLocation(XmlNode xmlNode) {
            return () -> xmlNode.inputLocation() != null ? xmlNode.inputLocation().toString() : null;
        }

        public static SourceHint gav(String gav) {
            return () -> gav;
        }

        public static SourceHint dependencyManagementKey(Dependency dependency) {
            return () -> {
                String hint = dependency.getClassifier() == null || dependency.getClassifier().isEmpty() ? "groupId=" + SourceHint.valueToValueString(dependency.getGroupId()) + ", artifactId=" + SourceHint.valueToValueString(dependency.getArtifactId()) + ", type=" + SourceHint.valueToValueString(dependency.getType()) : "groupId=" + SourceHint.valueToValueString(dependency.getGroupId()) + ", artifactId=" + SourceHint.valueToValueString(dependency.getArtifactId()) + ", classifier=" + SourceHint.valueToValueString(dependency.getClassifier()) + ", type=" + SourceHint.valueToValueString(dependency.getType());
                return hint;
            };
        }

        private static String valueToValueString(String value) {
            return value == null ? DefaultModelValidator.EMPTY : "'" + value + "'";
        }

        public static SourceHint pluginKey(Plugin plugin) {
            return () -> ((Plugin)plugin).getKey();
        }

        public static SourceHint repoId(Repository repository) {
            return () -> ((Repository)repository).getId();
        }

        @Nullable
        public static SourceHint resourceDirectory(Resource resource) {
            return () -> ((Resource)resource).getDirectory();
        }
    }

    private static class ActivationWalker
    extends MavenTransformer {
        private final Deque<ActivationFrame> stk;

        ActivationWalker(Deque<ActivationFrame> stk, UnaryOperator<String> transformer) {
            super(transformer);
            this.stk = stk;
        }

        private ActivationFrame nextFrame(String property) {
            return new ActivationFrame(property, Optional.empty());
        }

        private <P> ActivationFrame nextFrame(String property, Function<P, InputLocationTracker> child) {
            Optional<? extends InputLocationTracker> parent = this.stk.peek().parent;
            return new ActivationFrame(property, parent.map(child));
        }

        public Activation transformActivation(Activation target) {
            this.stk.push(new ActivationFrame("activation", Optional.of(target)));
            try {
                Activation activation = super.transformActivation(target);
                return activation;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_File(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("file", Activation::getFile));
            try {
                Activation.Builder builder2 = super.transformActivation_File(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationFile.Builder transformActivationFile_Exists(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
            this.stk.push(this.nextFrame("exists"));
            try {
                ActivationFile.Builder builder2 = super.transformActivationFile_Exists(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationFile.Builder transformActivationFile_Missing(Supplier<? extends ActivationFile.Builder> creator, ActivationFile.Builder builder, ActivationFile target) {
            this.stk.push(this.nextFrame("missing"));
            try {
                ActivationFile.Builder builder2 = super.transformActivationFile_Missing(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Jdk(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("jdk"));
            try {
                Activation.Builder builder2 = super.transformActivation_Jdk(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Os(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("os", Activation::getOs));
            try {
                Activation.Builder builder2 = super.transformActivation_Os(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Arch(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("arch"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Arch(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Family(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("family"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Family(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Name(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("name"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Name(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationOS.Builder transformActivationOS_Version(Supplier<? extends ActivationOS.Builder> creator, ActivationOS.Builder builder, ActivationOS target) {
            this.stk.push(this.nextFrame("version"));
            try {
                ActivationOS.Builder builder2 = super.transformActivationOS_Version(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Packaging(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("packaging"));
            try {
                Activation.Builder builder2 = super.transformActivation_Packaging(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Property(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("property", Activation::getProperty));
            try {
                Activation.Builder builder2 = super.transformActivation_Property(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationProperty.Builder transformActivationProperty_Name(Supplier<? extends ActivationProperty.Builder> creator, ActivationProperty.Builder builder, ActivationProperty target) {
            this.stk.push(this.nextFrame("name"));
            try {
                ActivationProperty.Builder builder2 = super.transformActivationProperty_Name(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ActivationProperty.Builder transformActivationProperty_Value(Supplier<? extends ActivationProperty.Builder> creator, ActivationProperty.Builder builder, ActivationProperty target) {
            this.stk.push(this.nextFrame("value"));
            try {
                ActivationProperty.Builder builder2 = super.transformActivationProperty_Value(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Activation.Builder transformActivation_Condition(Supplier<? extends Activation.Builder> creator, Activation.Builder builder, Activation target) {
            this.stk.push(this.nextFrame("condition"));
            try {
                Activation.Builder builder2 = super.transformActivation_Condition(creator, builder, target);
                return builder2;
            }
            finally {
                this.stk.pop();
            }
        }
    }

    private record ActivationFrame(String location, Optional<? extends InputLocationTracker> parent) {
    }
}

