/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Profile
extends ModelBase
implements Serializable,
InputLocationTracker {
    final String id;
    final Activation activation;
    final BuildBase build;
    public static final String SOURCE_POM = "pom";
    public static final String SOURCE_SETTINGS = "settings.xml";
    private String source = "pom";

    protected Profile(Builder builder) {
        super(builder);
        String string = builder.id != null ? builder.id : (this.id = builder.base != null ? builder.base.id : null);
        Activation activation = builder.activation != null ? builder.activation : (this.activation = builder.base != null ? builder.base.activation : null);
        this.build = builder.build != null ? builder.build : (builder.base != null ? builder.base.build : null);
    }

    public String getId() {
        return this.id;
    }

    public Activation getActivation() {
        return this.activation;
    }

    public BuildBase getBuild() {
        return this.build;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Profile.newBuilder(this);
    }

    @Override
    @Deprecated(since="4.0.0")
    @Nonnull
    public Profile withModules(Collection<String> modules) {
        return ((Builder)Profile.newBuilder(this, true).modules((Collection)modules)).build();
    }

    @Override
    @Nonnull
    public Profile withSubprojects(Collection<String> subprojects) {
        return ((Builder)Profile.newBuilder(this, true).subprojects((Collection)subprojects)).build();
    }

    @Override
    @Nonnull
    public Profile withDistributionManagement(DistributionManagement distributionManagement) {
        return Profile.newBuilder(this, true).distributionManagement(distributionManagement).build();
    }

    @Override
    @Nonnull
    public Profile withProperties(Map<String, String> properties) {
        return ((Builder)Profile.newBuilder(this, true).properties((Map)properties)).build();
    }

    @Override
    @Nonnull
    public Profile withDependencyManagement(DependencyManagement dependencyManagement) {
        return Profile.newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }

    @Override
    @Nonnull
    public Profile withDependencies(Collection<Dependency> dependencies) {
        return ((Builder)Profile.newBuilder(this, true).dependencies((Collection)dependencies)).build();
    }

    @Override
    @Nonnull
    public Profile withRepositories(Collection<Repository> repositories) {
        return ((Builder)Profile.newBuilder(this, true).repositories((Collection)repositories)).build();
    }

    @Override
    @Nonnull
    public Profile withPluginRepositories(Collection<Repository> pluginRepositories) {
        return ((Builder)Profile.newBuilder(this, true).pluginRepositories((Collection)pluginRepositories)).build();
    }

    @Override
    @Nonnull
    public Profile withReporting(Reporting reporting) {
        return Profile.newBuilder(this, true).reporting(reporting).build();
    }

    @Nonnull
    public Profile withId(String id) {
        return Profile.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Profile withActivation(Activation activation) {
        return Profile.newBuilder(this, true).activation(activation).build();
    }

    @Nonnull
    public Profile withBuild(BuildBase build) {
        return Profile.newBuilder(this, true).build(build).build();
    }

    @Nonnull
    public static Profile newInstance() {
        return Profile.newInstance(true);
    }

    @Nonnull
    public static Profile newInstance(boolean withDefaults) {
        return Profile.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Profile.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Profile from) {
        return Profile.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Profile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "Profile {id: " + this.getId() + ", source: " + this.getSource() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends ModelBase.Builder {
        Profile base;
        String id;
        Activation activation;
        BuildBase build;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        protected Builder(Profile base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.activation = base.activation;
                this.build = base.build;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Deprecated(since="4.0.0")
        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Override
        @Nonnull
        public Builder subprojects(Collection<String> subprojects) {
            this.subprojects = subprojects;
            return this;
        }

        @Override
        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Override
        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Override
        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activation(Activation activation) {
            this.activation = activation;
            return this;
        }

        @Nonnull
        public Builder build(BuildBase build) {
            this.build = build;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Profile build() {
            if (!(this.base == null || this.modules != null && this.modules != this.base.modules || this.subprojects != null && this.subprojects != this.base.subprojects || this.distributionManagement != null && this.distributionManagement != this.base.distributionManagement || this.properties != null && this.properties != this.base.properties || this.dependencyManagement != null && this.dependencyManagement != this.base.dependencyManagement || this.dependencies != null && this.dependencies != this.base.dependencies || this.repositories != null && this.repositories != this.base.repositories || this.pluginRepositories != null && this.pluginRepositories != this.base.pluginRepositories || this.reporting != null && this.reporting != this.base.reporting || this.id != null && this.id != this.base.id || this.activation != null && this.activation != this.base.activation || this.build != null && this.build != this.base.build)) {
                return this.base;
            }
            return new Profile(this);
        }
    }
}

