/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.cling.invoker.CliUtils;

public final class CWD
implements Supplier<Path> {
    private Path directory;

    public static CWD create(Path path) {
        return new CWD(CliUtils.getCanonicalPath(path));
    }

    private CWD(Path directory) {
        this.directory = directory;
    }

    @Override
    @Nonnull
    public Path get() {
        return this.directory;
    }

    @Nonnull
    public Path resolve(String seg) {
        Objects.requireNonNull(seg, "seg");
        return this.directory.resolve(seg).normalize();
    }

    public void change(String seg) {
        Path newCwd = this.resolve(seg);
        if (!Files.isDirectory(newCwd, new LinkOption[0])) {
            throw new IllegalArgumentException("Directory '" + String.valueOf(this.directory) + "' does not exist");
        }
        this.directory = newCwd;
    }
}

