/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.GAV;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class GAVUtils {
    private GAVUtils() {
    }

    public static Set<GAV> computeAllGAVs(UpgradeContext context, Map<Path, Document> pomMap) {
        HashSet<GAV> gavs = new HashSet<GAV>();
        context.info("Computing GAVs for inference from " + pomMap.size() + " POM(s)...");
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path pomPath = entry.getKey();
            Document pomDocument = entry.getValue();
            GAV gav = GAVUtils.extractGAVWithParentResolution(context, pomDocument);
            if (gav == null) continue;
            gavs.add(gav);
            context.debug("Found GAV: " + String.valueOf(gav) + " from " + String.valueOf(pomPath));
        }
        context.info("Computed " + gavs.size() + " unique GAV(s) for inference");
        return gavs;
    }

    public static GAV extractGAVWithParentResolution(UpgradeContext context, Document pomDocument) {
        Element parentElement;
        Element root = pomDocument.getRootElement();
        Namespace namespace = root.getNamespace();
        String groupId = GAVUtils.getElementText(root, "groupId", namespace);
        String artifactId = GAVUtils.getElementText(root, "artifactId", namespace);
        String version = GAVUtils.getElementText(root, "version", namespace);
        if ((groupId == null || version == null) && (parentElement = root.getChild("parent", namespace)) != null) {
            if (groupId == null) {
                groupId = GAVUtils.getElementText(parentElement, "groupId", namespace);
            }
            if (version == null) {
                version = GAVUtils.getElementText(parentElement, "version", namespace);
            }
        }
        if (artifactId == null || artifactId.isEmpty()) {
            context.debug("Cannot determine artifactId for POM");
            return null;
        }
        if (groupId == null || groupId.isEmpty() || version == null || version.isEmpty()) {
            context.debug("Cannot determine complete GAV for artifactId: " + artifactId);
            return null;
        }
        return new GAV(groupId, artifactId, version);
    }

    private static String getElementText(Element parent, String elementName, Namespace namespace) {
        Element element = parent.getChild(elementName, namespace);
        return element != null ? element.getTextTrim() : null;
    }
}

