/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.logging.impl;

import org.apache.maven.cling.logging.BaseSlf4jConfiguration;
import org.apache.maven.cling.logging.Slf4jConfiguration;
import org.apache.maven.slf4j.MavenLoggerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSimpleConfiguration
extends BaseSlf4jConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenSimpleConfiguration.class);

    @Override
    public void setRootLoggerLevel(Slf4jConfiguration.Level level) {
        String value = switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Slf4jConfiguration.Level.DEBUG -> "debug";
            case Slf4jConfiguration.Level.INFO -> "info";
            case Slf4jConfiguration.Level.ERROR -> "error";
        };
        String current = System.setProperty("maven.logger.defaultLogLevel", value);
        if (current != null && !value.equalsIgnoreCase(current)) {
            LOGGER.info("System property 'maven.logger.defaultLogLevel' is already set to '" + current + "' - ignoring system property and get log level from -X/-e/-q options, log level will be set to " + value);
        }
    }

    @Override
    public void activate() {
        ILoggerFactory lf = LoggerFactory.getILoggerFactory();
        if (lf instanceof MavenLoggerFactory) {
            MavenLoggerFactory mlf = (MavenLoggerFactory)lf;
            mlf.reconfigure();
        }
    }
}

