/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.utils;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.impl.util.Os;
import org.apache.maven.jline.MessageUtils;
import org.slf4j.Logger;

public final class CLIReportingUtils {
    public static final long MB = 0x100000L;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    public static final String BUILD_VERSION_PROPERTY = "version";

    public static String showVersion() {
        return CLIReportingUtils.showVersion(null, null);
    }

    public static String showVersion(String commandLine, String terminal) {
        String ls = System.lineSeparator();
        Properties properties = CLIReportingUtils.getBuildProperties();
        StringBuilder version = new StringBuilder(256);
        version.append(MessageUtils.builder().strong((Object)CLIReportingUtils.createMavenVersionString(properties))).append(ls);
        version.append(CLIReportingUtils.reduce(properties.getProperty("distributionShortName") + " home: " + System.getProperty("maven.home", "<unknown Maven home>"))).append(ls);
        version.append("Java version: ").append(System.getProperty("java.version", "<unknown Java version>")).append(", vendor: ").append(System.getProperty("java.vendor", "<unknown vendor>")).append(", runtime: ").append(System.getProperty("java.home", "<unknown runtime>")).append(ls);
        version.append("Default locale: ").append(Locale.getDefault()).append(", platform encoding: ").append(System.getProperty("file.encoding", "<unknown encoding>")).append(ls);
        version.append("OS name: \"").append(Os.OS_NAME).append("\", version: \"").append(Os.OS_VERSION).append("\", arch: \"").append(Os.OS_ARCH).append("\", family: \"").append(Os.OS_FAMILY).append('\"');
        if (commandLine != null) {
            version.append(ls).append("Command line: ").append(commandLine);
        }
        if (terminal != null) {
            version.append(ls).append("Terminal: ").append(terminal);
        }
        return version.toString();
    }

    public static String showVersionMinimal() {
        Properties properties = CLIReportingUtils.getBuildProperties();
        String version = CLIReportingUtils.reduce(properties.getProperty(BUILD_VERSION_PROPERTY));
        return version != null ? version : "<version unknown>";
    }

    public static String createMavenVersionString(Properties buildProperties) {
        String version = CLIReportingUtils.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = CLIReportingUtils.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = CLIReportingUtils.reduce(buildProperties.getProperty("distributionName"));
        return distributionName + " " + (version != null ? version : "<version unknown>") + (String)(rev != null ? " (" + rev + ")" : "");
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    public static Properties getBuildProperties() {
        Properties properties = new Properties();
        try (InputStream resourceAsStream = CLIReportingUtils.class.getResourceAsStream("/org/apache/maven/messages/build.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        return properties;
    }

    public static void showError(Logger logger, String message, Throwable e, boolean showStackTrace) {
        if (logger == null) {
            System.err.println(message);
            if (showStackTrace && e != null) {
                e.printStackTrace(System.err);
            }
            return;
        }
        if (showStackTrace) {
            logger.error(message, e);
        } else {
            logger.error(message);
            if (e != null) {
                logger.error(e.getMessage());
                for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                    logger.error("Caused by: {}", (Object)cause.getMessage());
                }
            }
        }
    }

    public static String formatTimestamp(TemporalAccessor instant) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(instant);
    }

    public static String formatDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        long seconds = duration.toSecondsPart();
        long millis = duration.toMillisPart();
        if (days > 0L) {
            return String.format("%d d %02d:%02d h", days, hours, minutes);
        }
        if (hours > 0L) {
            return String.format("%02d:%02d h", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%02d:%02d min", minutes, seconds);
        }
        return String.format("%d.%03d s", seconds, millis);
    }
}

