/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.element.Application;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.ClientBehaviorRenderer;
import org.apache.myfaces.config.element.Component;
import org.apache.myfaces.config.element.ComponentTagDeclaration;
import org.apache.myfaces.config.element.ContractMapping;
import org.apache.myfaces.config.element.Converter;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.config.element.FaceletsTemplateMapping;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigExtension;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.Factory;
import org.apache.myfaces.config.element.LocaleConfig;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.RenderKit;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.SystemEventListener;
import org.apache.myfaces.config.element.ViewPoolMapping;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.impl.element.RenderKitImpl;

public class FacesConfigDispenserImpl
extends FacesConfigDispenser {
    private static final long serialVersionUID = 3550379003287939559L;
    private static final Logger log = Logger.getLogger(FacesConfigDispenserImpl.class.getName());
    private List<String> applicationFactories = new ArrayList<String>();
    private List<String> exceptionHandlerFactories = new ArrayList<String>();
    private List<String> externalContextFactories = new ArrayList<String>();
    private List<String> facesContextFactories = new ArrayList<String>();
    private List<String> lifecycleFactories = new ArrayList<String>();
    private List<String> viewDeclarationLanguageFactories = new ArrayList<String>();
    private List<String> partialViewContextFactories = new ArrayList<String>();
    private List<String> renderKitFactories = new ArrayList<String>();
    private List<String> tagHandlerDelegateFactories = new ArrayList<String>();
    private List<String> visitContextFactories = new ArrayList<String>();
    private List<String> faceletCacheFactories = new ArrayList<String>();
    private List<String> flashFactories = new ArrayList<String>();
    private List<String> clientWindowFactories = new ArrayList<String>();
    private List<String> flowHandlerFactories = new ArrayList<String>();
    private List<String> searchExpressionContextFactories = new ArrayList<String>();
    private String defaultRenderKitId;
    private String messageBundle;
    private String facesVersion;
    private LocaleConfig localeConfig;
    private Map<String, Component> components = new HashMap<String, Component>();
    private Map<String, String> converterByClass = new HashMap<String, String>();
    private Map<String, String> converterById = new HashMap<String, String>();
    private Map<String, String> validators = new HashMap<String, String>();
    private List<Behavior> behaviors = new ArrayList<Behavior>();
    private Map<String, Converter> converterConfigurationByClassName = new HashMap<String, Converter>();
    private Map<String, RenderKit> renderKits = new LinkedHashMap<String, RenderKit>();
    private List<String> actionListeners = new ArrayList<String>();
    private List<String> elResolvers = new ArrayList<String>();
    private List<String> lifecyclePhaseListeners = new ArrayList<String>();
    private List<String> navigationHandlers = new ArrayList<String>();
    private List<String> propertyResolver = new ArrayList<String>();
    private List<String> resourceHandlers = new ArrayList<String>();
    private List<String> stateManagers = new ArrayList<String>();
    private List<String> variableResolver = new ArrayList<String>();
    private List<String> viewHandlers = new ArrayList<String>();
    private List<String> defaultValidatorIds = new ArrayList<String>();
    private List<String> defaultAnnotatedValidatorIds = new ArrayList<String>();
    private List<String> searchExpressionHandlers = new ArrayList<String>();
    private List<String> searchKeywordResolvers = new ArrayList<String>();
    private List<NavigationRule> navigationRules = new ArrayList<NavigationRule>();
    private List<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
    private List<SystemEventListener> systemEventListeners = new ArrayList<SystemEventListener>();
    private List<NamedEvent> namedEvents = new ArrayList<NamedEvent>();
    private Map<String, FaceletsProcessing> faceletsProcessingByFileExtension = new HashMap<String, FaceletsProcessing>();
    private List<FacesFlowDefinition> facesFlowDefinitions = new ArrayList<FacesFlowDefinition>();
    private List<String> protectedViewUrlPatterns = new ArrayList<String>();
    private List<ContractMapping> resourceLibraryContractMappings = new ArrayList<ContractMapping>();
    private List<ComponentTagDeclaration> componentTagDeclarations = new ArrayList<ComponentTagDeclaration>();
    private List<FaceletTagLibrary> faceletTagLibraries = new ArrayList<FaceletTagLibrary>();
    private List<String> resourceResolvers = new ArrayList<String>();
    private List<ViewPoolMapping> viewPoolMappings = new ArrayList<ViewPoolMapping>();
    private List<FaceletsTemplateMapping> faceletsTemplateMappings = new ArrayList<FaceletsTemplateMapping>();
    private transient List<String> umapplicationFactories;
    private transient List<String> umexceptionHandlerFactories;
    private transient List<String> umexternalContextFactories;
    private transient List<String> umfacesContextFactories;
    private transient List<String> umlifecycleFactories;
    private transient List<String> umviewDeclarationLanguageFactories;
    private transient List<String> umpartialViewContextFactories;
    private transient List<String> umrenderKitFactories;
    private transient List<String> umtagHandlerDelegateFactories;
    private transient List<String> umvisitContextFactories;
    private transient List<String> umfaceletCacheFactories;
    private transient List<String> umflashFactories;
    private transient List<String> umclientWindowFactories;
    private transient List<String> umflowHandlerFactories;
    private transient List<String> umsearchExpressionContextFactories;
    private transient List<Behavior> umbehaviors;
    private transient List<String> umactionListeners;
    private transient List<String> umelResolvers;
    private transient List<String> umlifecyclePhaseListeners;
    private transient List<String> umnavigationHandlers;
    private transient List<String> umpropertyResolver;
    private transient List<String> umresourceHandlers;
    private transient List<String> umstateManagers;
    private transient List<String> umvariableResolver;
    private transient List<String> umviewHandlers;
    private transient List<String> umsearchExpressionHandlers;
    private transient List<String> umsearchKeywordResolvers;
    private transient List<NavigationRule> umnavigationRules;
    private transient List<ResourceBundle> umresourceBundles;
    private transient List<SystemEventListener> umsystemEventListeners;
    private transient List<NamedEvent> umnamedEvents;
    private transient List<FacesFlowDefinition> umfacesFlowDefinitions;
    private transient List<String> umprotectedViewUrlPatterns;
    private transient List<ContractMapping> umresourceLibraryContractMappings;
    private transient List<ComponentTagDeclaration> umcomponentTagDeclarations;
    private transient List<FaceletTagLibrary> umfaceletTagLibraries;
    private transient List<String> umresourceResolvers;
    private transient List<ViewPoolMapping> umviewPoolMappings;
    private transient List<FaceletsTemplateMapping> umfaceletsTemplateMappings;

    @Override
    public void feed(FacesConfig config) {
        for (Factory factory : config.getFactories()) {
            this.applicationFactories.addAll(factory.getApplicationFactory());
            this.exceptionHandlerFactories.addAll(factory.getExceptionHandlerFactory());
            this.externalContextFactories.addAll(factory.getExternalContextFactory());
            this.facesContextFactories.addAll(factory.getFacesContextFactory());
            this.lifecycleFactories.addAll(factory.getLifecycleFactory());
            this.viewDeclarationLanguageFactories.addAll(factory.getViewDeclarationLanguageFactory());
            this.partialViewContextFactories.addAll(factory.getPartialViewContextFactory());
            this.renderKitFactories.addAll(factory.getRenderkitFactory());
            this.tagHandlerDelegateFactories.addAll(factory.getTagHandlerDelegateFactory());
            this.visitContextFactories.addAll(factory.getVisitContextFactory());
            this.faceletCacheFactories.addAll(factory.getFaceletCacheFactory());
            this.flashFactories.addAll(factory.getFlashFactory());
            this.clientWindowFactories.addAll(factory.getClientWindowFactory());
            this.flowHandlerFactories.addAll(factory.getFlowHandlerFactory());
            this.searchExpressionContextFactories.addAll(factory.getSearchExpressionContextFactory());
        }
        for (Component component : config.getComponents()) {
            this.components.put(component.getComponentType(), component);
        }
        this.validators.putAll(config.getValidators());
        this.behaviors.addAll(config.getBehaviors());
        for (Application application : config.getApplications()) {
            if (!application.getDefaultRenderkitId().isEmpty()) {
                this.defaultRenderKitId = application.getDefaultRenderkitId().get(application.getDefaultRenderkitId().size() - 1);
            }
            if (!application.getMessageBundle().isEmpty()) {
                this.messageBundle = application.getMessageBundle().get(application.getMessageBundle().size() - 1);
            }
            if (!application.getLocaleConfig().isEmpty()) {
                this.localeConfig = application.getLocaleConfig().get(application.getLocaleConfig().size() - 1);
            }
            this.actionListeners.addAll(application.getActionListener());
            this.navigationHandlers.addAll(application.getNavigationHandler());
            this.resourceHandlers.addAll(application.getResourceHandler());
            this.viewHandlers.addAll(application.getViewHandler());
            this.stateManagers.addAll(application.getStateManager());
            this.propertyResolver.addAll(application.getPropertyResolver());
            this.variableResolver.addAll(application.getVariableResolver());
            this.resourceBundles.addAll(application.getResourceBundle());
            this.elResolvers.addAll(application.getElResolver());
            this.resourceLibraryContractMappings.addAll(application.getResourceLibraryContractMappings());
            this.searchExpressionHandlers.addAll(application.getSearchExpressionHandler());
            this.searchKeywordResolvers.addAll(application.getSearchKeywordResolver());
            if (application.isDefaultValidatorsPresent()) {
                this.defaultValidatorIds.clear();
                this.defaultValidatorIds.addAll(application.getDefaultValidatorIds());
            } else {
                this.defaultAnnotatedValidatorIds.addAll(application.getDefaultValidatorIds());
            }
            this.systemEventListeners.addAll(application.getSystemEventListeners());
        }
        for (Converter converter : config.getConverters()) {
            if (converter.getConverterId() != null) {
                this.converterById.put(converter.getConverterId(), converter.getConverterClass());
            }
            if (converter.getForClass() != null) {
                String oldConverter = this.converterByClass.get(converter.getForClass());
                if (oldConverter != null && !oldConverter.startsWith("jakarta.faces.convert.")) {
                    log.warning("There is already a converter defined for class: " + converter.getForClass() + ". old: " + oldConverter + " new: " + converter.getConverterClass());
                }
                this.converterByClass.put(converter.getForClass(), converter.getConverterClass());
            }
            this.converterConfigurationByClassName.put(converter.getConverterClass(), converter);
        }
        for (RenderKit renderKit : config.getRenderKits()) {
            RenderKit existing;
            String renderKitId = renderKit.getId();
            if (renderKitId == null) {
                renderKitId = "HTML_BASIC";
            }
            if ((existing = this.renderKits.get(renderKitId)) == null) {
                existing = new RenderKitImpl();
                existing.merge(renderKit);
                this.renderKits.put(renderKitId, existing);
                continue;
            }
            existing.merge(renderKit);
        }
        for (FacesConfigExtension extension : config.getFacesConfigExtensions()) {
            for (FaceletsProcessing faceletsProcessing : extension.getFaceletsProcessingList()) {
                if (faceletsProcessing.getFileExtension() == null || faceletsProcessing.getFileExtension().length() <= 0) continue;
                this.faceletsProcessingByFileExtension.put(faceletsProcessing.getFileExtension(), faceletsProcessing);
            }
        }
        this.componentTagDeclarations.addAll(config.getComponentTagDeclarations());
        this.faceletTagLibraries.addAll(config.getFaceletTagLibraryList());
        this.lifecyclePhaseListeners.addAll(config.getLifecyclePhaseListener());
        this.navigationRules.addAll(config.getNavigationRules());
        this.facesVersion = config.getVersion();
        this.namedEvents.addAll(config.getNamedEvents());
        this.facesFlowDefinitions.addAll(config.getFacesFlowDefinitions());
        this.protectedViewUrlPatterns.addAll(config.getProtectedViewsUrlPatternList());
        this.resourceResolvers.addAll(config.getResourceResolversList());
        for (FacesConfigExtension extension : config.getFacesConfigExtensions()) {
            this.viewPoolMappings.addAll(extension.getViewPoolMappings());
        }
        for (FacesConfigExtension extension : config.getFacesConfigExtensions()) {
            this.faceletsTemplateMappings.addAll(extension.getFaceletsTemplateMappings());
        }
    }

    @Override
    public void feedApplicationFactory(String factoryClassName) {
        this.applicationFactories.add(factoryClassName);
    }

    @Override
    public void feedExceptionHandlerFactory(String factoryClassName) {
        this.exceptionHandlerFactories.add(factoryClassName);
    }

    @Override
    public void feedExternalContextFactory(String factoryClassName) {
        this.externalContextFactories.add(factoryClassName);
    }

    @Override
    public void feedFacesContextFactory(String factoryClassName) {
        this.facesContextFactories.add(factoryClassName);
    }

    @Override
    public void feedLifecycleFactory(String factoryClassName) {
        this.lifecycleFactories.add(factoryClassName);
    }

    @Override
    public void feedViewDeclarationLanguageFactory(String factoryClassName) {
        this.viewDeclarationLanguageFactories.add(factoryClassName);
    }

    @Override
    public void feedPartialViewContextFactory(String factoryClassName) {
        this.partialViewContextFactories.add(factoryClassName);
    }

    @Override
    public void feedRenderKitFactory(String factoryClassName) {
        this.renderKitFactories.add(factoryClassName);
    }

    @Override
    public void feedTagHandlerDelegateFactory(String factoryClassName) {
        this.tagHandlerDelegateFactories.add(factoryClassName);
    }

    @Override
    public void feedVisitContextFactory(String factoryClassName) {
        this.visitContextFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getApplicationFactoryIterator() {
        if (this.umapplicationFactories == null) {
            this.umapplicationFactories = Collections.unmodifiableList(this.applicationFactories);
        }
        return this.umapplicationFactories;
    }

    @Override
    public Collection<String> getExceptionHandlerFactoryIterator() {
        if (this.umexceptionHandlerFactories == null) {
            this.umexceptionHandlerFactories = Collections.unmodifiableList(this.exceptionHandlerFactories);
        }
        return this.umexceptionHandlerFactories;
    }

    @Override
    public Collection<String> getExternalContextFactoryIterator() {
        if (this.umexternalContextFactories == null) {
            this.umexternalContextFactories = Collections.unmodifiableList(this.externalContextFactories);
        }
        return this.umexternalContextFactories;
    }

    @Override
    public Collection<String> getFacesContextFactoryIterator() {
        if (this.umfacesContextFactories == null) {
            this.umfacesContextFactories = Collections.unmodifiableList(this.facesContextFactories);
        }
        return this.umfacesContextFactories;
    }

    @Override
    public Collection<String> getLifecycleFactoryIterator() {
        if (this.umlifecycleFactories == null) {
            this.umlifecycleFactories = Collections.unmodifiableList(this.lifecycleFactories);
        }
        return this.umlifecycleFactories;
    }

    @Override
    public Collection<String> getViewDeclarationLanguageFactoryIterator() {
        if (this.umviewDeclarationLanguageFactories == null) {
            this.umviewDeclarationLanguageFactories = Collections.unmodifiableList(this.viewDeclarationLanguageFactories);
        }
        return this.umviewDeclarationLanguageFactories;
    }

    @Override
    public Collection<String> getPartialViewContextFactoryIterator() {
        if (this.umpartialViewContextFactories == null) {
            this.umpartialViewContextFactories = Collections.unmodifiableList(this.partialViewContextFactories);
        }
        return this.umpartialViewContextFactories;
    }

    @Override
    public Collection<String> getRenderKitFactoryIterator() {
        if (this.umrenderKitFactories == null) {
            this.umrenderKitFactories = Collections.unmodifiableList(this.renderKitFactories);
        }
        return this.umrenderKitFactories;
    }

    @Override
    public Collection<String> getTagHandlerDelegateFactoryIterator() {
        if (this.umtagHandlerDelegateFactories == null) {
            this.umtagHandlerDelegateFactories = Collections.unmodifiableList(this.tagHandlerDelegateFactories);
        }
        return this.umtagHandlerDelegateFactories;
    }

    @Override
    public Collection<String> getVisitContextFactoryIterator() {
        if (this.umvisitContextFactories == null) {
            this.umvisitContextFactories = Collections.unmodifiableList(this.visitContextFactories);
        }
        return this.umvisitContextFactories;
    }

    @Override
    public Collection<String> getActionListenerIterator() {
        if (this.umactionListeners == null) {
            this.umactionListeners = Collections.unmodifiableList(this.actionListeners);
        }
        return this.umactionListeners;
    }

    @Override
    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }

    @Override
    public String getMessageBundle() {
        return this.messageBundle;
    }

    @Override
    public Collection<String> getNavigationHandlerIterator() {
        if (this.umnavigationHandlers == null) {
            this.umnavigationHandlers = Collections.unmodifiableList(this.navigationHandlers);
        }
        return this.umnavigationHandlers;
    }

    @Override
    public Collection<String> getResourceHandlerIterator() {
        if (this.umresourceHandlers == null) {
            this.umresourceHandlers = Collections.unmodifiableList(this.resourceHandlers);
        }
        return this.umresourceHandlers;
    }

    @Override
    public Collection<String> getViewHandlerIterator() {
        if (this.umviewHandlers == null) {
            this.umviewHandlers = Collections.unmodifiableList(this.viewHandlers);
        }
        return this.umviewHandlers;
    }

    @Override
    public Collection<String> getStateManagerIterator() {
        if (this.umstateManagers == null) {
            this.umstateManagers = Collections.unmodifiableList(this.stateManagers);
        }
        return this.umstateManagers;
    }

    @Override
    public Collection<String> getPropertyResolverIterator() {
        if (this.umpropertyResolver == null) {
            this.umpropertyResolver = Collections.unmodifiableList(this.propertyResolver);
        }
        return this.umpropertyResolver;
    }

    @Override
    public Collection<String> getVariableResolverIterator() {
        if (this.umvariableResolver == null) {
            this.umvariableResolver = Collections.unmodifiableList(this.variableResolver);
        }
        return this.umvariableResolver;
    }

    @Override
    public String getDefaultLocale() {
        if (this.localeConfig != null) {
            return this.localeConfig.getDefaultLocale();
        }
        return null;
    }

    @Override
    public Collection<String> getSupportedLocalesIterator() {
        Collection<String> locale = this.localeConfig != null ? Collections.unmodifiableCollection(this.localeConfig.getSupportedLocales()) : Collections.emptyList();
        return locale;
    }

    @Override
    public Collection<String> getComponentTypes() {
        return Collections.unmodifiableCollection(this.components.keySet());
    }

    @Override
    public Map<String, Component> getComponentsByType() {
        return Collections.unmodifiableMap(this.components);
    }

    @Override
    public String getComponentClass(String componentType) {
        Component component = this.components.get(componentType);
        return component == null ? null : component.getComponentClass();
    }

    @Override
    public Collection<String> getConverterIds() {
        return Collections.unmodifiableCollection(this.converterById.keySet());
    }

    @Override
    public Map<String, String> getConverterClassesById() {
        return Collections.unmodifiableMap(this.converterById);
    }

    @Override
    public Collection<String> getConverterClasses() {
        return Collections.unmodifiableCollection(this.converterByClass.keySet());
    }

    @Override
    public Map<String, String> getConverterClassesByClass() {
        return Collections.unmodifiableMap(this.converterByClass);
    }

    @Override
    public Collection<String> getConverterConfigurationByClassName() {
        return Collections.unmodifiableCollection(this.converterConfigurationByClassName.keySet());
    }

    @Override
    public Converter getConverterConfiguration(String converterClassName) {
        return this.converterConfigurationByClassName.get(converterClassName);
    }

    @Override
    public String getConverterClassById(String converterId) {
        return this.converterById.get(converterId);
    }

    @Override
    public String getConverterClassByClass(String className) {
        return this.converterByClass.get(className);
    }

    @Override
    public Collection<String> getDefaultValidatorIds() {
        ArrayList<String> allDefaultValidatorIds = new ArrayList<String>();
        allDefaultValidatorIds.addAll(this.defaultAnnotatedValidatorIds);
        allDefaultValidatorIds.addAll(this.defaultValidatorIds);
        return Collections.unmodifiableCollection(allDefaultValidatorIds);
    }

    @Override
    public Collection<String> getValidatorIds() {
        return Collections.unmodifiableCollection(this.validators.keySet());
    }

    @Override
    public Map<String, String> getValidatorClassesById() {
        return Collections.unmodifiableMap(this.validators);
    }

    @Override
    public String getValidatorClass(String validatorId) {
        return this.validators.get(validatorId);
    }

    @Override
    public Collection<NavigationRule> getNavigationRules() {
        if (this.umnavigationRules == null) {
            this.umnavigationRules = Collections.unmodifiableList(this.navigationRules);
        }
        return this.umnavigationRules;
    }

    @Override
    public Collection<String> getRenderKitIds() {
        return Collections.unmodifiableCollection(this.renderKits.keySet());
    }

    @Override
    public Collection<String> getRenderKitClasses(String renderKitId) {
        return this.renderKits.get(renderKitId).getRenderKitClasses();
    }

    @Override
    public Collection<ClientBehaviorRenderer> getClientBehaviorRenderers(String renderKitId) {
        return this.renderKits.get(renderKitId).getClientBehaviorRenderers();
    }

    @Override
    public Collection<Renderer> getRenderers(String renderKitId) {
        return this.renderKits.get(renderKitId).getRenderer();
    }

    @Override
    public Collection<String> getLifecyclePhaseListeners() {
        if (this.umlifecyclePhaseListeners == null) {
            this.umlifecyclePhaseListeners = Collections.unmodifiableList(this.lifecyclePhaseListeners);
        }
        return this.umlifecyclePhaseListeners;
    }

    @Override
    public Collection<ResourceBundle> getResourceBundles() {
        if (this.umresourceBundles == null) {
            this.umresourceBundles = Collections.unmodifiableList(this.resourceBundles);
        }
        return this.umresourceBundles;
    }

    @Override
    public Collection<String> getElResolvers() {
        if (this.umelResolvers == null) {
            this.umelResolvers = Collections.unmodifiableList(this.elResolvers);
        }
        return this.umelResolvers;
    }

    @Override
    public Collection<SystemEventListener> getSystemEventListeners() {
        if (this.umsystemEventListeners == null) {
            this.umsystemEventListeners = Collections.unmodifiableList(this.systemEventListeners);
        }
        return this.umsystemEventListeners;
    }

    @Override
    public Collection<Behavior> getBehaviors() {
        if (this.umbehaviors == null) {
            this.umbehaviors = Collections.unmodifiableList(this.behaviors);
        }
        return this.umbehaviors;
    }

    @Override
    public String getFacesVersion() {
        return this.facesVersion;
    }

    @Override
    public Collection<NamedEvent> getNamedEvents() {
        if (this.umnamedEvents == null) {
            this.umnamedEvents = Collections.unmodifiableList(this.namedEvents);
        }
        return this.umnamedEvents;
    }

    @Override
    public Collection<FaceletsProcessing> getFaceletsProcessing() {
        return Collections.unmodifiableCollection(this.faceletsProcessingByFileExtension.values());
    }

    @Override
    public FaceletsProcessing getFaceletsProcessingConfiguration(String fileExtension) {
        return this.faceletsProcessingByFileExtension.get(fileExtension);
    }

    @Override
    public void feedFaceletCacheFactory(String factoryClassName) {
        this.faceletCacheFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getFaceletCacheFactoryIterator() {
        if (this.umfaceletCacheFactories == null) {
            this.umfaceletCacheFactories = Collections.unmodifiableList(this.faceletCacheFactories);
        }
        return this.umfaceletCacheFactories;
    }

    @Override
    public void feedFlashFactory(String factoryClassName) {
        this.flashFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getFlashFactoryIterator() {
        if (this.umflashFactories == null) {
            this.umflashFactories = Collections.unmodifiableList(this.flashFactories);
        }
        return this.umflashFactories;
    }

    @Override
    public Collection<String> getFlowHandlerFactoryIterator() {
        if (this.umflowHandlerFactories == null) {
            this.umflowHandlerFactories = Collections.unmodifiableList(this.flowHandlerFactories);
        }
        return this.umflowHandlerFactories;
    }

    @Override
    public void feedClientWindowFactory(String factoryClassName) {
        this.clientWindowFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getClientWindowFactoryIterator() {
        if (this.umclientWindowFactories == null) {
            this.umclientWindowFactories = Collections.unmodifiableList(this.clientWindowFactories);
        }
        return this.umclientWindowFactories;
    }

    @Override
    public Collection<FacesFlowDefinition> getFacesFlowDefinitions() {
        if (this.umfacesFlowDefinitions == null) {
            this.umfacesFlowDefinitions = Collections.unmodifiableList(this.facesFlowDefinitions);
        }
        return this.umfacesFlowDefinitions;
    }

    @Override
    public Collection<String> getProtectedViewUrlPatterns() {
        if (this.umprotectedViewUrlPatterns == null) {
            this.umprotectedViewUrlPatterns = Collections.unmodifiableList(this.protectedViewUrlPatterns);
        }
        return this.umprotectedViewUrlPatterns;
    }

    @Override
    public Collection<ContractMapping> getResourceLibraryContractMappings() {
        if (this.umresourceLibraryContractMappings == null) {
            this.umresourceLibraryContractMappings = Collections.unmodifiableList(this.resourceLibraryContractMappings);
        }
        return this.umresourceLibraryContractMappings;
    }

    @Override
    public Collection<ComponentTagDeclaration> getComponentTagDeclarations() {
        if (this.umcomponentTagDeclarations == null) {
            this.umcomponentTagDeclarations = Collections.unmodifiableList(this.componentTagDeclarations);
        }
        return this.umcomponentTagDeclarations;
    }

    @Override
    public Collection<String> getResourceResolvers() {
        if (this.umresourceResolvers == null) {
            this.umresourceResolvers = Collections.unmodifiableList(this.resourceResolvers);
        }
        return this.umresourceResolvers;
    }

    @Override
    public Collection<FaceletTagLibrary> getTagLibraries() {
        if (this.umfaceletTagLibraries == null) {
            this.umfaceletTagLibraries = Collections.unmodifiableList(this.faceletTagLibraries);
        }
        return this.umfaceletTagLibraries;
    }

    @Override
    public Collection<ViewPoolMapping> getViewPoolMappings() {
        if (this.umviewPoolMappings == null) {
            this.umviewPoolMappings = Collections.unmodifiableList(this.viewPoolMappings);
        }
        return this.umviewPoolMappings;
    }

    @Override
    public void feedSearchExpressionContextFactory(String factoryClassName) {
        this.searchExpressionContextFactories.add(factoryClassName);
    }

    @Override
    public Collection<String> getSearchExpressionContextFactoryIterator() {
        if (this.umsearchExpressionContextFactories == null) {
            this.umsearchExpressionContextFactories = Collections.unmodifiableList(this.searchExpressionContextFactories);
        }
        return this.umsearchExpressionContextFactories;
    }

    @Override
    public Collection<String> getSearchKeywordResolvers() {
        if (this.umsearchKeywordResolvers == null) {
            this.umsearchKeywordResolvers = Collections.unmodifiableList(this.searchKeywordResolvers);
        }
        return this.umsearchKeywordResolvers;
    }

    @Override
    public Collection<String> getSearchExpressionHandlerIterator() {
        if (this.umsearchExpressionHandlers == null) {
            this.umsearchExpressionHandlers = Collections.unmodifiableList(this.searchExpressionHandlers);
        }
        return this.umsearchExpressionHandlers;
    }

    @Override
    public Collection<FaceletsTemplateMapping> getFaceletsTemplateMappings() {
        if (this.umfaceletsTemplateMappings == null) {
            this.umfaceletsTemplateMappings = Collections.unmodifiableList(this.faceletsTemplateMappings);
        }
        return this.umfaceletsTemplateMappings;
    }
}

