/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractTableNameRegistry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReverseTableMapItem;
import io.questdb.cairo.TableToken;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentHashMap;

public class TableNameRegistryRW
extends AbstractTableNameRegistry {
    private final ConcurrentHashMap<TableToken> nameTableTokenMap = new ConcurrentHashMap(false);
    private final ConcurrentHashMap<ReverseTableMapItem> reverseTableNameTokenMap = new ConcurrentHashMap();

    public TableNameRegistryRW(CairoConfiguration configuration) {
        super(configuration);
        if (!this.nameStore.lock() && !configuration.getAllowTableRegistrySharedWrite()) {
            throw CairoException.critical(0).put("cannot lock table name registry file [path=").put(configuration.getRoot()).put(']');
        }
        this.setNameMaps(this.nameTableTokenMap, this.reverseTableNameTokenMap);
    }

    @Override
    public boolean dropTable(TableToken token) {
        ReverseTableMapItem reverseMapItem = this.reverseTableNameTokenMap.get(token.getDirName());
        if (reverseMapItem != null && this.nameTableTokenMap.remove(token.getTableName(), token)) {
            if (token.isWal()) {
                this.nameStore.logDropTable(token);
                this.reverseTableNameTokenMap.put(token.getDirName(), ReverseTableMapItem.ofDropped(token));
            } else {
                this.reverseTableNameTokenMap.remove(token.getDirName(), reverseMapItem);
            }
            return true;
        }
        return false;
    }

    @Override
    public TableToken lockTableName(String tableName, String dirName, int tableId, boolean isWal) {
        TableToken newNameRecord = new TableToken(tableName, dirName, tableId, isWal);
        TableToken registeredRecord = this.nameTableTokenMap.putIfAbsent(tableName, LOCKED_TOKEN);
        return registeredRecord == null ? newNameRecord : null;
    }

    @Override
    public void purgeToken(TableToken token) {
        this.reverseTableNameTokenMap.remove(token.getDirName());
    }

    @Override
    public void registerName(TableToken tableToken) {
        String tableName = tableToken.getTableName();
        if (!this.nameTableTokenMap.replace(tableName, LOCKED_TOKEN, tableToken)) {
            throw CairoException.critical(0).put("cannot register table, name is not locked [name=").put(tableName).put(']');
        }
        if (tableToken.isWal()) {
            this.nameStore.appendEntry(tableToken);
        }
        this.reverseTableNameTokenMap.put(tableToken.getDirName(), ReverseTableMapItem.of(tableToken));
    }

    @Override
    public synchronized void reloadTableNameCache() {
        this.nameTableTokenMap.clear();
        this.reverseTableNameTokenMap.clear();
        if (!this.nameStore.isLocked()) {
            this.nameStore.lock();
        }
        this.nameStore.reload(this.nameTableTokenMap, this.reverseTableNameTokenMap);
    }

    @Override
    public TableToken rename(CharSequence oldName, CharSequence newName, TableToken tableToken) {
        TableToken newNameRecord;
        String newTableNameStr = Chars.toString(newName);
        if (this.nameTableTokenMap.putIfAbsent(newTableNameStr, newNameRecord = new TableToken(newTableNameStr, tableToken.getDirName(), tableToken.getTableId(), tableToken.isWal())) == null) {
            if (this.nameTableTokenMap.remove(oldName, tableToken)) {
                this.nameStore.logDropTable(tableToken);
                this.nameStore.appendEntry(newNameRecord);
                this.reverseTableNameTokenMap.put(newNameRecord.getDirName(), ReverseTableMapItem.of(newNameRecord));
                return newNameRecord;
            }
            this.nameTableTokenMap.remove(newTableNameStr, newNameRecord);
            throw CairoException.tableDoesNotExist(oldName);
        }
        throw CairoException.nonCritical().put("table '").put(newName).put("' already exists");
    }

    @Override
    public void resetMemory() {
        this.nameStore.resetMemory();
    }

    @Override
    public void unlockTableName(TableToken tableToken) {
        this.nameTableTokenMap.remove(tableToken.getTableName(), LOCKED_TOKEN);
    }
}

