/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesRecordCursor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestBySubQueryRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    private final int columnIndex;
    private final Function filter;
    private final Record.CharSequenceFunction func;
    private final RecordCursorFactory recordCursorFactory;
    private final IntHashSet symbolKeys = new IntHashSet();

    public LatestBySubQueryRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @NotNull RecordCursorFactory recordCursorFactory, @Nullable Function filter, boolean indexed, @NotNull Record.CharSequenceFunction func, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory, configuration);
        this.cursor = indexed ? (filter != null ? new LatestByValuesIndexedFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, null, filter, columnIndexes) : new LatestByValuesIndexedRecordCursor(columnIndex, this.symbolKeys, null, this.rows, columnIndexes)) : (filter != null ? new LatestByValuesFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, null, filter, columnIndexes) : new LatestByValuesRecordCursor(columnIndex, this.rows, this.symbolKeys, null, columnIndexes));
        this.columnIndex = columnIndex;
        this.recordCursorFactory = recordCursorFactory;
        this.filter = filter;
        this.func = func;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("LatestBySubQuery");
        sink.child("Subquery", this.recordCursorFactory);
        sink.child((Plannable)((Object)this.cursor));
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    protected void _close() {
        super._close();
        this.recordCursorFactory.close();
        Misc.free(this.filter);
    }

    @Override
    protected AbstractDataFrameRecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.columnIndex);
        this.symbolKeys.clear();
        try (RecordCursor cursor = this.recordCursorFactory.getCursor(executionContext);){
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                int symbolKey = symbolTable.keyOf(this.func.get(record, 0));
                if (symbolKey == -2) continue;
                this.symbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }
}

