/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class Long256HashSet
implements Mutable {
    protected static final long noEntryKey = -1L;
    private static final int MIN_INITIAL_CAPACITY = 16;
    protected final double loadFactor;
    protected int capacity;
    protected int free;
    protected int mask;
    private long[] keys;

    public Long256HashSet() {
        this(16);
    }

    public Long256HashSet(Long256HashSet that) {
        this(that.capacity, that.loadFactor);
        for (long this.keys[i] : that.keys) {
        }
    }

    private Long256HashSet(int initialCapacity) {
        this(initialCapacity, 0.4);
    }

    private Long256HashSet(int initialCapacity, double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.capacity = Math.max(initialCapacity, 16);
        int len = Numbers.ceilPow2((int)((double)this.capacity / loadFactor));
        this.loadFactor = loadFactor;
        this.keys = this.alloc(len);
        this.mask = len - 1;
        this.clear();
    }

    public boolean add(long k0, long k1, long k2, long k3) {
        int index = this.keyIndex(k0, k1, k2, k3);
        if (index < 0) {
            return false;
        }
        this.addAt(index, k0, k1, k2, k3);
        return true;
    }

    public void addAt(int index, long k0, long k1, long k2, long k3) {
        this.setAt(index, k0, k1, k2, k3);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, -1L);
    }

    public long k0At(int index) {
        return this.keys[(-index - 1) * 4];
    }

    public long k1At(int index) {
        return this.keys[(-index - 1) * 4 + 1];
    }

    public long k2At(int index) {
        return this.keys[(-index - 1) * 4 + 2];
    }

    public long k3At(int index) {
        return this.keys[(-index - 1) * 4 + 3];
    }

    public int keyIndex(long k0, long k1, long k2, long k3) {
        int index = Long256HashSet.hashCode0(k0, k1, k2, k3) & this.mask;
        if (this.isSlotFree(index)) {
            return index;
        }
        if (this.isSlotMatches(index, k0, k1, k2, k3)) {
            return -index - 1;
        }
        return this.probe(k0, k1, k2, k3, index);
    }

    public int size() {
        return this.capacity - this.free;
    }

    private static int hashCode0(long k0, long k1, long k2, long k3) {
        int h = (int)k0;
        h = (int)((long)(31 * h) + k1);
        h = (int)((long)(31 * h) + k2);
        h = (int)((long)(31 * h) + k3);
        return Hash.spread(h);
    }

    private long[] alloc(int capacity) {
        return new long[capacity * 4];
    }

    private boolean isSlotFree(int index) {
        return this.keys[index * 4] == -1L && this.keys[index * 4 + 1] == -1L && this.keys[index * 4 + 2] == -1L && this.keys[index * 4 + 3] == -1L;
    }

    private boolean isSlotMatches(int index, long k0, long k1, long k2, long k3) {
        return this.keys[index * 4] == k0 && this.keys[index * 4 + 1] == k1 && this.keys[index * 4 + 2] == k2 && this.keys[index * 4 + 3] == k3;
    }

    private int probe(long k0, long k1, long k2, long k3, int index) {
        do {
            if (!this.isSlotFree(index = index + 1 & this.mask)) continue;
            return index;
        } while (!this.isSlotMatches(index, k0, k1, k2, k3));
        return -index - 1;
    }

    private void rehash() {
        int newCapacity;
        long[] old = this.keys;
        int oldSize = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        this.keys = this.alloc(len);
        this.mask = len - 1;
        Arrays.fill(this.keys, -1L);
        this.free -= oldSize;
        int n = old.length / 4;
        for (int i = 0; i < n; ++i) {
            if (old[i * 4] == -1L && old[i * 4 + 1] == -1L && old[i * 4 + 2] == -1L && old[i * 4 + 3] == -1L) continue;
            int index = this.keyIndex(old[i * 4], old[i * 4 + 1], old[i * 4 + 2], old[i * 4 + 3]);
            this.setAt(index, old[i * 4], old[i * 4 + 1], old[i * 4 + 2], old[i * 4 + 3]);
        }
    }

    private void setAt(int index, long k0, long k1, long k2, long k3) {
        this.keys[index * 4] = k0;
        this.keys[index * 4 + 1] = k1;
        this.keys[index * 4 + 2] = k2;
        this.keys[index * 4 + 3] = k3;
    }
}

