/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectFactory;
import io.questdb.std.WeakObjectPoolBase;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class WeakMutableObjectPool<T extends Mutable>
extends WeakObjectPoolBase<T>
implements Closeable {
    private final ObjectFactory<T> factory;

    public WeakMutableObjectPool(@NotNull ObjectFactory<T> factory, int initSize) {
        super(initSize);
        this.factory = factory;
        this.fill();
    }

    @Override
    public void close() {
        while (this.cache.size() > 0) {
            Misc.freeIfCloseable(this.cache.pop());
        }
    }

    @Override
    public boolean push(T obj) {
        return super.push(obj);
    }

    @Override
    void clear(T obj) {
        obj.clear();
    }

    @Override
    void close(T obj) {
        Misc.freeIfCloseable(obj);
    }

    @Override
    T newInstance() {
        return (T)((Mutable)this.factory.newInstance());
    }
}

