/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.DecimalQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.util.NumberParsing;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;

public class WholeNumberCastEvaluator
extends WholeNumberEvaluator {
    private final Evaluator<?> subjectEvaluator;

    public WholeNumberCastEvaluator(Evaluator<?> subjectEvaluator) {
        if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.BOOLEAN) {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + String.valueOf(subjectEvaluator.getResultType()) + " to " + String.valueOf(AttributeExpression.ResultType.WHOLE_NUMBER));
        }
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(EvaluationContext evaluationContext) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(evaluationContext);
        if (result.getValue() == null) {
            return new WholeNumberQueryResult(null);
        }
        switch (result.getResultType()) {
            case WHOLE_NUMBER: {
                return (WholeNumberQueryResult)result;
            }
            case STRING: {
                String trimmed = ((StringQueryResult)result).getValue().trim();
                NumberParsing.ParseResultType parseType = NumberParsing.parse(trimmed);
                switch (parseType) {
                    case DECIMAL: {
                        Double doubleResultValue = Double.valueOf(trimmed);
                        return new WholeNumberQueryResult(doubleResultValue.longValue());
                    }
                    case WHOLE_NUMBER: {
                        Long longResultValue;
                        try {
                            longResultValue = Long.valueOf(trimmed);
                        }
                        catch (NumberFormatException e) {
                            longResultValue = Long.decode(trimmed);
                        }
                        return new WholeNumberQueryResult(longResultValue);
                    }
                }
                return new WholeNumberQueryResult(null);
            }
            case DATE: {
                return new WholeNumberQueryResult(((DateQueryResult)result).getValue().getTime());
            }
            case INSTANT: {
                return new WholeNumberQueryResult(((InstantQueryResult)result).getValue().toEpochMilli());
            }
            case DECIMAL: {
                Double resultValue = ((DecimalQueryResult)result).getValue();
                return new WholeNumberQueryResult(resultValue.longValue());
            }
            case NUMBER: {
                Number numberValue = ((NumberQueryResult)result).getValue();
                return new WholeNumberQueryResult(numberValue.longValue());
            }
        }
        return new WholeNumberQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

