/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.FlowClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.PGChangeVersion;
import org.apache.nifi.toolkit.cli.impl.command.nifi.pg.PGList;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ChangeVersionResult;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ProcessGroupsResult;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ProcessGroupsVersionChangeResult;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;

public class PGChangeAllVersions
extends AbstractNiFiCommand<ProcessGroupsVersionChangeResult> {
    public PGChangeAllVersions() {
        super("pg-change-all-versions", ProcessGroupsVersionChangeResult.class);
    }

    @Override
    public String getDescription() {
        return "Changes the version for all of the controlled process group instances for a given flow ID. This can be used to upgrade all the instances of a versioned flow to a new version, or revert to a previous version. If no version is specified, the latest version will be used. If no process group ID is provided, the root process group will be used to recursively search for all instances of the Flow ID. It is possible to force the recursive operation and not stop the operation in case the upgrade of a process group fails.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.FLOW_ID.createOption());
        this.addOption(CommandOption.FLOW_VERSION.createOption());
        this.addOption(CommandOption.PG_ID.createOption());
        this.addOption(CommandOption.FORCE.createOption());
    }

    @Override
    public ProcessGroupsVersionChangeResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        FlowClient flowClient = client.getFlowClient();
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        String parentPgId = this.getArg(properties, CommandOption.PG_ID);
        if (StringUtils.isBlank((CharSequence)parentPgId)) {
            parentPgId = flowClient.getRootGroupId();
        }
        PGList doPGList = new PGList();
        ArrayList<ProcessGroupDTO> pgList = new ArrayList<ProcessGroupDTO>();
        this.recursivePGList(pgList, doPGList, client, properties, parentPgId);
        PGChangeVersion doPGChangeVersion = new PGChangeVersion();
        String newVersion = this.getArg(properties, CommandOption.FLOW_VERSION);
        boolean forceOperation = properties.containsKey(CommandOption.FORCE.getLongName());
        ArrayList<ProcessGroupDTO> processGroups = new ArrayList<ProcessGroupDTO>();
        HashMap<String, ChangeVersionResult> changeVersionResults = new HashMap<String, ChangeVersionResult>();
        for (ProcessGroupDTO pgDTO : pgList) {
            VersionControlInformationEntity entity = client.getVersionsClient().getVersionControlInfo(pgDTO.getId());
            if (entity.getVersionControlInformation() == null || !entity.getVersionControlInformation().getFlowId().equals(flowId)) continue;
            if (newVersion == null) {
                newVersion = doPGChangeVersion.getLatestVersion(client, entity.getVersionControlInformation());
            }
            processGroups.add(pgDTO);
            String previousVersion = pgDTO.getVersionControlInformation().getVersion();
            if (previousVersion.equals(newVersion)) {
                changeVersionResults.put(pgDTO.getId(), new ChangeVersionResult(newVersion, newVersion, "Process group already at desired version"));
                continue;
            }
            try {
                doPGChangeVersion.changeVersion(client, entity, newVersion, pgDTO.getId(), this.getContext());
                changeVersionResults.put(pgDTO.getId(), new ChangeVersionResult(previousVersion, newVersion, "SUCCESS"));
            }
            catch (Exception e) {
                changeVersionResults.put(pgDTO.getId(), new ChangeVersionResult(previousVersion, null, e.getMessage()));
                if (forceOperation) continue;
                e.printStackTrace();
                break;
            }
        }
        return new ProcessGroupsVersionChangeResult(this.getResultType(properties), processGroups, changeVersionResults);
    }

    private void recursivePGList(List<ProcessGroupDTO> pgList, PGList doPGList, NiFiClient client, Properties properties, String pgId) throws NiFiClientException, IOException {
        ProcessGroupsResult result = doPGList.getList(client, properties, pgId);
        Iterator iterator = result.getResult().iterator();
        while (iterator.hasNext()) {
            ProcessGroupDTO pgDTO = (ProcessGroupDTO)iterator.next();
            pgList.add(pgDTO);
            this.recursivePGList(pgList, doPGList, client, properties, pgDTO.getId());
        }
    }
}

