/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCopier
extends IteratingNestedCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ContentCopier.class);
    private final Content.Source source;
    private final Content.Sink sink;
    private final Content.Chunk.Processor chunkProcessor;
    private Content.Chunk current;
    private boolean terminated;

    public ContentCopier(Content.Source source, Content.Sink sink, Content.Chunk.Processor chunkProcessor, Callback callback) {
        super(callback);
        this.source = source;
        this.sink = sink;
        this.chunkProcessor = chunkProcessor;
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    protected IteratingCallback.Action process() throws Throwable {
        if (this.current != null) {
            this.current.release();
        }
        if (this.terminated) {
            return IteratingCallback.Action.SUCCEEDED;
        }
        this.current = this.source.read();
        if (this.current == null) {
            this.source.demand(() -> ((ContentCopier)this).succeeded());
            return IteratingCallback.Action.SCHEDULED;
        }
        if (this.chunkProcessor != null && this.chunkProcessor.process(this.current, (Callback)this)) {
            return IteratingCallback.Action.SCHEDULED;
        }
        this.terminated = this.current.isLast();
        if (Content.Chunk.isFailure(this.current)) {
            this.failed(this.current.getFailure());
            return IteratingCallback.Action.SCHEDULED;
        }
        this.sink.write(this.current.isLast(), this.current.getByteBuffer(), (Callback)this);
        return IteratingCallback.Action.SCHEDULED;
    }

    protected void onCompleteFailure(Throwable x) {
        if (this.current != null) {
            this.current.release();
            this.current = Content.Chunk.next(this.current);
        }
        ExceptionUtil.callAndThen((Throwable)x, this.source::fail, x$0 -> super.onCompleteFailure(x$0));
    }
}

