/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.FlowAnalysisRuleResult;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;

public class DeleteFlowAnalysisRule
extends AbstractNiFiCommand<FlowAnalysisRuleResult> {
    public DeleteFlowAnalysisRule() {
        super("delete-flow-analysis-rule", FlowAnalysisRuleResult.class);
    }

    @Override
    public String getDescription() {
        return "Delete a flow analysis rule.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.FAR_ID.createOption());
    }

    @Override
    public FlowAnalysisRuleResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String flowAnalysisRuleId = this.getRequiredArg(properties, CommandOption.FAR_ID);
        ControllerClient controllerClient = client.getControllerClient();
        FlowAnalysisRuleEntity flowAnalysisRule = controllerClient.getFlowAnalysisRule(flowAnalysisRuleId);
        FlowAnalysisRuleEntity deletedFlowAnalysisRuleEntity = controllerClient.deleteFlowAnalysisRule(flowAnalysisRule);
        return new FlowAnalysisRuleResult(this.getResultType(properties), deletedFlowAnalysisRuleEntity);
    }
}

