/****************************************************************************
 * arch/risc-v/src/esp32c3/hardware/esp32c3_interrupt.h
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_ESP32C3_HARDWARE_ESP32C3_INTERRUPT_H
#define __ARCH_RISCV_SRC_ESP32C3_HARDWARE_ESP32C3_INTERRUPT_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include "hardware/esp32c3_soc.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define INTERRUPT_MAC_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x000)

/* INTERRUPT_MAC_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_MAC_INTR_MAP  0x0000001f
#define INTERRUPT_MAC_INTR_MAP_M  ((INTERRUPT_MAC_INTR_MAP_V) << (INTERRUPT_MAC_INTR_MAP_S))
#define INTERRUPT_MAC_INTR_MAP_V  0x1f
#define INTERRUPT_MAC_INTR_MAP_S  0

#define INTERRUPT_MAC_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x004)

/* INTERRUPT_MAC_NMI_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_MAC_NMI_MAP  0x0000001f
#define INTERRUPT_MAC_NMI_MAP_M  ((INTERRUPT_MAC_NMI_MAP_V) << (INTERRUPT_MAC_NMI_MAP_S))
#define INTERRUPT_MAC_NMI_MAP_V  0x1f
#define INTERRUPT_MAC_NMI_MAP_S  0

#define INTERRUPT_PWR_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x008)

/* INTERRUPT_PWR_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_PWR_INTR_MAP  0x0000001f
#define INTERRUPT_PWR_INTR_MAP_M  ((INTERRUPT_PWR_INTR_MAP_V) << (INTERRUPT_PWR_INTR_MAP_S))
#define INTERRUPT_PWR_INTR_MAP_V  0x1f
#define INTERRUPT_PWR_INTR_MAP_S  0

#define INTERRUPT_BB_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x00c)

/* INTERRUPT_BB_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_BB_INT_MAP  0x0000001f
#define INTERRUPT_BB_INT_MAP_M  ((INTERRUPT_BB_INT_MAP_V) << (INTERRUPT_BB_INT_MAP_S))
#define INTERRUPT_BB_INT_MAP_V  0x1f
#define INTERRUPT_BB_INT_MAP_S  0

#define INTERRUPT_BT_MAC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x010)

/* INTERRUPT_BT_MAC_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_BT_MAC_INT_MAP  0x0000001f
#define INTERRUPT_BT_MAC_INT_MAP_M  ((INTERRUPT_BT_MAC_INT_MAP_V) << (INTERRUPT_BT_MAC_INT_MAP_S))
#define INTERRUPT_BT_MAC_INT_MAP_V  0x1f
#define INTERRUPT_BT_MAC_INT_MAP_S  0

#define INTERRUPT_BT_BB_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x014)

/* INTERRUPT_BT_BB_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_BT_BB_INT_MAP  0x0000001f
#define INTERRUPT_BT_BB_INT_MAP_M  ((INTERRUPT_BT_BB_INT_MAP_V) << (INTERRUPT_BT_BB_INT_MAP_S))
#define INTERRUPT_BT_BB_INT_MAP_V  0x1f
#define INTERRUPT_BT_BB_INT_MAP_S  0

#define INTERRUPT_BT_BB_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x018)

/* INTERRUPT_BT_BB_NMI_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_BT_BB_NMI_MAP  0x0000001f
#define INTERRUPT_BT_BB_NMI_MAP_M  ((INTERRUPT_BT_BB_NMI_MAP_V) << (INTERRUPT_BT_BB_NMI_MAP_S))
#define INTERRUPT_BT_BB_NMI_MAP_V  0x1f
#define INTERRUPT_BT_BB_NMI_MAP_S  0

#define INTERRUPT_RWBT_IRQ_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x01c)

/* INTERRUPT_RWBT_IRQ_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RWBT_IRQ_MAP  0x0000001f
#define INTERRUPT_RWBT_IRQ_MAP_M  ((INTERRUPT_RWBT_IRQ_MAP_V) << (INTERRUPT_RWBT_IRQ_MAP_S))
#define INTERRUPT_RWBT_IRQ_MAP_V  0x1f
#define INTERRUPT_RWBT_IRQ_MAP_S  0

#define INTERRUPT_RWBLE_IRQ_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x020)

/* INTERRUPT_RWBLE_IRQ_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RWBLE_IRQ_MAP  0x0000001f
#define INTERRUPT_RWBLE_IRQ_MAP_M  ((INTERRUPT_RWBLE_IRQ_MAP_V) << (INTERRUPT_RWBLE_IRQ_MAP_S))
#define INTERRUPT_RWBLE_IRQ_MAP_V  0x1f
#define INTERRUPT_RWBLE_IRQ_MAP_S  0

#define INTERRUPT_RWBT_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x024)

/* INTERRUPT_RWBT_NMI_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RWBT_NMI_MAP  0x0000001f
#define INTERRUPT_RWBT_NMI_MAP_M  ((INTERRUPT_RWBT_NMI_MAP_V) << (INTERRUPT_RWBT_NMI_MAP_S))
#define INTERRUPT_RWBT_NMI_MAP_V  0x1f
#define INTERRUPT_RWBT_NMI_MAP_S  0

#define INTERRUPT_RWBLE_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x028)

/* INTERRUPT_RWBLE_NMI_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RWBLE_NMI_MAP  0x0000001f
#define INTERRUPT_RWBLE_NMI_MAP_M  ((INTERRUPT_RWBLE_NMI_MAP_V) << (INTERRUPT_RWBLE_NMI_MAP_S))
#define INTERRUPT_RWBLE_NMI_MAP_V  0x1f
#define INTERRUPT_RWBLE_NMI_MAP_S  0

#define INTERRUPT_I2C_MST_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x02c)

/* INTERRUPT_I2C_MST_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_I2C_MST_INT_MAP  0x0000001f
#define INTERRUPT_I2C_MST_INT_MAP_M  ((INTERRUPT_I2C_MST_INT_MAP_V) << (INTERRUPT_I2C_MST_INT_MAP_S))
#define INTERRUPT_I2C_MST_INT_MAP_V  0x1f
#define INTERRUPT_I2C_MST_INT_MAP_S  0

#define INTERRUPT_SLC0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x030)

/* INTERRUPT_SLC0_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SLC0_INTR_MAP  0x0000001f
#define INTERRUPT_SLC0_INTR_MAP_M  ((INTERRUPT_SLC0_INTR_MAP_V) << (INTERRUPT_SLC0_INTR_MAP_S))
#define INTERRUPT_SLC0_INTR_MAP_V  0x1f
#define INTERRUPT_SLC0_INTR_MAP_S  0

#define INTERRUPT_SLC1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x034)

/* INTERRUPT_SLC1_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SLC1_INTR_MAP  0x0000001f
#define INTERRUPT_SLC1_INTR_MAP_M  ((INTERRUPT_SLC1_INTR_MAP_V) << (INTERRUPT_SLC1_INTR_MAP_S))
#define INTERRUPT_SLC1_INTR_MAP_V  0x1f
#define INTERRUPT_SLC1_INTR_MAP_S  0

#define INTERRUPT_APB_CTRL_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x038)

/* INTERRUPT_APB_CTRL_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_APB_CTRL_INTR_MAP  0x0000001f
#define INTERRUPT_APB_CTRL_INTR_MAP_M  ((INTERRUPT_APB_CTRL_INTR_MAP_V) << (INTERRUPT_APB_CTRL_INTR_MAP_S))
#define INTERRUPT_APB_CTRL_INTR_MAP_V  0x1f
#define INTERRUPT_APB_CTRL_INTR_MAP_S  0

#define INTERRUPT_UHCI0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x03c)

/* INTERRUPT_UHCI0_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_UHCI0_INTR_MAP  0x0000001f
#define INTERRUPT_UHCI0_INTR_MAP_M  ((INTERRUPT_UHCI0_INTR_MAP_V) << (INTERRUPT_UHCI0_INTR_MAP_S))
#define INTERRUPT_UHCI0_INTR_MAP_V  0x1f
#define INTERRUPT_UHCI0_INTR_MAP_S  0

#define INTERRUPT_GPIO_INTERRUPT_PRO_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x040)

/* INTERRUPT_GPIO_INTERRUPT_PRO_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_GPIO_INTERRUPT_PRO_MAP  0x0000001f
#define INTERRUPT_GPIO_INTERRUPT_PRO_MAP_M  ((INTERRUPT_GPIO_INTERRUPT_PRO_MAP_V) << (INTERRUPT_GPIO_INTERRUPT_PRO_MAP_S))
#define INTERRUPT_GPIO_INTERRUPT_PRO_MAP_V  0x1f
#define INTERRUPT_GPIO_INTERRUPT_PRO_MAP_S  0

#define INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x044)

/* INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP : R/W [4:0] 5'd0 ; */

#define INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP  0x0000001f
#define INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP_M  ((INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP_V) << (INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP_S))
#define INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP_V  0x1f
#define INTERRUPT_GPIO_INTERRUPT_PRO_NMI_MAP_S  0

#define INTERRUPT_SPI_INTR_1_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x048)

/* INTERRUPT_SPI_INTR_1_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SPI_INTR_1_MAP  0x0000001f
#define INTERRUPT_SPI_INTR_1_MAP_M  ((INTERRUPT_SPI_INTR_1_MAP_V) << (INTERRUPT_SPI_INTR_1_MAP_S))
#define INTERRUPT_SPI_INTR_1_MAP_V  0x1f
#define INTERRUPT_SPI_INTR_1_MAP_S  0

#define INTERRUPT_SPI_INTR_2_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x04c)

/* INTERRUPT_SPI_INTR_2_MAP : R/W [4:0] : 5'd0 ; */
#define INTERRUPT_SPI_INTR_2_MAP  0x0000001f
#define INTERRUPT_SPI_INTR_2_MAP_M  ((INTERRUPT_SPI_INTR_2_MAP_V) << (INTERRUPT_SPI_INTR_2_MAP_S))
#define INTERRUPT_SPI_INTR_2_MAP_V  0x1f
#define INTERRUPT_SPI_INTR_2_MAP_S  0

#define INTERRUPT_I2S1_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x050)

/* INTERRUPT_I2S1_INT_MAP : R/W [4:0] : 5'd0 ; */
#define INTERRUPT_I2S1_INT_MAP  0x0000001f
#define INTERRUPT_I2S1_INT_MAP_M  ((INTERRUPT_I2S1_INT_MAP_V) << (INTERRUPT_I2S1_INT_MAP_S))
#define INTERRUPT_I2S1_INT_MAP_V  0x1f
#define INTERRUPT_I2S1_INT_MAP_S  0

#define INTERRUPT_UART_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x054)

/* INTERRUPT_UART_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_UART_INTR_MAP  0x0000001f
#define INTERRUPT_UART_INTR_MAP_M  ((INTERRUPT_UART_INTR_MAP_V) << (INTERRUPT_UART_INTR_MAP_S))
#define INTERRUPT_UART_INTR_MAP_V  0x1f
#define INTERRUPT_UART_INTR_MAP_S  0

#define INTERRUPT_UART1_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x058)

/* INTERRUPT_UART1_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_UART1_INTR_MAP  0x0000001f
#define INTERRUPT_UART1_INTR_MAP_M  ((INTERRUPT_UART1_INTR_MAP_V) << (INTERRUPT_UART1_INTR_MAP_S))
#define INTERRUPT_UART1_INTR_MAP_V  0x1f
#define INTERRUPT_UART1_INTR_MAP_S  0

#define INTERRUPT_LEDC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x05c)

/* INTERRUPT_LEDC_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_LEDC_INT_MAP  0x0000001f
#define INTERRUPT_LEDC_INT_MAP_M  ((INTERRUPT_LEDC_INT_MAP_V) << (INTERRUPT_LEDC_INT_MAP_S))
#define INTERRUPT_LEDC_INT_MAP_V  0x1f
#define INTERRUPT_LEDC_INT_MAP_S  0

#define INTERRUPT_EFUSE_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x060)

/* INTERRUPT_EFUSE_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_EFUSE_INT_MAP  0x0000001f
#define INTERRUPT_EFUSE_INT_MAP_M  ((INTERRUPT_EFUSE_INT_MAP_V) << (INTERRUPT_EFUSE_INT_MAP_S))
#define INTERRUPT_EFUSE_INT_MAP_V  0x1f
#define INTERRUPT_EFUSE_INT_MAP_S  0

#define INTERRUPT_CAN_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x064)

/* INTERRUPT_CAN_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CAN_INT_MAP  0x0000001f
#define INTERRUPT_CAN_INT_MAP_M  ((INTERRUPT_CAN_INT_MAP_V) << (INTERRUPT_CAN_INT_MAP_S))
#define INTERRUPT_CAN_INT_MAP_V  0x1f
#define INTERRUPT_CAN_INT_MAP_S  0

#define INTERRUPT_USB_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x068)

/* INTERRUPT_USB_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_USB_INTR_MAP  0x0000001f
#define INTERRUPT_USB_INTR_MAP_M  ((INTERRUPT_USB_INTR_MAP_V) << (INTERRUPT_USB_INTR_MAP_S))
#define INTERRUPT_USB_INTR_MAP_V  0x1f
#define INTERRUPT_USB_INTR_MAP_S  0

#define INTERRUPT_RTC_CORE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x06c)

/* INTERRUPT_RTC_CORE_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RTC_CORE_INTR_MAP  0x0000001f
#define INTERRUPT_RTC_CORE_INTR_MAP_M  ((INTERRUPT_RTC_CORE_INTR_MAP_V) << (INTERRUPT_RTC_CORE_INTR_MAP_S))
#define INTERRUPT_RTC_CORE_INTR_MAP_V  0x1f
#define INTERRUPT_RTC_CORE_INTR_MAP_S  0

#define INTERRUPT_RMT_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x070)

/* INTERRUPT_RMT_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RMT_INTR_MAP  0x0000001f
#define INTERRUPT_RMT_INTR_MAP_M  ((INTERRUPT_RMT_INTR_MAP_V) << (INTERRUPT_RMT_INTR_MAP_S))
#define INTERRUPT_RMT_INTR_MAP_V  0x1f
#define INTERRUPT_RMT_INTR_MAP_S  0

#define INTERRUPT_I2C_EXT0_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x074)

/* INTERRUPT_I2C_EXT0_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_I2C_EXT0_INTR_MAP  0x0000001f
#define INTERRUPT_I2C_EXT0_INTR_MAP_M  ((INTERRUPT_I2C_EXT0_INTR_MAP_V) << (INTERRUPT_I2C_EXT0_INTR_MAP_S))
#define INTERRUPT_I2C_EXT0_INTR_MAP_V  0x1f
#define INTERRUPT_I2C_EXT0_INTR_MAP_S  0

#define INTERRUPT_TIMER_INT1_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x078)

/* INTERRUPT_TIMER_INT1_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_TIMER_INT1_MAP  0x0000001f
#define INTERRUPT_TIMER_INT1_MAP_M  ((INTERRUPT_TIMER_INT1_MAP_V) << (INTERRUPT_TIMER_INT1_MAP_S))
#define INTERRUPT_TIMER_INT1_MAP_V  0x1f
#define INTERRUPT_TIMER_INT1_MAP_S  0

#define INTERRUPT_TIMER_INT2_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x07c)

/* INTERRUPT_TIMER_INT2_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_TIMER_INT2_MAP  0x0000001f
#define INTERRUPT_TIMER_INT2_MAP_M  ((INTERRUPT_TIMER_INT2_MAP_V) << (INTERRUPT_TIMER_INT2_MAP_S))
#define INTERRUPT_TIMER_INT2_MAP_V  0x1f
#define INTERRUPT_TIMER_INT2_MAP_S  0

#define INTERRUPT_TG_T0_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x080)

/* INTERRUPT_TG_T0_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_TG_T0_INT_MAP  0x0000001f
#define INTERRUPT_TG_T0_INT_MAP_M  ((INTERRUPT_TG_T0_INT_MAP_V) << (INTERRUPT_TG_T0_INT_MAP_S))
#define INTERRUPT_TG_T0_INT_MAP_V  0x1f
#define INTERRUPT_TG_T0_INT_MAP_S  0

#define INTERRUPT_TG_WDT_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x084)

/* INTERRUPT_TG_WDT_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_TG_WDT_INT_MAP  0x0000001f
#define INTERRUPT_TG_WDT_INT_MAP_M  ((INTERRUPT_TG_WDT_INT_MAP_V) << (INTERRUPT_TG_WDT_INT_MAP_S))
#define INTERRUPT_TG_WDT_INT_MAP_V  0x1f
#define INTERRUPT_TG_WDT_INT_MAP_S  0

#define INTERRUPT_TG1_T0_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x088)

/* INTERRUPT_TG1_T0_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_TG1_T0_INT_MAP  0x0000001f
#define INTERRUPT_TG1_T0_INT_MAP_M  ((INTERRUPT_TG1_T0_INT_MAP_V) << (INTERRUPT_TG1_T0_INT_MAP_S))
#define INTERRUPT_TG1_T0_INT_MAP_V  0x1f
#define INTERRUPT_TG1_T0_INT_MAP_S  0

#define INTERRUPT_TG1_WDT_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x08c)

/* INTERRUPT_TG1_WDT_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_TG1_WDT_INT_MAP  0x0000001f
#define INTERRUPT_TG1_WDT_INT_MAP_M  ((INTERRUPT_TG1_WDT_INT_MAP_V) << (INTERRUPT_TG1_WDT_INT_MAP_S))
#define INTERRUPT_TG1_WDT_INT_MAP_V  0x1f
#define INTERRUPT_TG1_WDT_INT_MAP_S  0

#define INTERRUPT_CACHE_IA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x090)

/* INTERRUPT_CACHE_IA_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CACHE_IA_INT_MAP  0x0000001f
#define INTERRUPT_CACHE_IA_INT_MAP_M  ((INTERRUPT_CACHE_IA_INT_MAP_V) << (INTERRUPT_CACHE_IA_INT_MAP_S))
#define INTERRUPT_CACHE_IA_INT_MAP_V  0x1f
#define INTERRUPT_CACHE_IA_INT_MAP_S  0

#define INTERRUPT_SYSTIMER_TARGET0_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x094)

/* INTERRUPT_SYSTIMER_TARGET0_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SYSTIMER_TARGET0_INT_MAP  0x0000001f
#define INTERRUPT_SYSTIMER_TARGET0_INT_MAP_M  ((INTERRUPT_SYSTIMER_TARGET0_INT_MAP_V) << (INTERRUPT_SYSTIMER_TARGET0_INT_MAP_S))
#define INTERRUPT_SYSTIMER_TARGET0_INT_MAP_V  0x1f
#define INTERRUPT_SYSTIMER_TARGET0_INT_MAP_S  0

#define INTERRUPT_SYSTIMER_TARGET1_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x098)

/* INTERRUPT_SYSTIMER_TARGET1_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SYSTIMER_TARGET1_INT_MAP  0x0000001f
#define INTERRUPT_SYSTIMER_TARGET1_INT_MAP_M  ((INTERRUPT_SYSTIMER_TARGET1_INT_MAP_V) << (INTERRUPT_SYSTIMER_TARGET1_INT_MAP_S))
#define INTERRUPT_SYSTIMER_TARGET1_INT_MAP_V  0x1f
#define INTERRUPT_SYSTIMER_TARGET1_INT_MAP_S  0

#define INTERRUPT_SYSTIMER_TARGET2_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x09c)

/* INTERRUPT_SYSTIMER_TARGET2_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SYSTIMER_TARGET2_INT_MAP  0x0000001f
#define INTERRUPT_SYSTIMER_TARGET2_INT_MAP_M  ((INTERRUPT_SYSTIMER_TARGET2_INT_MAP_V) << (INTERRUPT_SYSTIMER_TARGET2_INT_MAP_S))
#define INTERRUPT_SYSTIMER_TARGET2_INT_MAP_V  0x1f
#define INTERRUPT_SYSTIMER_TARGET2_INT_MAP_S  0

#define INTERRUPT_SPI_MEM_REJECT_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0a0)

/* INTERRUPT_SPI_MEM_REJECT_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SPI_MEM_REJECT_INTR_MAP  0x0000001f
#define INTERRUPT_SPI_MEM_REJECT_INTR_MAP_M  ((INTERRUPT_SPI_MEM_REJECT_INTR_MAP_V) << (INTERRUPT_SPI_MEM_REJECT_INTR_MAP_S))
#define INTERRUPT_SPI_MEM_REJECT_INTR_MAP_V  0x1f
#define INTERRUPT_SPI_MEM_REJECT_INTR_MAP_S  0

#define INTERRUPT_ICACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0a4)

/* INTERRUPT_ICACHE_PRELOAD_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_ICACHE_PRELOAD_INT_MAP  0x0000001f
#define INTERRUPT_ICACHE_PRELOAD_INT_MAP_M  ((INTERRUPT_ICACHE_PRELOAD_INT_MAP_V) << (INTERRUPT_ICACHE_PRELOAD_INT_MAP_S))
#define INTERRUPT_ICACHE_PRELOAD_INT_MAP_V  0x1f
#define INTERRUPT_ICACHE_PRELOAD_INT_MAP_S  0

#define INTERRUPT_ICACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0a8)

/* INTERRUPT_ICACHE_SYNC_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_ICACHE_SYNC_INT_MAP  0x0000001f
#define INTERRUPT_ICACHE_SYNC_INT_MAP_M  ((INTERRUPT_ICACHE_SYNC_INT_MAP_V) << (INTERRUPT_ICACHE_SYNC_INT_MAP_S))
#define INTERRUPT_ICACHE_SYNC_INT_MAP_V  0x1f
#define INTERRUPT_ICACHE_SYNC_INT_MAP_S  0

#define INTERRUPT_APB_ADC_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0ac)

/* INTERRUPT_APB_ADC_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_APB_ADC_INT_MAP  0x0000001f
#define INTERRUPT_APB_ADC_INT_MAP_M  ((INTERRUPT_APB_ADC_INT_MAP_V) << (INTERRUPT_APB_ADC_INT_MAP_S))
#define INTERRUPT_APB_ADC_INT_MAP_V  0x1f
#define INTERRUPT_APB_ADC_INT_MAP_S  0

#define INTERRUPT_DMA_CH0_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0b0)

/* INTERRUPT_DMA_CH0_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_DMA_CH0_INT_MAP  0x0000001f
#define INTERRUPT_DMA_CH0_INT_MAP_M  ((INTERRUPT_DMA_CH0_INT_MAP_V) << (INTERRUPT_DMA_CH0_INT_MAP_S))
#define INTERRUPT_DMA_CH0_INT_MAP_V  0x1f
#define INTERRUPT_DMA_CH0_INT_MAP_S  0

#define INTERRUPT_DMA_CH1_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0b4)

/* INTERRUPT_DMA_CH1_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_DMA_CH1_INT_MAP  0x0000001f
#define INTERRUPT_DMA_CH1_INT_MAP_M  ((INTERRUPT_DMA_CH1_INT_MAP_V) << (INTERRUPT_DMA_CH1_INT_MAP_S))
#define INTERRUPT_DMA_CH1_INT_MAP_V  0x1f
#define INTERRUPT_DMA_CH1_INT_MAP_S  0

#define INTERRUPT_DMA_CH2_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0b8)

/* INTERRUPT_DMA_CH2_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_DMA_CH2_INT_MAP  0x0000001f
#define INTERRUPT_DMA_CH2_INT_MAP_M  ((INTERRUPT_DMA_CH2_INT_MAP_V) << (INTERRUPT_DMA_CH2_INT_MAP_S))
#define INTERRUPT_DMA_CH2_INT_MAP_V  0x1f
#define INTERRUPT_DMA_CH2_INT_MAP_S  0

#define INTERRUPT_RSA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0bc)

/* INTERRUPT_RSA_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_RSA_INT_MAP  0x0000001f
#define INTERRUPT_RSA_INT_MAP_M  ((INTERRUPT_RSA_INT_MAP_V) << (INTERRUPT_RSA_INT_MAP_S))
#define INTERRUPT_RSA_INT_MAP_V  0x1f
#define INTERRUPT_RSA_INT_MAP_S  0

#define INTERRUPT_AES_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0c0)

/* INTERRUPT_AES_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_AES_INT_MAP  0x0000001f
#define INTERRUPT_AES_INT_MAP_M  ((INTERRUPT_AES_INT_MAP_V) << (INTERRUPT_AES_INT_MAP_S))
#define INTERRUPT_AES_INT_MAP_V  0x1f
#define INTERRUPT_AES_INT_MAP_S  0

#define INTERRUPT_SHA_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0c4)

/* INTERRUPT_SHA_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_SHA_INT_MAP  0x0000001f
#define INTERRUPT_SHA_INT_MAP_M  ((INTERRUPT_SHA_INT_MAP_V) << (INTERRUPT_SHA_INT_MAP_S))
#define INTERRUPT_SHA_INT_MAP_V  0x1f
#define INTERRUPT_SHA_INT_MAP_S  0

#define INTERRUPT_CPU_INTR_FROM_CPU_0_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0c8)

/* INTERRUPT_CPU_INTR_FROM_CPU_0_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CPU_INTR_FROM_CPU_0_MAP  0x0000001f
#define INTERRUPT_CPU_INTR_FROM_CPU_0_MAP_M  ((INTERRUPT_CPU_INTR_FROM_CPU_0_MAP_V) << (INTERRUPT_CPU_INTR_FROM_CPU_0_MAP_S))
#define INTERRUPT_CPU_INTR_FROM_CPU_0_MAP_V  0x1f
#define INTERRUPT_CPU_INTR_FROM_CPU_0_MAP_S  0

#define INTERRUPT_CPU_INTR_FROM_CPU_1_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0cc)

/* INTERRUPT_CPU_INTR_FROM_CPU_1_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CPU_INTR_FROM_CPU_1_MAP  0x0000001f
#define INTERRUPT_CPU_INTR_FROM_CPU_1_MAP_M  ((INTERRUPT_CPU_INTR_FROM_CPU_1_MAP_V) << (INTERRUPT_CPU_INTR_FROM_CPU_1_MAP_S))
#define INTERRUPT_CPU_INTR_FROM_CPU_1_MAP_V  0x1f
#define INTERRUPT_CPU_INTR_FROM_CPU_1_MAP_S  0

#define INTERRUPT_CPU_INTR_FROM_CPU_2_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0d0)

/* INTERRUPT_CPU_INTR_FROM_CPU_2_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CPU_INTR_FROM_CPU_2_MAP  0x0000001f
#define INTERRUPT_CPU_INTR_FROM_CPU_2_MAP_M  ((INTERRUPT_CPU_INTR_FROM_CPU_2_MAP_V) << (INTERRUPT_CPU_INTR_FROM_CPU_2_MAP_S))
#define INTERRUPT_CPU_INTR_FROM_CPU_2_MAP_V  0x1f
#define INTERRUPT_CPU_INTR_FROM_CPU_2_MAP_S  0

#define INTERRUPT_CPU_INTR_FROM_CPU_3_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0d4)

/* INTERRUPT_CPU_INTR_FROM_CPU_3_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CPU_INTR_FROM_CPU_3_MAP  0x0000001f
#define INTERRUPT_CPU_INTR_FROM_CPU_3_MAP_M  ((INTERRUPT_CPU_INTR_FROM_CPU_3_MAP_V) << (INTERRUPT_CPU_INTR_FROM_CPU_3_MAP_S))
#define INTERRUPT_CPU_INTR_FROM_CPU_3_MAP_V  0x1f
#define INTERRUPT_CPU_INTR_FROM_CPU_3_MAP_S  0

#define INTERRUPT_ASSIST_DEBUG_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0d8)

/* INTERRUPT_ASSIST_DEBUG_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_ASSIST_DEBUG_INTR_MAP  0x0000001f
#define INTERRUPT_ASSIST_DEBUG_INTR_MAP_M  ((INTERRUPT_ASSIST_DEBUG_INTR_MAP_V) << (INTERRUPT_ASSIST_DEBUG_INTR_MAP_S))
#define INTERRUPT_ASSIST_DEBUG_INTR_MAP_V  0x1f
#define INTERRUPT_ASSIST_DEBUG_INTR_MAP_S  0

#define INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0dc)

/* INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001f
#define INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_V) << (INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1f
#define INTERRUPT_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0e0)

/* INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001f
#define INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V) << (INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1f
#define INTERRUPT_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0e4)

/* INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001f
#define INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V) << (INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1f
#define INTERRUPT_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0e8)

/* INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001f
#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V) << (INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1f
#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0ec)

/* INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP :
 * R/W [4:0] : 5'd0
 */

#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP  0x0000001f
#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_M  ((INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V) << (INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S))
#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V  0x1f
#define INTERRUPT_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S  0

#define INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0f0)

/* INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP  0x0000001f
#define INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP_M  ((INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP_V) << (INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP_S))
#define INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP_V  0x1f
#define INTERRUPT_BACKUP_PMS_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CACHE_CORE0_ACS_INT_MAP_REG          (DR_REG_INTERRUPT_BASE + 0x0f4)

/* INTERRUPT_CACHE_CORE0_ACS_INT_MAP : R/W [4:0] : 5'd0 ; */

#define INTERRUPT_CACHE_CORE0_ACS_INT_MAP  0x0000001f
#define INTERRUPT_CACHE_CORE0_ACS_INT_MAP_M  ((INTERRUPT_CACHE_CORE0_ACS_INT_MAP_V) << (INTERRUPT_CACHE_CORE0_ACS_INT_MAP_S))
#define INTERRUPT_CACHE_CORE0_ACS_INT_MAP_V  0x1f
#define INTERRUPT_CACHE_CORE0_ACS_INT_MAP_S  0

#define INTERRUPT_INTR_STATUS_0_REG          (DR_REG_INTERRUPT_BASE + 0x0f8)

/* INTERRUPT_INTR_STATUS_0 : RO [31:0] : 32'h0 ; */

#define INTERRUPT_INTR_STATUS_0  0xffffffff
#define INTERRUPT_INTR_STATUS_0_M  ((INTERRUPT_INTR_STATUS_0_V) << (INTERRUPT_INTR_STATUS_0_S))
#define INTERRUPT_INTR_STATUS_0_V  0xffffffff
#define INTERRUPT_INTR_STATUS_0_S  0

#define INTERRUPT_INTR_STATUS_1_REG          (DR_REG_INTERRUPT_BASE + 0x0fc)

/* INTERRUPT_INTR_STATUS_1 : RO [31:0] : 32'h0 ; */

#define INTERRUPT_INTR_STATUS_1  0xffffffff
#define INTERRUPT_INTR_STATUS_1_M  ((INTERRUPT_INTR_STATUS_1_V) << (INTERRUPT_INTR_STATUS_1_S))
#define INTERRUPT_INTR_STATUS_1_V  0xffffffff
#define INTERRUPT_INTR_STATUS_1_S  0

#define INTERRUPT_CLOCK_GATE_REG          (DR_REG_INTERRUPT_BASE + 0x100)

/* INTERRUPT_CLK_EN : R/W [0] : 1'b1 ; */

#define INTERRUPT_CLK_EN  (BIT(0))
#define INTERRUPT_CLK_EN_M  (BIT(0))
#define INTERRUPT_CLK_EN_V  0x1
#define INTERRUPT_CLK_EN_S  0

#define INTERRUPT_CPU_INT_ENABLE_REG          (DR_REG_INTERRUPT_BASE + 0x104)

/* INTERRUPT_CPU_INT_ENABLE : R/W [31:0] : 32'b0 ; */

#define INTERRUPT_CPU_INT_ENABLE  0xffffffff
#define INTERRUPT_CPU_INT_ENABLE_M  ((INTERRUPT_CPU_INT_ENABLE_V) << (INTERRUPT_CPU_INT_ENABLE_S))
#define INTERRUPT_CPU_INT_ENABLE_V  0xffffffff
#define INTERRUPT_CPU_INT_ENABLE_S  0

#define INTERRUPT_CPU_INT_TYPE_REG          (DR_REG_INTERRUPT_BASE + 0x108)

/* INTERRUPT_CPU_INT_TYPE : R/W [31:0] : 32'b0 ; */

#define INTERRUPT_CPU_INT_TYPE  0xffffffff
#define INTERRUPT_CPU_INT_TYPE_M  ((INTERRUPT_CPU_INT_TYPE_V) << (INTERRUPT_CPU_INT_TYPE_S))
#define INTERRUPT_CPU_INT_TYPE_V  0xffffffff
#define INTERRUPT_CPU_INT_TYPE_S  0

#define INTERRUPT_CPU_INT_CLEAR_REG          (DR_REG_INTERRUPT_BASE + 0x10c)

/* INTERRUPT_CPU_INT_CLEAR : R/W [31:0] : 32'b0 ; */

#define INTERRUPT_CPU_INT_CLEAR  0xffffffff
#define INTERRUPT_CPU_INT_CLEAR_M  ((INTERRUPT_CPU_INT_CLEAR_V) << (INTERRUPT_CPU_INT_CLEAR_S))
#define INTERRUPT_CPU_INT_CLEAR_V  0xffffffff
#define INTERRUPT_CPU_INT_CLEAR_S  0

#define INTERRUPT_CPU_INT_EIP_STATUS_REG          (DR_REG_INTERRUPT_BASE + 0x110)

/* INTERRUPT_CPU_INT_EIP_STATUS : RO [31:0] : 32'b0 ; */

#define INTERRUPT_CPU_INT_EIP_STATUS  0xffffffff
#define INTERRUPT_CPU_INT_EIP_STATUS_M  ((INTERRUPT_CPU_INT_EIP_STATUS_V) << (INTERRUPT_CPU_INT_EIP_STATUS_S))
#define INTERRUPT_CPU_INT_EIP_STATUS_V  0xffffffff
#define INTERRUPT_CPU_INT_EIP_STATUS_S  0

#define INTERRUPT_CPU_INT_PRI_0_REG          (DR_REG_INTERRUPT_BASE + 0x114)

/* INTERRUPT_CPU_PRI_0_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_0_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_0_MAP_M  ((INTERRUPT_CPU_PRI_0_MAP_V) << (INTERRUPT_CPU_PRI_0_MAP_S))
#define INTERRUPT_CPU_PRI_0_MAP_V  0xf
#define INTERRUPT_CPU_PRI_0_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_1_REG          (DR_REG_INTERRUPT_BASE + 0x118)

/* INTERRUPT_CPU_PRI_1_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_1_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_1_MAP_M  ((INTERRUPT_CPU_PRI_1_MAP_V) << (INTERRUPT_CPU_PRI_1_MAP_S))
#define INTERRUPT_CPU_PRI_1_MAP_V  0xf
#define INTERRUPT_CPU_PRI_1_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_2_REG          (DR_REG_INTERRUPT_BASE + 0x11c)

/* INTERRUPT_CPU_PRI_2_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_2_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_2_MAP_M  ((INTERRUPT_CPU_PRI_2_MAP_V) << (INTERRUPT_CPU_PRI_2_MAP_S))
#define INTERRUPT_CPU_PRI_2_MAP_V  0xf
#define INTERRUPT_CPU_PRI_2_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_3_REG          (DR_REG_INTERRUPT_BASE + 0x120)

/* INTERRUPT_CPU_PRI_3_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_3_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_3_MAP_M  ((INTERRUPT_CPU_PRI_3_MAP_V) << (INTERRUPT_CPU_PRI_3_MAP_S))
#define INTERRUPT_CPU_PRI_3_MAP_V  0xf
#define INTERRUPT_CPU_PRI_3_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_4_REG          (DR_REG_INTERRUPT_BASE + 0x124)

/* INTERRUPT_CPU_PRI_4_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_4_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_4_MAP_M  ((INTERRUPT_CPU_PRI_4_MAP_V) << (INTERRUPT_CPU_PRI_4_MAP_S))
#define INTERRUPT_CPU_PRI_4_MAP_V  0xf
#define INTERRUPT_CPU_PRI_4_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_5_REG          (DR_REG_INTERRUPT_BASE + 0x128)

/* INTERRUPT_CPU_PRI_5_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_5_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_5_MAP_M  ((INTERRUPT_CPU_PRI_5_MAP_V) << (INTERRUPT_CPU_PRI_5_MAP_S))
#define INTERRUPT_CPU_PRI_5_MAP_V  0xf
#define INTERRUPT_CPU_PRI_5_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_6_REG          (DR_REG_INTERRUPT_BASE + 0x12c)

/* INTERRUPT_CPU_PRI_6_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_6_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_6_MAP_M  ((INTERRUPT_CPU_PRI_6_MAP_V) << (INTERRUPT_CPU_PRI_6_MAP_S))
#define INTERRUPT_CPU_PRI_6_MAP_V  0xf
#define INTERRUPT_CPU_PRI_6_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_7_REG          (DR_REG_INTERRUPT_BASE + 0x130)

/* INTERRUPT_CPU_PRI_7_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_7_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_7_MAP_M  ((INTERRUPT_CPU_PRI_7_MAP_V) << (INTERRUPT_CPU_PRI_7_MAP_S))
#define INTERRUPT_CPU_PRI_7_MAP_V  0xf
#define INTERRUPT_CPU_PRI_7_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_8_REG          (DR_REG_INTERRUPT_BASE + 0x134)

/* INTERRUPT_CPU_PRI_8_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_8_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_8_MAP_M  ((INTERRUPT_CPU_PRI_8_MAP_V) << (INTERRUPT_CPU_PRI_8_MAP_S))
#define INTERRUPT_CPU_PRI_8_MAP_V  0xf
#define INTERRUPT_CPU_PRI_8_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_9_REG          (DR_REG_INTERRUPT_BASE + 0x138)

/* INTERRUPT_CPU_PRI_9_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_9_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_9_MAP_M  ((INTERRUPT_CPU_PRI_9_MAP_V) << (INTERRUPT_CPU_PRI_9_MAP_S))
#define INTERRUPT_CPU_PRI_9_MAP_V  0xf
#define INTERRUPT_CPU_PRI_9_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_10_REG          (DR_REG_INTERRUPT_BASE + 0x13c)

/* INTERRUPT_CPU_PRI_10_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_10_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_10_MAP_M  ((INTERRUPT_CPU_PRI_10_MAP_V) << (INTERRUPT_CPU_PRI_10_MAP_S))
#define INTERRUPT_CPU_PRI_10_MAP_V  0xf
#define INTERRUPT_CPU_PRI_10_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_11_REG          (DR_REG_INTERRUPT_BASE + 0x140)

/* INTERRUPT_CPU_PRI_11_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_11_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_11_MAP_M  ((INTERRUPT_CPU_PRI_11_MAP_V) << (INTERRUPT_CPU_PRI_11_MAP_S))
#define INTERRUPT_CPU_PRI_11_MAP_V  0xf
#define INTERRUPT_CPU_PRI_11_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_12_REG          (DR_REG_INTERRUPT_BASE + 0x144)

/* INTERRUPT_CPU_PRI_12_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_12_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_12_MAP_M  ((INTERRUPT_CPU_PRI_12_MAP_V) << (INTERRUPT_CPU_PRI_12_MAP_S))
#define INTERRUPT_CPU_PRI_12_MAP_V  0xf
#define INTERRUPT_CPU_PRI_12_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_13_REG          (DR_REG_INTERRUPT_BASE + 0x148)

/* INTERRUPT_CPU_PRI_13_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_13_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_13_MAP_M  ((INTERRUPT_CPU_PRI_13_MAP_V) << (INTERRUPT_CPU_PRI_13_MAP_S))
#define INTERRUPT_CPU_PRI_13_MAP_V  0xf
#define INTERRUPT_CPU_PRI_13_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_14_REG          (DR_REG_INTERRUPT_BASE + 0x14c)

/* INTERRUPT_CPU_PRI_14_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_14_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_14_MAP_M  ((INTERRUPT_CPU_PRI_14_MAP_V) << (INTERRUPT_CPU_PRI_14_MAP_S))
#define INTERRUPT_CPU_PRI_14_MAP_V  0xf
#define INTERRUPT_CPU_PRI_14_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_15_REG          (DR_REG_INTERRUPT_BASE + 0x150)

/* INTERRUPT_CPU_PRI_15_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_15_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_15_MAP_M  ((INTERRUPT_CPU_PRI_15_MAP_V) << (INTERRUPT_CPU_PRI_15_MAP_S))
#define INTERRUPT_CPU_PRI_15_MAP_V  0xf
#define INTERRUPT_CPU_PRI_15_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_16_REG          (DR_REG_INTERRUPT_BASE + 0x154)

/* INTERRUPT_CPU_PRI_16_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_16_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_16_MAP_M  ((INTERRUPT_CPU_PRI_16_MAP_V) << (INTERRUPT_CPU_PRI_16_MAP_S))
#define INTERRUPT_CPU_PRI_16_MAP_V  0xf
#define INTERRUPT_CPU_PRI_16_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_17_REG          (DR_REG_INTERRUPT_BASE + 0x158)

/* INTERRUPT_CPU_PRI_17_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_17_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_17_MAP_M  ((INTERRUPT_CPU_PRI_17_MAP_V) << (INTERRUPT_CPU_PRI_17_MAP_S))
#define INTERRUPT_CPU_PRI_17_MAP_V  0xf
#define INTERRUPT_CPU_PRI_17_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_18_REG          (DR_REG_INTERRUPT_BASE + 0x15c)

/* INTERRUPT_CPU_PRI_18_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_18_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_18_MAP_M  ((INTERRUPT_CPU_PRI_18_MAP_V) << (INTERRUPT_CPU_PRI_18_MAP_S))
#define INTERRUPT_CPU_PRI_18_MAP_V  0xf
#define INTERRUPT_CPU_PRI_18_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_19_REG          (DR_REG_INTERRUPT_BASE + 0x160)

/* INTERRUPT_CPU_PRI_19_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_19_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_19_MAP_M  ((INTERRUPT_CPU_PRI_19_MAP_V) << (INTERRUPT_CPU_PRI_19_MAP_S))
#define INTERRUPT_CPU_PRI_19_MAP_V  0xf
#define INTERRUPT_CPU_PRI_19_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_20_REG          (DR_REG_INTERRUPT_BASE + 0x164)

/* INTERRUPT_CPU_PRI_20_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_20_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_20_MAP_M  ((INTERRUPT_CPU_PRI_20_MAP_V) << (INTERRUPT_CPU_PRI_20_MAP_S))
#define INTERRUPT_CPU_PRI_20_MAP_V  0xf
#define INTERRUPT_CPU_PRI_20_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_21_REG          (DR_REG_INTERRUPT_BASE + 0x168)

/* INTERRUPT_CPU_PRI_21_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_21_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_21_MAP_M  ((INTERRUPT_CPU_PRI_21_MAP_V) << (INTERRUPT_CPU_PRI_21_MAP_S))
#define INTERRUPT_CPU_PRI_21_MAP_V  0xf
#define INTERRUPT_CPU_PRI_21_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_22_REG          (DR_REG_INTERRUPT_BASE + 0x16c)

/* INTERRUPT_CPU_PRI_22_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_22_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_22_MAP_M  ((INTERRUPT_CPU_PRI_22_MAP_V) << (INTERRUPT_CPU_PRI_22_MAP_S))
#define INTERRUPT_CPU_PRI_22_MAP_V  0xf
#define INTERRUPT_CPU_PRI_22_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_23_REG          (DR_REG_INTERRUPT_BASE + 0x170)

/* INTERRUPT_CPU_PRI_23_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_23_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_23_MAP_M  ((INTERRUPT_CPU_PRI_23_MAP_V) << (INTERRUPT_CPU_PRI_23_MAP_S))
#define INTERRUPT_CPU_PRI_23_MAP_V  0xf
#define INTERRUPT_CPU_PRI_23_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_24_REG          (DR_REG_INTERRUPT_BASE + 0x174)

/* INTERRUPT_CPU_PRI_24_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_24_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_24_MAP_M  ((INTERRUPT_CPU_PRI_24_MAP_V) << (INTERRUPT_CPU_PRI_24_MAP_S))
#define INTERRUPT_CPU_PRI_24_MAP_V  0xf
#define INTERRUPT_CPU_PRI_24_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_25_REG          (DR_REG_INTERRUPT_BASE + 0x178)

/* INTERRUPT_CPU_PRI_25_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_25_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_25_MAP_M  ((INTERRUPT_CPU_PRI_25_MAP_V) << (INTERRUPT_CPU_PRI_25_MAP_S))
#define INTERRUPT_CPU_PRI_25_MAP_V  0xf
#define INTERRUPT_CPU_PRI_25_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_26_REG          (DR_REG_INTERRUPT_BASE + 0x17c)

/* INTERRUPT_CPU_PRI_26_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_26_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_26_MAP_M  ((INTERRUPT_CPU_PRI_26_MAP_V) << (INTERRUPT_CPU_PRI_26_MAP_S))
#define INTERRUPT_CPU_PRI_26_MAP_V  0xf
#define INTERRUPT_CPU_PRI_26_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_27_REG          (DR_REG_INTERRUPT_BASE + 0x180)

/* INTERRUPT_CPU_PRI_27_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_27_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_27_MAP_M  ((INTERRUPT_CPU_PRI_27_MAP_V) << (INTERRUPT_CPU_PRI_27_MAP_S))
#define INTERRUPT_CPU_PRI_27_MAP_V  0xf
#define INTERRUPT_CPU_PRI_27_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_28_REG          (DR_REG_INTERRUPT_BASE + 0x184)

/* INTERRUPT_CPU_PRI_28_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_28_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_28_MAP_M  ((INTERRUPT_CPU_PRI_28_MAP_V) << (INTERRUPT_CPU_PRI_28_MAP_S))
#define INTERRUPT_CPU_PRI_28_MAP_V  0xf
#define INTERRUPT_CPU_PRI_28_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_29_REG          (DR_REG_INTERRUPT_BASE + 0x188)

/* INTERRUPT_CPU_PRI_29_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_29_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_29_MAP_M  ((INTERRUPT_CPU_PRI_29_MAP_V) << (INTERRUPT_CPU_PRI_29_MAP_S))
#define INTERRUPT_CPU_PRI_29_MAP_V  0xf
#define INTERRUPT_CPU_PRI_29_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_30_REG          (DR_REG_INTERRUPT_BASE + 0x18c)

/* INTERRUPT_CPU_PRI_30_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_30_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_30_MAP_M  ((INTERRUPT_CPU_PRI_30_MAP_V) << (INTERRUPT_CPU_PRI_30_MAP_S))
#define INTERRUPT_CPU_PRI_30_MAP_V  0xf
#define INTERRUPT_CPU_PRI_30_MAP_S  0

#define INTERRUPT_CPU_INT_PRI_31_REG          (DR_REG_INTERRUPT_BASE + 0x190)

/* INTERRUPT_CPU_PRI_31_MAP : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_PRI_31_MAP  0x0000000f
#define INTERRUPT_CPU_PRI_31_MAP_M  ((INTERRUPT_CPU_PRI_31_MAP_V) << (INTERRUPT_CPU_PRI_31_MAP_S))
#define INTERRUPT_CPU_PRI_31_MAP_V  0xf
#define INTERRUPT_CPU_PRI_31_MAP_S  0
#define INTC_INT_PRIO_REG(n)                        (INTERRUPT_CPU_INT_PRI_0_REG + (n)*4)

#define INTERRUPT_CPU_INT_THRESH_REG          (DR_REG_INTERRUPT_BASE + 0x194)

/* INTERRUPT_CPU_INT_THRESH : R/W [3:0] : 4'b0 ; */

#define INTERRUPT_CPU_INT_THRESH  0x0000000f
#define INTERRUPT_CPU_INT_THRESH_M  ((INTERRUPT_CPU_INT_THRESH_V) << (INTERRUPT_CPU_INT_THRESH_S))
#define INTERRUPT_CPU_INT_THRESH_V  0xf
#define INTERRUPT_CPU_INT_THRESH_S  0

#define INTERRUPT_INTERRUPT_DATE_REG          (DR_REG_INTERRUPT_BASE + 0x7fc)

/* INTERRUPT_INTERRUPT_DATE : R/W [27:0] : 28'h2007210 ; */

#define INTERRUPT_INTERRUPT_DATE  0x0fffffff
#define INTERRUPT_INTERRUPT_DATE_M  ((INTERRUPT_INTERRUPT_DATE_V) << (INTERRUPT_INTERRUPT_DATE_S))
#define INTERRUPT_INTERRUPT_DATE_V  0xfffffff
#define INTERRUPT_INTERRUPT_DATE_S  0

#endif /* __ARCH_RISCV_SRC_ESP32C3_HARDWARE_ESP32C3_INTERRUPT_H */
