/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorEvaluationMonitor;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SentenceDetectorEvaluatorTool
extends AbstractEvaluatorTool<SentenceSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(SentenceDetectorEvaluatorTool.class);

    public SentenceDetectorEvaluatorTool() {
        super(SentenceSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the learnable sentence detector";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        SentenceModel model = (SentenceModel)new SentenceModelLoader().load(((EvalToolParams)this.params).getModel());
        SentenceEvaluationErrorListener errorListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            errorListener = new SentenceEvaluationErrorListener();
        }
        SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator((SentenceDetector)new SentenceDetectorME(model), new SentenceDetectorEvaluationMonitor[]{errorListener});
        logger.info("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        logger.info(evaluator.getFMeasure().toString());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

