/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.topiclistlimit;

import io.netty.buffer.ByteBufUtil;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongGauge;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiter;
import org.apache.pulsar.common.semaphore.AsyncDualMemoryLimiterImpl;
import org.apache.pulsar.common.semaphore.AsyncSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicListMemoryLimiter
extends AsyncDualMemoryLimiterImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicListMemoryLimiter.class);
    private final CollectorRegistry collectorRegistry;
    private final Gauge heapMemoryUsedBytes;
    private final Gauge heapMemoryLimitBytes;
    private final Gauge directMemoryUsedBytes;
    private final Gauge directMemoryLimitBytes;
    private final Gauge heapQueueSize;
    private final Gauge heapQueueMaxSize;
    private final Gauge directQueueSize;
    private final Gauge directQueueMaxSize;
    private final Summary heapWaitTimeMs;
    private final Summary directWaitTimeMs;
    private final Counter heapTimeoutTotal;
    private final Counter directTimeoutTotal;
    private final ObservableDoubleGauge otelHeapMemoryUsedGauge;
    private final DoubleGauge otelHeapMemoryLimitGauge;
    private final ObservableDoubleGauge otelDirectMemoryUsedGauge;
    private final DoubleGauge otelDirectMemoryLimitGauge;
    private final ObservableLongUpDownCounter otelHeapQueueSize;
    private final ObservableLongUpDownCounter otelDirectQueueSize;
    private final DoubleHistogram otelHeapWaitTime;
    private final DoubleHistogram otelDirectWaitTime;
    private final LongCounter otelHeapTimeoutTotal;
    private final LongCounter otelDirectTimeoutTotal;

    public TopicListMemoryLimiter(CollectorRegistry collectorRegistry, String prometheusPrefix, Meter openTelemetryMeter, long maxHeapMemory, int maxHeapQueueSize, long heapTimeoutMillis, long maxDirectMemory, int maxDirectQueueSize, long directTimeoutMillis) {
        super(maxHeapMemory, maxHeapQueueSize, heapTimeoutMillis, maxDirectMemory, maxDirectQueueSize, directTimeoutMillis);
        this.collectorRegistry = collectorRegistry;
        final AsyncSemaphore heapMemoryLimiter = this.getLimiter(AsyncDualMemoryLimiter.LimitType.HEAP_MEMORY);
        final AsyncSemaphore directMemoryLimiter = this.getLimiter(AsyncDualMemoryLimiter.LimitType.DIRECT_MEMORY);
        this.heapMemoryUsedBytes = this.register((Gauge)Gauge.build((String)(prometheusPrefix + "topic_list_heap_memory_used_bytes"), (String)"Current heap memory used by topic listings").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return heapMemoryLimiter.getAcquiredPermits();
            }
        }, new String[0]));
        this.otelHeapMemoryUsedGauge = openTelemetryMeter.gaugeBuilder("topic.list.heap.memory.used").setUnit("By").setDescription("Current heap memory used by topic listings").buildWithCallback(observableDoubleMeasurement -> observableDoubleMeasurement.record((double)heapMemoryLimiter.getAcquiredPermits()));
        this.heapMemoryLimitBytes = this.register(Gauge.build((String)(prometheusPrefix + "topic_list_heap_memory_limit_bytes"), (String)"Configured heap memory limit").create());
        this.heapMemoryLimitBytes.set((double)maxHeapMemory);
        this.otelHeapMemoryLimitGauge = openTelemetryMeter.gaugeBuilder("topic.list.heap.memory.limit").setUnit("By").setDescription("Configured heap memory limit").build();
        this.otelHeapMemoryLimitGauge.set((double)maxHeapMemory);
        this.directMemoryUsedBytes = this.register((Gauge)Gauge.build((String)(prometheusPrefix + "topic_list_direct_memory_used_bytes"), (String)"Current direct memory used by topic listings").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return directMemoryLimiter.getAcquiredPermits();
            }
        }, new String[0]));
        this.otelDirectMemoryUsedGauge = openTelemetryMeter.gaugeBuilder("topic.list.direct.memory.used").setUnit("By").setDescription("Current direct memory used by topic listings").buildWithCallback(observableDoubleMeasurement -> observableDoubleMeasurement.record((double)directMemoryLimiter.getAcquiredPermits()));
        this.directMemoryLimitBytes = this.register(Gauge.build((String)(prometheusPrefix + "topic_list_direct_memory_limit_bytes"), (String)"Configured direct memory limit").create());
        this.directMemoryLimitBytes.set((double)maxDirectMemory);
        this.otelDirectMemoryLimitGauge = openTelemetryMeter.gaugeBuilder("topic.list.direct.memory.limit").setUnit("By").setDescription("Configured direct memory limit").build();
        this.otelDirectMemoryLimitGauge.set((double)maxDirectMemory);
        this.heapQueueSize = this.register((Gauge)Gauge.build((String)(prometheusPrefix + "topic_list_heap_queue_size"), (String)"Current heap memory limiter queue size").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return heapMemoryLimiter.getQueueSize();
            }
        }, new String[0]));
        this.otelHeapQueueSize = openTelemetryMeter.upDownCounterBuilder("topic.list.heap.queue.size").setDescription("Current heap memory limiter queue size").setUnit("1").buildWithCallback(observableLongMeasurement -> observableLongMeasurement.record((long)heapMemoryLimiter.getQueueSize()));
        this.heapQueueMaxSize = this.register(Gauge.build((String)(prometheusPrefix + "topic_list_heap_queue_max_size"), (String)"Maximum heap memory limiter queue size").create());
        this.heapQueueMaxSize.set((double)maxHeapQueueSize);
        LongGauge otelHeapQueueMaxSize = openTelemetryMeter.gaugeBuilder("topic.list.heap.queue.max.size").setDescription("Maximum heap memory limiter queue size").setUnit("1").ofLongs().build();
        otelHeapQueueMaxSize.set((long)maxHeapQueueSize);
        this.directQueueSize = this.register((Gauge)Gauge.build((String)(prometheusPrefix + "topic_list_direct_queue_size"), (String)"Current direct memory limiter queue size").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return directMemoryLimiter.getQueueSize();
            }
        }, new String[0]));
        this.otelDirectQueueSize = openTelemetryMeter.upDownCounterBuilder("topic.list.direct.queue.size").setDescription("Current direct memory limiter queue size").setUnit("1").buildWithCallback(observableLongMeasurement -> observableLongMeasurement.record((long)directMemoryLimiter.getQueueSize()));
        this.directQueueMaxSize = this.register(Gauge.build((String)(prometheusPrefix + "topic_list_direct_queue_max_size"), (String)"Maximum direct memory limiter queue size").create());
        this.directQueueMaxSize.set((double)maxDirectQueueSize);
        LongGauge otelDirectQueueMaxSize = openTelemetryMeter.gaugeBuilder("topic.list.direct.queue.max.size").setDescription("Maximum direct memory limiter queue size").setUnit("1").ofLongs().build();
        otelDirectQueueMaxSize.set((long)maxDirectQueueSize);
        this.heapWaitTimeMs = this.register(Summary.build((String)(prometheusPrefix + "topic_list_heap_wait_time_ms"), (String)"Wait time for heap memory permits").quantile(0.5, 0.01).quantile(0.95, 0.01).quantile(0.99, 0.01).quantile(1.0, 0.01).create());
        this.otelHeapWaitTime = openTelemetryMeter.histogramBuilder("topic.list.heap.wait.time").setUnit("s").setDescription("Wait time for heap memory permits").build();
        this.directWaitTimeMs = this.register(Summary.build((String)(prometheusPrefix + "topic_list_direct_wait_time_ms"), (String)"Wait time for direct memory permits").quantile(0.5, 0.01).quantile(0.95, 0.01).quantile(0.99, 0.01).quantile(1.0, 0.01).create());
        this.otelDirectWaitTime = openTelemetryMeter.histogramBuilder("topic.list.direct.wait.time").setUnit("s").setDescription("Wait time for direct memory permits").build();
        this.heapTimeoutTotal = this.register(Counter.build((String)(prometheusPrefix + "topic_list_heap_timeout_total"), (String)"Total heap memory permit timeouts").create());
        this.otelHeapTimeoutTotal = openTelemetryMeter.counterBuilder("topic.list.heap.timeout.total").setDescription("Total heap memory permit timeouts").setUnit("1").build();
        this.directTimeoutTotal = this.register(Counter.build((String)(prometheusPrefix + "topic_list_direct_timeout_total"), (String)"Total direct memory permit timeouts").create());
        this.otelDirectTimeoutTotal = openTelemetryMeter.counterBuilder("topic.list.direct.timeout.total").setDescription("Total direct memory permit timeouts").setUnit("1").build();
    }

    private <T extends Collector> T register(T collector) {
        block2: {
            try {
                this.collectorRegistry.register(collector);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to register Prometheus collector {}", collector, (Object)e);
            }
        }
        return collector;
    }

    private void unregister(Collector collector) {
        block2: {
            try {
                this.collectorRegistry.unregister(collector);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to unregister Prometheus collector {}", (Object)collector, (Object)e);
            }
        }
    }

    protected void recordHeapWaitTime(long waitTimeNanos) {
        if (waitTimeNanos == Long.MAX_VALUE) {
            this.heapTimeoutTotal.inc();
            this.otelHeapTimeoutTotal.add(1L);
        } else {
            this.heapWaitTimeMs.observe((double)TimeUnit.NANOSECONDS.toMillis(waitTimeNanos));
            this.otelHeapWaitTime.record((double)waitTimeNanos / 1.0E9);
        }
    }

    protected void recordDirectWaitTime(long waitTimeNanos) {
        if (waitTimeNanos == Long.MAX_VALUE) {
            this.directTimeoutTotal.inc();
            this.otelDirectTimeoutTotal.add(1L);
        } else {
            this.directWaitTimeMs.observe((double)TimeUnit.NANOSECONDS.toMillis(waitTimeNanos));
            this.otelDirectWaitTime.record((double)waitTimeNanos / 1.0E9);
        }
    }

    public void close() {
        super.close();
        this.unregister((Collector)this.heapMemoryUsedBytes);
        this.unregister((Collector)this.heapMemoryLimitBytes);
        this.unregister((Collector)this.directMemoryUsedBytes);
        this.unregister((Collector)this.directMemoryLimitBytes);
        this.unregister((Collector)this.heapQueueSize);
        this.unregister((Collector)this.heapQueueMaxSize);
        this.unregister((Collector)this.directQueueSize);
        this.unregister((Collector)this.directQueueMaxSize);
        this.unregister((Collector)this.heapWaitTimeMs);
        this.unregister((Collector)this.directWaitTimeMs);
        this.unregister((Collector)this.heapTimeoutTotal);
        this.unregister((Collector)this.directTimeoutTotal);
        this.otelHeapMemoryUsedGauge.close();
        this.otelDirectMemoryUsedGauge.close();
        this.otelHeapQueueSize.close();
        this.otelDirectQueueSize.close();
    }

    public static long estimateTopicListSize(List<String> topicList) {
        return topicList.stream().mapToLong(ByteBufUtil::utf8Bytes).map(n -> n + 32L).sum();
    }
}

