/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.transaction.coordinator.proto.LightProtoCodec;
import org.apache.pulsar.transaction.coordinator.proto.TransactionMetadataEntry;

public final class BatchedTransactionMetadataEntry {
    private List<TransactionMetadataEntry> transactionLogs = null;
    private int _transactionLogsCount = 0;
    private static final int _TRANSACTION_LOGS_FIELD_NUMBER = 1;
    private static final int _TRANSACTION_LOGS_TAG = 10;
    private static final int _TRANSACTION_LOGS_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 0;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public int getTransactionLogsCount() {
        return this._transactionLogsCount;
    }

    public TransactionMetadataEntry getTransactionLogAt(int idx) {
        if (idx < 0 || idx >= this._transactionLogsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._transactionLogsCount + ") for field 'transaction_logs'");
        }
        return this.transactionLogs.get(idx);
    }

    public List<TransactionMetadataEntry> getTransactionLogsList() {
        if (this._transactionLogsCount == 0) {
            return Collections.emptyList();
        }
        return this.transactionLogs.subList(0, this._transactionLogsCount);
    }

    public TransactionMetadataEntry addTransactionLog() {
        if (this.transactionLogs == null) {
            this.transactionLogs = new ArrayList<TransactionMetadataEntry>();
        }
        if (this.transactionLogs.size() == this._transactionLogsCount) {
            this.transactionLogs.add(new TransactionMetadataEntry());
        }
        this._cachedSize = -1;
        return this.transactionLogs.get(this._transactionLogsCount++);
    }

    public BatchedTransactionMetadataEntry addAllTransactionLogs(Iterable<TransactionMetadataEntry> transactionLogs) {
        for (TransactionMetadataEntry _o : transactionLogs) {
            this.addTransactionLog().copyFrom(_o);
        }
        return this;
    }

    public BatchedTransactionMetadataEntry clearTransactionLogs() {
        for (int i = 0; i < this._transactionLogsCount; ++i) {
            this.transactionLogs.get(i).clear();
        }
        this._transactionLogsCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        int _writeIdx = _b.writerIndex();
        for (int i = 0; i < this._transactionLogsCount; ++i) {
            TransactionMetadataEntry _item = this.transactionLogs.get(i);
            LightProtoCodec.writeVarInt(_b, 10);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        for (int i = 0; i < this._transactionLogsCount; ++i) {
            TransactionMetadataEntry _item = this.transactionLogs.get(i);
            _size += _TRANSACTION_LOGS_TAG_SIZE;
            int MsgsizeTransactionLogs = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeTransactionLogs) + MsgsizeTransactionLogs;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block3: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    int _transactionLogsSize = LightProtoCodec.readVarInt(_buffer);
                    this.addTransactionLog().parseFrom(_buffer, _transactionLogsSize);
                    continue block3;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this._parsedBuffer = _buffer;
    }

    public BatchedTransactionMetadataEntry clear() {
        for (int i = 0; i < this._transactionLogsCount; ++i) {
            this.transactionLogs.get(i).clear();
        }
        this._transactionLogsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public BatchedTransactionMetadataEntry copyFrom(BatchedTransactionMetadataEntry _other) {
        this._cachedSize = -1;
        for (int i = 0; i < _other.getTransactionLogsCount(); ++i) {
            this.addTransactionLog().copyFrom(_other.getTransactionLogAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

