/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpEventSink;
import org.apache.qpid.jms.provider.amqp.AmqpExceptionBuilder;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.exceptions.ProviderOperationTimedOutException;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpResourceBuilder<TARGET extends AmqpResource, PARENT extends AmqpResourceParent, INFO extends JmsResource, ENDPOINT extends Endpoint>
implements AmqpEventSink,
AmqpExceptionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpResourceBuilder.class);
    protected AsyncResult request;
    protected ScheduledFuture<?> requestTimeoutTask;
    protected TARGET resource;
    protected ENDPOINT endpoint;
    protected final PARENT parent;
    protected final INFO resourceInfo;
    protected final AmqpProvider provider;

    public AmqpResourceBuilder(PARENT parent, INFO resourceInfo) {
        this.parent = parent;
        this.resourceInfo = resourceInfo;
        this.provider = parent.getProvider();
    }

    public void buildResource(final AsyncResult request) {
        this.request = request;
        this.provider.addToFailOnConnectionDropTracking(request);
        this.endpoint = this.createEndpoint(this.resourceInfo);
        this.endpoint.setContext((Object)this);
        this.endpoint.open();
        this.resource = this.createResource(this.parent, this.resourceInfo, this.endpoint);
        if (this.getRequestTimeout() > -1L) {
            this.requestTimeoutTask = this.provider.scheduleRequestTimeout(new AsyncResult(){
                final /* synthetic */ AmqpResourceBuilder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onSuccess() {
                }

                @Override
                public void onFailure(ProviderException result) {
                    this.this$0.handleClosed(this.this$0.provider, result);
                }

                @Override
                public boolean isComplete() {
                    return request.isComplete();
                }
            }, this.getRequestTimeout(), this);
        }
        if (this.endpoint.getRemoteState() != EndpointState.UNINITIALIZED) {
            this.provider.scheduleExecuteAndPump(new Runnable(){

                @Override
                public void run() {
                    AmqpResourceBuilder.this.handleOpened(AmqpResourceBuilder.this.provider);
                }
            });
        }
    }

    @Override
    public void processRemoteOpen(AmqpProvider provider) throws ProviderException {
        this.handleOpened(provider);
    }

    @Override
    public void processRemoteClose(AmqpProvider provider) throws ProviderException {
        this.handleClosed(provider, null);
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) throws ProviderException {
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws ProviderException {
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws ProviderException {
    }

    protected final void handleOpened(AmqpProvider provider) {
        provider.removeFromFailOnConnectionDropTracking(this.request);
        this.afterOpened();
        if (this.isClosePending()) {
            return;
        }
        if (this.requestTimeoutTask != null) {
            this.requestTimeoutTask.cancel(false);
        }
        if (this.isOpenedEndpointValid()) {
            this.resourceInfo.setState(JmsResource.ResourceState.OPEN);
            this.getEndpoint().setContext(this.resource);
            this.getParent().addChildResource((AmqpResource)this.resource);
            this.getRequest().onSuccess();
        } else {
            this.handleClosed(provider, new ProviderException("Failed to open requested endpoint"));
        }
    }

    protected final void handleClosed(AmqpProvider provider, ProviderException cause) {
        provider.removeFromFailOnConnectionDropTracking(this.request);
        this.resourceInfo.setState(JmsResource.ResourceState.REMOTELY_CLOSED);
        this.afterClosed(this.getResource(), this.getResourceInfo());
        ProviderException openError = this.hasRemoteError() ? this.getOpenAbortExceptionFromRemote() : (cause != null ? cause : this.getDefaultOpenAbortException());
        if (this.requestTimeoutTask != null) {
            this.requestTimeoutTask.cancel(false);
        }
        LOG.warn("Open of resource:({}) failed: {}", this.resourceInfo, (Object)openError.getMessage());
        this.getEndpoint().close();
        this.getEndpoint().free();
        this.getEndpoint().setContext(null);
        this.getRequest().onFailure(openError);
    }

    @Override
    public ProviderException createException() {
        return new ProviderOperationTimedOutException("Request to open resource " + String.valueOf(this.getResource()) + " timed out");
    }

    protected abstract ENDPOINT createEndpoint(INFO var1);

    protected abstract TARGET createResource(PARENT var1, INFO var2, ENDPOINT var3);

    protected abstract boolean isClosePending();

    protected boolean isOpenedEndpointValid() {
        return true;
    }

    protected void afterOpened() {
    }

    protected void afterClosed(TARGET resource, INFO resourceInfo) {
    }

    protected boolean hasRemoteError() {
        return this.getEndpoint().getRemoteCondition().getCondition() != null;
    }

    protected ProviderException getDefaultOpenAbortException() {
        return new ProviderException("Open failed unexpectedly.");
    }

    protected ProviderException getOpenAbortExceptionFromRemote() {
        return AmqpSupport.convertToNonFatalException(this.parent.getProvider(), this.getEndpoint(), this.getEndpoint().getRemoteCondition());
    }

    protected long getRequestTimeout() {
        return this.getParent().getProvider().getRequestTimeout();
    }

    public ENDPOINT getEndpoint() {
        return this.endpoint;
    }

    public AsyncResult getRequest() {
        return this.request;
    }

    public TARGET getResource() {
        return this.resource;
    }

    public PARENT getParent() {
        return this.parent;
    }

    public INFO getResourceInfo() {
        return this.resourceInfo;
    }
}

