/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc.netty;

import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.grpc.ChannelCredentials;
import org.apache.ratis.thirdparty.io.grpc.ExperimentalApi;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelCredentials;
import org.apache.ratis.thirdparty.io.grpc.netty.ProtocolNegotiators;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContext;

@ExperimentalApi(value="There is no plan to make this API stable, given transport API instability")
public final class NettySslContextChannelCredentials {
    private NettySslContextChannelCredentials() {
    }

    public static ChannelCredentials create(SslContext sslContext) {
        Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
        GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        return NettyChannelCredentials.create(ProtocolNegotiators.tlsClientFactory(sslContext, null));
    }
}

