/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.operation;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;

public class Producer {
    public static void main(String[] args) throws MQClientException, InterruptedException {
        CommandLine commandLine = Producer.buildCommandline(args);
        if (commandLine != null) {
            String group = commandLine.getOptionValue('g');
            String topic = commandLine.getOptionValue('t');
            String tags = commandLine.getOptionValue('a');
            String keys = commandLine.getOptionValue('k');
            String msgCount = commandLine.getOptionValue('c');
            DefaultMQProducer producer = new DefaultMQProducer(group);
            producer.setInstanceName(Long.toString(System.currentTimeMillis()));
            producer.start();
            for (int i = 0; i < Integer.parseInt(msgCount); ++i) {
                try {
                    Message msg = new Message(topic, tags, keys, ("Hello RocketMQ " + i).getBytes("UTF-8"));
                    SendResult sendResult = producer.send(msg);
                    System.out.printf("%-8d %s%n", i, sendResult);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Thread.sleep(1000L);
                }
            }
            producer.shutdown();
        }
    }

    public static CommandLine buildCommandline(String[] args) {
        Options options = new Options();
        Option opt = new Option("h", "help", false, "Print help");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("g", "producerGroup", true, "Producer Group Name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "Topic Name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("a", "tags", true, "Tags Name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("k", "keys", true, "Keys Name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("c", "msgCount", true, "Message Count");
        opt.setRequired(true);
        options.addOption(opt);
        PosixParser parser = new PosixParser();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(110);
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                hf.printHelp("producer", options, true);
                return null;
            }
        }
        catch (ParseException e) {
            hf.printHelp("producer", options, true);
            return null;
        }
        return commandLine;
    }
}

