/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.TokenVisitor;
import org.apache.royale.linter.config.LineCommentPosition;
import org.apache.royale.linter.problems.ILinterProblem;

public class LineCommentPositionRule
extends LinterRule {
    public LineCommentPosition position = LineCommentPosition.ABOVE;

    @Override
    public Map<Integer, TokenVisitor> getTokenVisitors() {
        HashMap<Integer, TokenVisitor> result = new HashMap<Integer, TokenVisitor>();
        result.put(5, (token, tokenQuery, problems) -> this.checkSingleLineComment(token, tokenQuery, problems));
        return result;
    }

    private void checkSingleLineComment(IASToken comment, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IASToken prevToken = tokenQuery.getSignificantTokenBefore((ISourceLocation)comment);
        if (LineCommentPosition.ABOVE.equals((Object)this.position)) {
            if (prevToken == null) {
                return;
            }
            if (prevToken.getLine() == comment.getLine()) {
                problems.add(new LineCommentPositionLinterProblem(comment, this.position));
            }
        } else if (LineCommentPosition.BESIDE.equals((Object)this.position) && (prevToken == null || prevToken.getLine() != comment.getLine())) {
            problems.add(new LineCommentPositionLinterProblem(comment, this.position));
        }
    }

    public static class LineCommentPositionLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Comment must be ${position} code";
        public String position;

        public LineCommentPositionLinterProblem(IASToken token, LineCommentPosition position) {
            super(token);
            this.position = position.getPosition();
        }
    }
}

