/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.swf.Header;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.SWFFrame;
import org.apache.royale.swf.tags.EnableDebugger2Tag;
import org.apache.royale.swf.tags.EnableTelemetryTag;
import org.apache.royale.swf.tags.FileAttributesTag;
import org.apache.royale.swf.tags.MetadataTag;
import org.apache.royale.swf.tags.ProductInfoTag;
import org.apache.royale.swf.tags.ScriptLimitsTag;
import org.apache.royale.swf.types.RGB;
import org.apache.royale.swf.types.Rect;

public class SWF
implements ISWF {
    private final List<SWFFrame> frames = new ArrayList<SWFFrame>();
    private String topLevelClass;
    private FileAttributesTag fileAttributes;
    private MetadataTag metadata;
    private RGB backgroundColor;
    private Header header = new Header();
    private EnableDebugger2Tag enableDebugger2;
    private ScriptLimitsTag scriptLimits;
    private ProductInfoTag productInfoTag;
    private EnableTelemetryTag enableTelemetry;

    public static FileAttributesTag getFileAttributes(ISWF swf) {
        if (swf instanceof SWF) {
            SWF swfObject = (SWF)swf;
            return swfObject.fileAttributes;
        }
        FileAttributesTag tag = new FileAttributesTag();
        tag.setAS3(swf.getUseAS3());
        tag.setHasMetadata(swf.hasMetadata());
        tag.setUseDirectBlit(swf.getUseDirectBlit());
        tag.setUseGPU(swf.getUseGPU());
        tag.setUseNetwork(swf.getUseNetwork());
        return tag;
    }

    public SWF() {
        this.fileAttributes = new FileAttributesTag();
    }

    @Override
    public void addFrame(SWFFrame frame) {
        if (frame == null) {
            throw new NullPointerException();
        }
        this.frames.add(frame);
        this.header.setFrameCount(this.frames.size());
    }

    @Override
    public RGB getBackgroundColor() {
        return this.backgroundColor;
    }

    public FileAttributesTag getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    public SWFFrame getFrameAt(int index) {
        for (int i = this.frames.size(); i <= index; ++i) {
            this.addFrame(new SWFFrame());
        }
        return this.frames.get(index);
    }

    @Override
    public int getFrameCount() {
        return this.header.getFrameCount();
    }

    @Override
    public float getFrameRate() {
        return this.header.getFrameRate();
    }

    public List<SWFFrame> getFrames() {
        return this.frames;
    }

    @Override
    public Rect getFrameSize() {
        return this.header.getFrameSize();
    }

    public Header getHeader() {
        return this.header;
    }

    @Override
    public String getMetadata() {
        return this.metadata == null ? null : this.metadata.getMetadata();
    }

    @Override
    public String getTopLevelClass() {
        return this.topLevelClass;
    }

    @Override
    public int getVersion() {
        return this.header.getVersion();
    }

    @Override
    public boolean hasMetadata() {
        assert (this.fileAttributes.isHasMetadata() == (this.metadata != null));
        return this.fileAttributes.isHasMetadata();
    }

    @Override
    public boolean getUseAS3() {
        return this.fileAttributes.isAS3();
    }

    @Override
    public void setUseAS3(boolean value) {
        this.fileAttributes.setAS3(value);
    }

    @Override
    public void setBackgroundColor(RGB color) {
        assert (color != null);
        this.backgroundColor = color;
    }

    @Override
    public void setFrameRate(float frameRate) {
        this.header.setFrameRate(frameRate);
    }

    @Override
    public void setFrameSize(Rect rect) {
        this.header.setFrameSize(rect);
    }

    @Override
    public void setMetadata(String value) {
        if (value == null) {
            this.metadata = null;
            this.fileAttributes.setHasMetadata(false);
        } else {
            this.metadata = new MetadataTag(value);
            this.fileAttributes.setHasMetadata(true);
        }
    }

    @Override
    public void setTopLevelClass(String value) {
        this.topLevelClass = value;
    }

    @Override
    public void setUseDirectBlit(boolean value) {
        this.fileAttributes.setUseDirectBlit(value);
    }

    @Override
    public void setUseGPU(boolean value) {
        this.fileAttributes.setUseGPU(value);
    }

    @Override
    public void setUseNetwork(boolean value) {
        this.fileAttributes.setUseNetwork(value);
    }

    @Override
    public void setVersion(int version) {
        this.header.setVersion(version);
    }

    @Override
    public boolean getUseDirectBlit() {
        return this.fileAttributes.isUseDirectBlit();
    }

    @Override
    public boolean getUseGPU() {
        return this.fileAttributes.isUseGPU();
    }

    @Override
    public boolean getUseNetwork() {
        return this.fileAttributes.isUseNetwork();
    }

    @Override
    public void deleteFrame(int index) {
        this.frames.remove(index);
    }

    public void setEnableDebugger2(EnableDebugger2Tag tag) {
        this.enableDebugger2 = tag;
    }

    @Override
    public EnableDebugger2Tag getEnableDebugger2() {
        return this.enableDebugger2;
    }

    @Override
    public void setScriptLimits(int maxRecursionDepth, int scriptTimeoutSeconds) {
        this.scriptLimits = new ScriptLimitsTag(maxRecursionDepth, scriptTimeoutSeconds);
    }

    @Override
    public ScriptLimitsTag getScriptLimits() {
        return this.scriptLimits;
    }

    @Override
    public ProductInfoTag getProductInfo() {
        return this.productInfoTag;
    }

    @Override
    public void setProductInfo(ProductInfoTag tag) {
        this.productInfoTag = tag;
    }

    @Override
    public EnableTelemetryTag getEnableTelemetry() {
        return this.enableTelemetry;
    }

    @Override
    public void setEnableTelemetry(EnableTelemetryTag tag) {
        this.enableTelemetry = tag;
    }
}

