/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.as.IOperatorNode;

public abstract class OperatorNodeBase
extends ExpressionNodeBase
implements IOperatorNode {
    protected int operatorStart = -1;

    public OperatorNodeBase(IASToken operator) {
        if (operator != null) {
            this.operatorStart = operator.getStart();
            this.startBefore(operator);
            this.endAfter(operator);
            this.setSourcePath(operator.getSourcePath());
        }
    }

    protected OperatorNodeBase(OperatorNodeBase other) {
        super(other);
        this.operatorStart = other.operatorStart;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getOperatorText());
        sb.append('\"');
        return true;
    }

    @Override
    public int getOperatorStart() {
        OffsetLookup offsetLookup = this.tryGetOffsetLookup();
        return offsetLookup != null ? offsetLookup.getLocalOffset(this.operatorStart) : this.operatorStart;
    }

    @Override
    public int getOperatorEnd() {
        int operatorStart = this.getOperatorStart();
        return operatorStart != -1 ? operatorStart + this.getOperatorText().length() : operatorStart;
    }

    @Override
    public int getOperatorAbsoluteStart() {
        return this.operatorStart;
    }

    @Override
    public int getOperatorAbsoluteEnd() {
        return this.operatorStart != -1 ? this.operatorStart + this.getOperatorText().length() : this.operatorStart;
    }

    public String getOperatorText() {
        IOperatorNode.OperatorType operator = this.getOperator();
        return operator != null ? operator.getOperatorText() : "";
    }
}

