/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IEventDefinition;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.metadata.IEventTriggerTagNode;

public class EventTriggerTagNode
extends MetaTagNode
implements IEventTriggerTagNode {
    private IdentifierNode eventNameNode;

    public EventTriggerTagNode(String tagName) {
        super(tagName);
    }

    public void setEventName(IdentifierNode eventNameNode) {
        this.eventNameNode = eventNameNode;
        eventNameNode.setParent(this);
        this.addToMap(SINGLE_VALUE, this.getEventName());
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addChildInOrder(this.eventNameNode, fillInOffsets);
    }

    @Override
    protected int getInitialChildCount() {
        return 1;
    }

    public IEventDefinition resolveEventTag(ICompilerProject project) {
        if (this.eventNameNode == null) {
            return null;
        }
        IDefinitionNode classNode = this.getDecoratedDefinitionNode();
        IClassDefinition classDefinition = (IClassDefinition)classNode.getDefinition();
        return classDefinition.getEventDefinition(project.getWorkspace(), this.getEventName());
    }

    public String getEventName() {
        return this.eventNameNode != null ? this.eventNameNode.getName() : "";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EventTriggerTagNode) {
            if (!this.equals(((EventTriggerTagNode)obj).eventNameNode, this.eventNameNode)) {
                return false;
            }
        } else {
            return false;
        }
        return super.equals(obj);
    }
}

