/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.clients.ASC;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.as.codegen.CodeGeneratorManager;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.DeferFunctionBody;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.XMLLiteralNode;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.requests.ABCBytesRequestResult;
import org.apache.royale.compiler.internal.units.requests.ASFileScopeRequestResult;
import org.apache.royale.compiler.internal.units.requests.SWFTagsRequestResult;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.IASProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFileNodeAccumulator;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.IABCBytesRequestResult;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;
import org.apache.royale.compiler.units.requests.IOutgoingDependenciesRequestResult;
import org.apache.royale.compiler.units.requests.IRequest;
import org.apache.royale.compiler.units.requests.ISWFTagsRequestResult;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.royale.utils.JSXUtil;

public class ASCompilationUnit
extends CompilationUnitBase {
    private final String qname;
    private final List<String> includedFiles = new ArrayList<String>();
    private static Comparator<IDefinition> SCRIPT_NAME_DEFINITION_COMPARATOR = new Comparator<IDefinition>(){

        @Override
        public int compare(IDefinition arg0, IDefinition arg1) {
            int result = arg0.getAbsoluteStart() - arg1.getAbsoluteEnd();
            if (result != 0) {
                return result;
            }
            result = arg0.getQualifiedName().compareTo(arg1.getQualifiedName());
            return result;
        }
    };

    public static ASCompilationUnit createMainCompilationUnitForASC(CompilerProject project, IFileSpecification mainFile, ASC asc) {
        assert (project != null) : "Expecting project.";
        assert (mainFile != null) : "Expecting main file.";
        assert (asc != null) : "Expecting ASC client.";
        ASCompilationUnit mainCompilationUnit = new ASCompilationUnit(project, mainFile.getPath(), DefinitionPriority.BasePriority.SOURCE_LIST);
        mainCompilationUnit.includedFiles.addAll(asc.getIncludeFilenames());
        return mainCompilationUnit;
    }

    public ASCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority) {
        this(project, path, basePriority, 0);
    }

    public ASCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, int order) {
        this(project, path, basePriority, order, null);
    }

    public ASCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority basePriority, int order, String qname) {
        super(project, path, basePriority, qname);
        this.qname = qname;
        ((DefinitionPriority)this.getDefinitionPriority()).setOrder(order);
    }

    @Override
    public ICompilationUnit.UnitType getCompilationUnitType() {
        return ICompilationUnit.UnitType.AS_UNIT;
    }

    protected FileNode createFileNode(IFileSpecification specification) {
        DeferFunctionBody deferFunctionBody = !this.isInvisible() && specification instanceof FileSpecification ? DeferFunctionBody.ENABLED : DeferFunctionBody.DISABLED;
        IASProject flashProject = this.getProject() instanceof IASProject ? (IASProject)((Object)this.getProject()) : null;
        return ASParser.parseFile(specification, this.getFileSpecificationGetter(), EnumSet.of(PostProcessStep.CALCULATE_OFFSETS), this.getProject().getProjectConfigVariables(), true, this.getProject().isAssetEmbeddingSupported(), this.getProject().getStrictIdentifierNames(), this.includedFiles, deferFunctionBody, flashProject, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISyntaxTreeRequestResult handleSyntaxTreeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        try {
            IRequest syntaxTreeRequest = (IRequest)this.syntaxTreeRequest.get();
            FileNode ast = this.createFileNode(this.getRootFileSpecification());
            IRequest fileScopeRequest = (IRequest)this.fileScopeRequest.get();
            if (fileScopeRequest != null && fileScopeRequest.isDone()) {
                ast.reconnectDefinitions((ASFileScope)((IFileScopeRequestResult)fileScopeRequest.get()).getScopes()[0]);
            } else {
                this.getProject().clearScopeCacheForCompilationUnit(this);
                ast.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
            }
            ImmutableSet<String> includedFiles = ast.getIncludeHandler().getIncludedFiles();
            this.addScopeToProjectScope(new ASFileScope[]{ast.getFileScope()});
            if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                System.out.println("ASCompilationUnit waiting for lock in parseRequiredFunctionBodies");
            }
            ast.parseRequiredFunctionBodies();
            if ((CompilerDiagnosticsConstants.diagnostics & 0x80) == 128) {
                System.out.println("ASCompilationUnit done with lock in parseRequiredFunctionBodies");
            }
            Collection<ICompilerProblem> problemCollection = ast.getProblems();
            ASSyntaxTreeRequestResult result = new ASSyntaxTreeRequestResult(this, syntaxTreeRequest, ast, includedFiles, ast.getIncludeTreeLastModified(), problemCollection);
            this.getProject().getWorkspace().addIncludedFilesToCompilationUnit(this, (Collection<String>)result.getIncludedFiles());
            this.getProject().addToASTCache(ast);
            ASSyntaxTreeRequestResult aSSyntaxTreeRequestResult = result;
            return aSSyntaxTreeRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SYNTAX_TREE);
        }
    }

    @Override
    protected IFileScopeRequestResult handleFileScopeRequest() throws InterruptedException {
        this.startProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        FileNode ast = (FileNode)this.getSyntaxTreeRequest().get().getAST();
        IASScope scope = ast.getScope();
        assert (scope instanceof ASFileScope) : "Expect ASFileScope as the top-level scope, but found " + scope.getClass();
        IFileSpecification rootSource = this.getRootFileSpecification();
        ASFileScopeRequestResult result = new ASFileScopeRequestResult(this.getDefinitionPromises(), this.getDefinitionPriority(), Collections.emptyList(), (ASFileScope)scope, rootSource);
        this.stopProfile(ICompilationUnit.Operation.GET_FILESCOPE);
        this.addProblemsToProject(result);
        return result;
    }

    protected void addProblemsToProject(ASFileScopeRequestResult result) {
        Collection<ICompilationUnit> units = this.getProject().getIncludingCompilationUnits(this.getAbsoluteFilename());
        if (units != null && units.size() > 0) {
            return;
        }
        Collections.addAll(this.getProject().getProblems(), result.getProblems());
    }

    @Override
    protected IABCBytesRequestResult handleABCBytesRequest() throws InterruptedException {
        ISyntaxTreeRequestResult fsr = this.getSyntaxTreeRequest().get();
        IASNode rootNode = fsr.getAST();
        CompilerProject project = this.getProject();
        this.startProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        ABCBytesRequestResult result = CodeGeneratorManager.getCodeGenerator().generate(project.getWorkspace().getExecutorService(), project.getUseParallelCodeGeneration(), this.getFilenameNoPath(), rootNode, this.getProject(), this.isInvisible(), this.getEncodedDebugFiles());
        this.stopProfile(ICompilationUnit.Operation.GET_ABC_BYTES);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISWFTagsRequestResult handleSWFTagsRequest() throws InterruptedException {
        IABCBytesRequestResult abc = this.getABCBytesRequest().get();
        this.startProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        try {
            String tagName;
            if (Strings.isNullOrEmpty((String)this.qname)) {
                IFileScopeRequestResult fileScopeRR = this.getFileScopeRequest().get();
                Collection<IDefinition> externallyVisibleDefinitions = fileScopeRR.getExternallyVisibleDefinitions();
                if (!externallyVisibleDefinitions.isEmpty()) {
                    ArrayList sortedDefinitions = new ArrayList(externallyVisibleDefinitions.size());
                    Iterables.addAll(sortedDefinitions, externallyVisibleDefinitions);
                    Collections.sort(sortedDefinitions, SCRIPT_NAME_DEFINITION_COMPARATOR);
                    tagName = ((IDefinition)sortedDefinitions.get(0)).getQualifiedName().replace('.', '/');
                } else {
                    tagName = this.getName();
                }
            } else {
                tagName = this.qname.replace('.', '/');
            }
            SWFTagsRequestResult sWFTagsRequestResult = new SWFTagsRequestResult(abc.getABCBytes(), tagName, abc.getEmbeds());
            return sWFTagsRequestResult;
        }
        finally {
            this.stopProfile(ICompilationUnit.Operation.GET_SWF_TAGS);
        }
    }

    @Override
    protected IOutgoingDependenciesRequestResult handleOutgoingDependenciesRequest() throws InterruptedException {
        ISyntaxTreeRequestResult fsr = this.getSyntaxTreeRequest().get();
        FileNode fn = (FileNode)fsr.getAST();
        this.startParsingImports(fn);
        this.startProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        this.getABCBytesRequest().get();
        this.updateEmbedCompilationUnitDependencies(fn.getEmbedNodes(), problems);
        this.updateJSXDependencies(fn);
        IOutgoingDependenciesRequestResult result = new IOutgoingDependenciesRequestResult(){

            @Override
            public ICompilerProblem[] getProblems() {
                return IOutgoingDependenciesRequestResult.NO_PROBLEMS;
            }
        };
        this.stopProfile(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS);
        return result;
    }

    private void updateJSXDependencies(IASNode node) throws InterruptedException {
        block4: {
            block3: {
                IFunctionNode functionNode;
                if (node instanceof FunctionNode && JSXUtil.hasJSXMetadata(functionNode = (FunctionNode)node)) {
                    functionNode.parseFunctionBody(new ArrayList<ICompilerProblem>());
                }
                if (!(node instanceof XMLLiteralNode)) break block3;
                functionNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
                if (functionNode == null || !JSXUtil.hasJSXMetadata(functionNode)) break block4;
                XMLLiteralNode xmlNode = (XMLLiteralNode)node;
                CompilerProject project = this.getProject();
                ArrayList<String> qualifiedNames = new ArrayList<String>();
                JSXUtil.findQualifiedNamesInXMLLiteral(xmlNode, project, qualifiedNames);
                for (String qualifiedName : qualifiedNames) {
                    ICompilationUnit cu = project.resolveQNameToCompilationUnit(qualifiedName);
                    if (cu == null) continue;
                    project.addDependency((ICompilationUnit)this, cu, DependencyType.EXPRESSION, cu.getQualifiedNames().get(0));
                }
                break block4;
            }
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.updateJSXDependencies(node.getChild(i));
            }
        }
    }

    @Override
    protected void removeAST() {
        block4: {
            IRequest syntaxTreeRequest = (IRequest)this.syntaxTreeRequest.get();
            boolean canRemoveAST = this.operationsCompleted(EnumSet.of(ICompilationUnit.Operation.GET_SEMANTIC_PROBLEMS, ICompilationUnit.Operation.GET_ABC_BYTES));
            if (canRemoveAST) {
                try {
                    assert (syntaxTreeRequest != null);
                    ((ASSyntaxTreeRequestResult)syntaxTreeRequest.get()).dropASTRef();
                }
                catch (InterruptedException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"Syntax should have already been built");
                }
            }
        }
    }

    private ClassNode findFirstClassNode(IASNode node) {
        ClassNode classNode = null;
        if (node instanceof ClassNode) {
            classNode = (ClassNode)node;
        } else {
            for (int i = 0; i < node.getChildCount() && (classNode = this.findFirstClassNode(node.getChild(i))) == null; ++i) {
            }
        }
        return classNode;
    }

    public String getRootClassName() throws InterruptedException {
        IASNode fileNode = this.getSyntaxTreeRequest().get().getAST();
        ClassNode classNode = this.findFirstClassNode(fileNode);
        String rootClassName = classNode.getName();
        return rootClassName;
    }

    private static class ASSyntaxTreeRequestResult
    implements ISyntaxTreeRequestResult {
        private final WeakReference<ASCompilationUnit> ownerRef;
        private final IRequest<ISyntaxTreeRequestResult, ICompilationUnit> syntaxTreeRequest;
        private final HardToWeakRef<IASNode> astRef;
        private final ImmutableSet<String> includedFiles;
        private final long lastModified;
        private final ICompilerProblem[] problems;

        ASSyntaxTreeRequestResult(ASCompilationUnit owner, IRequest<ISyntaxTreeRequestResult, ICompilationUnit> syntaxTreeRequest, IASNode ast, ImmutableSet<String> includedFiles, long lastModified, Collection<ICompilerProblem> problems) {
            this.ownerRef = new WeakReference<ASCompilationUnit>(owner);
            this.syntaxTreeRequest = syntaxTreeRequest;
            this.astRef = new HardToWeakRef<IASNode>(ast);
            this.includedFiles = includedFiles;
            this.problems = problems.toArray(new ICompilerProblem[problems.size()]);
            this.lastModified = lastModified;
        }

        @Override
        public ICompilerProblem[] getProblems() {
            return this.problems;
        }

        @Override
        public IASNode getAST() throws InterruptedException {
            IASNode result = this.astRef.get();
            if (result != null) {
                return result;
            }
            ASCompilationUnit owner = (ASCompilationUnit)this.ownerRef.get();
            if (owner == null) {
                return null;
            }
            owner.syntaxTreeRequest.compareAndSet(this.syntaxTreeRequest, null);
            return owner.getSyntaxTreeRequest().get().getAST();
        }

        public void dropASTRef() {
            this.astRef.makeWeak();
        }

        @Override
        public Set<String> getRequiredResourceBundles() throws InterruptedException {
            IASNode tree = this.getAST();
            if (tree instanceof IFileNodeAccumulator) {
                return ((IFileNodeAccumulator)((Object)tree)).getRequiredResourceBundles();
            }
            return Collections.emptySet();
        }

        @Override
        public ImmutableSet<String> getIncludedFiles() {
            return this.includedFiles;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }

        private static class HardToWeakRef<T>
        extends WeakReference<T> {
            private T referent;

            public HardToWeakRef(T referent) {
                super(referent);
                this.referent = referent;
            }

            public void makeWeak() {
                this.referent = null;
            }

            @Override
            public T get() {
                T referent = this.referent;
                if (referent != null) {
                    return referent;
                }
                return super.get();
            }
        }
    }
}

