/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.route;

import java.util.Collection;
import org.apache.shardingsphere.broadcast.route.engine.BroadcastRouteEngineFactory;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.lifecycle.EntranceSQLRouter;
import org.apache.shardingsphere.infra.session.query.QueryContext;

public final class BroadcastSQLRouter
implements EntranceSQLRouter<BroadcastRule> {
    public RouteContext createRouteContext(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, BroadcastRule rule, Collection<String> tableNames, ConfigurationProperties props) {
        Collection<String> broadcastTableNames = rule.getBroadcastTableNames(tableNames);
        if (broadcastTableNames.isEmpty()) {
            return new RouteContext();
        }
        return BroadcastRouteEngineFactory.newInstance(queryContext, broadcastTableNames).route(rule);
    }

    public SQLRouter.Type getType() {
        return SQLRouter.Type.DATA_NODE;
    }

    public int getOrder() {
        return 15;
    }

    public Class<BroadcastRule> getTypeClass() {
        return BroadcastRule.class;
    }
}

