/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.parser.rule;

import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.parser.config.SQLParserRuleConfiguration;
import org.apache.shardingsphere.sql.parser.api.CacheOption;

public final class SQLParserRule
implements GlobalRule {
    private final SQLParserRuleConfiguration configuration;
    private final CacheOption sqlStatementCache;
    private final CacheOption parseTreeCache;

    public SQLParserRule(SQLParserRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.sqlStatementCache = ruleConfig.getSqlStatementCache();
        this.parseTreeCache = ruleConfig.getParseTreeCache();
    }

    public SQLParserEngine getSQLParserEngine(DatabaseType databaseType) {
        return new ShardingSphereSQLParserEngine(databaseType, this.sqlStatementCache, this.parseTreeCache);
    }

    public int getOrder() {
        return 700;
    }

    @Generated
    public SQLParserRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public CacheOption getSqlStatementCache() {
        return this.sqlStatementCache;
    }

    @Generated
    public CacheOption getParseTreeCache() {
        return this.parseTreeCache;
    }
}

